/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.commands.EnvironmentCommand;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import com.pneumaticraft.commandhandler.multiverse.CommandHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;

public class ImportCommand
extends MultiverseCommand {
    private MVWorldManager worldManager;

    public ImportCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Import World");
        this.setCommandUsage("/mv import" + ChatColor.GREEN + " {NAME} {ENV}" + ChatColor.GOLD + " -g [GENERATOR[:ID]] [-n]");
        this.setArgRange(1, 5);
        this.addKey("mvimport");
        this.addKey("mvim");
        this.addKey("mv import");
        this.addCommandExample("/mv import " + ChatColor.GOLD + "gargamel" + ChatColor.GREEN + " normal");
        this.addCommandExample("/mv import " + ChatColor.GOLD + "hell_world" + ChatColor.GREEN + " nether");
        this.addCommandExample("To import a world that uses a generator, you'll need the generator:");
        this.addCommandExample("/mv import " + ChatColor.GOLD + "CleanRoom" + ChatColor.GREEN + " normal" + ChatColor.DARK_AQUA + " CleanRoomGenerator");
        this.setPermission("multiverse.core.import", "Imports a new world of the specified type.", PermissionDefault.OP);
        this.worldManager = this.plugin.getMVWorldManager();
    }

    private static boolean checkIfIsWorld(File worldFolder) {
        File[] files;
        return worldFolder.isDirectory() && (files = worldFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.equalsIgnoreCase("level.dat");
            }
        })) != null && files.length > 0;
    }

    private String getPotentialWorlds() {
        File worldFolder = this.plugin.getServer().getWorldContainer();
        if (worldFolder == null) {
            return "";
        }
        File[] files = worldFolder.listFiles();
        String worldList = "";
        Collection<MultiverseWorld> worlds = this.worldManager.getMVWorlds();
        ArrayList<String> worldStrings = new ArrayList<String>();
        for (MultiverseWorld multiverseWorld : worlds) {
            worldStrings.add(multiverseWorld.getName());
        }
        for (String string : this.worldManager.getUnloadedWorlds()) {
            worldStrings.add(string);
        }
        ChatColor currColor = ChatColor.WHITE;
        for (File file : files) {
            if (!file.isDirectory() || !ImportCommand.checkIfIsWorld(file) || worldStrings.contains(file.getName())) continue;
            worldList = worldList + currColor + file.getName() + " ";
            currColor = currColor == ChatColor.WHITE ? ChatColor.YELLOW : ChatColor.WHITE;
        }
        return worldList;
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        String worldName = args.get(0);
        if (worldName.toLowerCase().equals("--list") || worldName.toLowerCase().equals("-l")) {
            String worldList = this.getPotentialWorlds();
            if (worldList.length() > 2) {
                sender.sendMessage(ChatColor.AQUA + "====[ These look like worlds ]====");
                sender.sendMessage(worldList);
            } else {
                sender.sendMessage(ChatColor.RED + "No potential worlds found. Sorry!");
            }
            return;
        }
        if (args.size() == 1) {
            this.showHelp(sender);
            return;
        }
        if (this.worldManager.isMVWorld(worldName)) {
            sender.sendMessage(ChatColor.GREEN + "Multiverse" + ChatColor.WHITE + " already knows about '" + ChatColor.AQUA + worldName + ChatColor.WHITE + "'!");
            return;
        }
        File worldFile = new File(this.plugin.getServer().getWorldContainer(), worldName);
        String generator = CommandHandler.getFlag("-g", args);
        boolean useSpawnAdjust = true;
        for (String s : args) {
            if (!s.equalsIgnoreCase("-n")) continue;
            useSpawnAdjust = false;
        }
        String env = args.get(1);
        World.Environment environment = EnvironmentCommand.getEnvFromString(env);
        if (environment == null) {
            sender.sendMessage(ChatColor.RED + "That is not a valid environment.");
            EnvironmentCommand.showEnvironments(sender);
            return;
        }
        if (worldFile.exists() && env != null) {
            Command.broadcastCommandMessage((CommandSender)sender, (String)String.format("Starting import of world '%s'...", worldName));
            if (this.worldManager.addWorld(worldName, environment, null, null, null, generator, useSpawnAdjust)) {
                Command.broadcastCommandMessage((CommandSender)sender, (String)(ChatColor.GREEN + "Complete!"));
            } else {
                Command.broadcastCommandMessage((CommandSender)sender, (String)(ChatColor.RED + "Failed!"));
            }
        } else if (env == null) {
            sender.sendMessage(ChatColor.RED + "FAILED.");
            sender.sendMessage("That world environment did not exist.");
            sender.sendMessage("For a list of available world types, type: " + ChatColor.AQUA + "/mvenv");
        } else {
            sender.sendMessage(ChatColor.RED + "FAILED.");
            String worldList = this.getPotentialWorlds();
            sender.sendMessage("That world folder does not exist. These look like worlds to me:");
            sender.sendMessage(worldList);
        }
    }
}

