/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class AnchorManager {
    private MultiverseCore plugin;
    private Map<String, Location> anchors;
    private FileConfiguration anchorConfig;

    public AnchorManager(MultiverseCore plugin) {
        this.plugin = plugin;
        this.anchors = new HashMap<String, Location>();
    }

    public void loadAnchors() {
        this.anchors = new HashMap<String, Location>();
        this.anchorConfig = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "anchors.yml"));
        this.ensureConfigIsPrepared();
        ConfigurationSection anchorsSection = this.anchorConfig.getConfigurationSection("anchors");
        Set anchorKeys = anchorsSection.getKeys(false);
        for (String key : anchorKeys) {
            Location anchorLocation = this.plugin.getLocationManipulation().stringToLocation(anchorsSection.getString(key, ""));
            if (anchorLocation != null) {
                CoreLogging.config("Loading anchor:  '%s'...", key);
                this.anchors.put(key, anchorLocation);
                continue;
            }
            CoreLogging.warning("The location for anchor '%s' is INVALID.", key);
        }
    }

    private void ensureConfigIsPrepared() {
        if (this.anchorConfig.getConfigurationSection("anchors") == null) {
            this.anchorConfig.createSection("anchors");
        }
    }

    public boolean saveAnchors() {
        try {
            this.anchorConfig.save(new File(this.plugin.getDataFolder(), "anchors.yml"));
            return true;
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "Failed to save anchors.yml. Please check your file permissions.");
            return false;
        }
    }

    public Location getAnchorLocation(String anchor) {
        if (this.anchors.containsKey(anchor)) {
            return this.anchors.get(anchor);
        }
        return null;
    }

    public boolean saveAnchorLocation(String anchor, String location) {
        Location parsed = this.plugin.getLocationManipulation().stringToLocation(location);
        return parsed != null && this.saveAnchorLocation(anchor, parsed);
    }

    public boolean saveAnchorLocation(String anchor, Location l) {
        if (l == null) {
            return false;
        }
        this.anchorConfig.set("anchors." + anchor, (Object)this.plugin.getLocationManipulation().locationToString(l));
        this.anchors.put(anchor, l);
        return this.saveAnchors();
    }

    public Set<String> getAllAnchors() {
        return Collections.unmodifiableSet(this.anchors.keySet());
    }

    public Set<String> getAnchors(Player p) {
        if (p == null) {
            return this.anchors.keySet();
        }
        HashSet<String> myAnchors = new HashSet<String>();
        for (String anchor : this.anchors.keySet()) {
            Location ancLoc = this.anchors.get(anchor);
            if (ancLoc == null || !p.hasPermission("multiverse.access." + ancLoc.getWorld().getName())) continue;
            myAnchors.add(anchor);
        }
        return Collections.unmodifiableSet(myAnchors);
    }

    public boolean deleteAnchor(String s) {
        if (this.anchors.containsKey(s)) {
            this.anchors.remove(s);
            this.anchorConfig.set("anchors." + s, null);
            return this.saveAnchors();
        }
        return false;
    }
}

