/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.api.Core;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.util.concurrent.Callable;

public class UnsafeCallWrapper {
    private final Core core;

    public UnsafeCallWrapper(Core core) {
        this.core = core;
    }

    public <T> T wrap(Callable<T> callable, String plugin, String action, Object ... formatArgs) {
        try {
            return callable.call();
        }
        catch (Throwable t) {
            Object[] actualFormatArgs = new Object[formatArgs.length + 1];
            System.arraycopy(formatArgs, 0, actualFormatArgs, 0, formatArgs.length);
            actualFormatArgs[formatArgs.length] = t;
            CoreLogging.warning(action, actualFormatArgs);
            CoreLogging.warning("This is a bug in %s, NOT a bug in Multiverse!", plugin);
            if (this.core.getMVConfig().getGlobalDebug() >= 1) {
                t.printStackTrace();
            }
            return null;
        }
    }
}

