/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.spawn;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.Kit;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.User;
import com.earth2me.essentials.spawn.SpawnStorage;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.SimpleTextPager;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

class EssentialsSpawnPlayerListener
implements Listener {
    private static final Logger logger = Logger.getLogger("EssentialsSpawn");
    private final transient IEssentials ess;
    private final transient SpawnStorage spawns;

    EssentialsSpawnPlayerListener(IEssentials ess, SpawnStorage spawns) {
        this.ess = ess;
        this.spawns = spawns;
    }

    void onPlayerRespawn(PlayerRespawnEvent event) {
        Location spawn;
        User user = this.ess.getUser(event.getPlayer());
        if (user.isJailed() && user.getJail() != null && !user.getJail().isEmpty()) {
            return;
        }
        if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_16_1_R01) && event.isAnchorSpawn() && this.ess.getSettings().isRespawnAtAnchor()) {
            return;
        }
        if (this.ess.getSettings().getRespawnAtHome()) {
            Location home;
            Location bed = null;
            if (this.ess.getSettings().isRespawnAtBed()) {
                bed = user.getBase().getBedSpawnLocation();
            }
            if ((home = bed != null ? bed : user.getHome(user.getLocation())) != null) {
                event.setRespawnLocation(home);
                return;
            }
        }
        if ((spawn = this.spawns.getSpawn(user.getGroup())) != null) {
            event.setRespawnLocation(spawn);
        }
    }

    void onPlayerJoin(PlayerJoinEvent event) {
        this.ess.runTaskAsynchronously(() -> this.delayedJoin(event.getPlayer()));
    }

    private void delayedJoin(Player player) {
        if (player.hasPlayedBefore()) {
            logger.log(Level.FINE, "Old player join");
            List spawnOnJoinGroups = this.ess.getSettings().getSpawnOnJoinGroups();
            if (!spawnOnJoinGroups.isEmpty()) {
                User user = this.ess.getUser(player);
                if (this.ess.getSettings().isUserInSpawnOnJoinGroup((IUser)user) && !user.isAuthorized("essentials.spawn-on-join.exempt")) {
                    this.ess.scheduleSyncDelayedTask(() -> {
                        Location spawn = this.spawns.getSpawn(user.getGroup());
                        if (spawn == null) {
                            return;
                        }
                        CompletableFuture future = new CompletableFuture();
                        future.exceptionally(e -> {
                            this.ess.showError(user.getSource(), e, "spawn-on-join");
                            return false;
                        });
                        user.getAsyncTeleport().nowUnsafe(spawn, PlayerTeleportEvent.TeleportCause.PLUGIN, future);
                    });
                }
            }
            return;
        }
        User user = this.ess.getUser(player);
        if (!"none".equalsIgnoreCase(this.ess.getSettings().getNewbieSpawn())) {
            this.ess.scheduleSyncDelayedTask((Runnable)new NewPlayerTeleport(user), 1L);
        }
        this.ess.scheduleSyncDelayedTask(() -> {
            String kitName;
            if (!user.getBase().isOnline()) {
                return;
            }
            if (this.ess.getSettings().getAnnounceNewPlayers()) {
                KeywordReplacer output = new KeywordReplacer(this.ess.getSettings().getAnnounceNewPlayerFormat(), user.getSource(), this.ess);
                SimpleTextPager pager = new SimpleTextPager((IText)output);
                for (String line : pager.getLines()) {
                    this.ess.broadcastMessage((IUser)user, line);
                }
            }
            if (!(kitName = this.ess.getSettings().getNewPlayerKit()).isEmpty()) {
                try {
                    Kit kit = new Kit(kitName.toLowerCase(Locale.ENGLISH), this.ess);
                    kit.expandItems(user);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, ex.getMessage());
                }
            }
            logger.log(Level.FINE, "New player join");
        }, 2L);
    }

    private class NewPlayerTeleport
    implements Runnable {
        private final transient User user;

        NewPlayerTeleport(User user) {
            this.user = user;
        }

        @Override
        public void run() {
            if (this.user.getBase() instanceof OfflinePlayer || !this.user.getBase().isOnline()) {
                return;
            }
            Location spawn = EssentialsSpawnPlayerListener.this.spawns.getSpawn(EssentialsSpawnPlayerListener.this.ess.getSettings().getNewbieSpawn());
            if (spawn != null) {
                CompletableFuture future = new CompletableFuture();
                future.exceptionally(e -> {
                    logger.log(Level.WARNING, I18n.tl((String)"teleportNewPlayerError", (Object[])new Object[0]), (Throwable)e);
                    return false;
                });
                this.user.getAsyncTeleport().now(spawn, false, PlayerTeleportEvent.TeleportCause.PLUGIN, future);
            }
        }
    }
}

