/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.spawn;

import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.config.entities.LazyLocation;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.ess3.api.IEssentials;
import org.bukkit.Location;
import org.bukkit.World;

public class SpawnStorage
implements IEssentialsModule,
IConf {
    private final IEssentials ess;
    private final EssentialsConfiguration config;
    private final Map<String, LazyLocation> spawns = new HashMap<String, LazyLocation>();

    SpawnStorage(IEssentials ess) {
        this.ess = ess;
        this.config = new EssentialsConfiguration(new File(ess.getDataFolder(), "spawn.yml"));
        this.reloadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfig() {
        Map<String, LazyLocation> map = this.spawns;
        synchronized (map) {
            this.config.load();
            this.spawns.clear();
            this.spawns.putAll(this.config.getLocationSectionMap("spawns"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSpawn(Location loc, String group) {
        group = group.toLowerCase(Locale.ENGLISH);
        Map<String, LazyLocation> map = this.spawns;
        synchronized (map) {
            this.spawns.put(group, LazyLocation.fromLocation((Location)loc));
            this.config.setProperty("spawns." + group, loc);
            this.config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Location getSpawn(String group) {
        if (group == null) {
            return this.getWorldSpawn();
        }
        group = group.toLowerCase(Locale.ENGLISH);
        Map<String, LazyLocation> map = this.spawns;
        synchronized (map) {
            if (!this.spawns.containsKey(group)) {
                if (this.spawns.containsKey("default")) {
                    return this.spawns.get("default").location();
                }
                return this.getWorldSpawn();
            }
            return this.spawns.get(group).location();
        }
    }

    private Location getWorldSpawn() {
        for (World world : this.ess.getServer().getWorlds()) {
            if (world.getEnvironment() != World.Environment.NORMAL) continue;
            return world.getSpawnLocation();
        }
        return ((World)this.ess.getServer().getWorlds().get(0)).getSpawnLocation();
    }
}

