/*
 * Decompiled with CFR 0.152.
 */
package me.Sohqil.ArenaSetup.Commands;

import com.andrei1058.bedwars.api.BedWars;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.Sohqil.ArenaSetup.ArenaSetup;
import me.Sohqil.ArenaSetup.Utils;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class BedWarsSetup
implements CommandExecutor,
TabCompleter {
    private final ArenaSetup plugin = ArenaSetup.getPlugin();
    private final ItemStack bwSpawn;
    private final ItemStack specSpawn;
    private final ItemStack createTeams;
    private final ItemStack waitingLoc1;
    private final ItemStack waitingLoc2;
    private final ItemStack spawnSetup;
    private final ItemStack teamSpawn;
    private final ItemStack teamGenerator;
    private final ItemStack killDrops;
    private final ItemStack centerView;
    private final ItemStack teamShop;
    private final ItemStack teamUpgrade;
    private final ItemStack generatorSetup;
    private final ItemStack emeraldGenerator;
    private final ItemStack diamondGenerator;
    private final ItemStack bwSave;

    public BedWarsSetup() {
        this.plugin.getCommand("bwsetup").setExecutor((CommandExecutor)this);
        this.bwSpawn = this.getMaterial("Waiting.lobbySpawn");
        ItemMeta bwSpawnMeta = this.bwSpawn.getItemMeta();
        bwSpawnMeta.setDisplayName(this.a("Waiting.lobbySpawn"));
        this.bwSpawn.setItemMeta(bwSpawnMeta);
        this.specSpawn = this.getMaterial("Waiting.spectatorSpawn");
        ItemMeta specSpawnMeta = this.specSpawn.getItemMeta();
        specSpawnMeta.setDisplayName(this.a("Waiting.spectatorSpawn"));
        this.specSpawn.setItemMeta(specSpawnMeta);
        this.createTeams = this.getMaterial("Waiting.createTeams");
        ItemMeta createTeamsMeta = this.createTeams.getItemMeta();
        createTeamsMeta.setDisplayName(this.a("Waiting.createTeams"));
        this.createTeams.setItemMeta(createTeamsMeta);
        this.waitingLoc1 = this.getMaterial("Waiting.waitingLoc1");
        ItemMeta waitingLoc1Meta = this.waitingLoc1.getItemMeta();
        waitingLoc1Meta.setDisplayName(this.a("Waiting.waitingLoc1"));
        this.waitingLoc1.setItemMeta(waitingLoc1Meta);
        this.waitingLoc2 = this.getMaterial("Waiting.waitingLoc2");
        ItemMeta waitingLoc2Meta = this.waitingLoc2.getItemMeta();
        waitingLoc2Meta.setDisplayName(this.a("Waiting.waitingLoc2"));
        this.waitingLoc2.setItemMeta(waitingLoc2Meta);
        this.spawnSetup = this.getMaterial("General.goToSpawnSetup");
        ItemMeta spawnSetupMeta = this.spawnSetup.getItemMeta();
        spawnSetupMeta.setDisplayName(this.a("General.goToSpawnSetup"));
        this.spawnSetup.setItemMeta(spawnSetupMeta);
        this.teamSpawn = this.getMaterial("Spawn.teamSpawn");
        ItemMeta teamSpawnMeta = this.teamSpawn.getItemMeta();
        teamSpawnMeta.setDisplayName(this.a("Spawn.teamSpawn"));
        this.teamSpawn.setItemMeta(teamSpawnMeta);
        this.teamGenerator = this.getMaterial("Spawn.teamGenerator");
        ItemMeta teamGeneratorMeta = this.teamGenerator.getItemMeta();
        teamGeneratorMeta.setDisplayName(this.a("Spawn.teamGenerator"));
        this.teamGenerator.setItemMeta(teamGeneratorMeta);
        this.killDrops = this.getMaterial("Spawn.killDrops");
        ItemMeta killDropsMeta = this.killDrops.getItemMeta();
        killDropsMeta.setDisplayName(this.a("Spawn.killDrops"));
        this.killDrops.setItemMeta(killDropsMeta);
        this.centerView = this.getMaterial("General.teleportToCenter");
        ItemMeta centerViewMeta = this.centerView.getItemMeta();
        centerViewMeta.setDisplayName(this.a("General.teleportToCenter"));
        this.centerView.setItemMeta(centerViewMeta);
        this.teamShop = this.getMaterial("Spawn.setShop");
        ItemMeta teamShopMeta = this.teamShop.getItemMeta();
        teamShopMeta.setDisplayName(this.a("Spawn.setShop"));
        this.teamShop.setItemMeta(teamShopMeta);
        this.teamUpgrade = this.getMaterial("Spawn.setUpgrade");
        ItemMeta teamUpgradeMeta = this.teamUpgrade.getItemMeta();
        teamUpgradeMeta.setDisplayName(this.a("Spawn.setUpgrade"));
        this.teamUpgrade.setItemMeta(teamUpgradeMeta);
        this.generatorSetup = this.getMaterial("General.goToGeneratorSetup");
        ItemMeta generatorSetupMeta = this.generatorSetup.getItemMeta();
        generatorSetupMeta.setDisplayName(this.a("General.goToGeneratorSetup"));
        this.generatorSetup.setItemMeta(generatorSetupMeta);
        this.emeraldGenerator = this.getMaterial("Generators.emeraldGenerator");
        ItemMeta emeraldGeneratorMeta = this.emeraldGenerator.getItemMeta();
        emeraldGeneratorMeta.setDisplayName(this.a("Generators.emeraldGenerator"));
        this.emeraldGenerator.setItemMeta(emeraldGeneratorMeta);
        this.diamondGenerator = this.getMaterial("Generators.diamondGenerator");
        ItemMeta diamondGeneratorMeta = this.diamondGenerator.getItemMeta();
        diamondGeneratorMeta.setDisplayName(this.a("Generators.diamondGenerator"));
        this.diamondGenerator.setItemMeta(diamondGeneratorMeta);
        this.bwSave = this.getMaterial("General.saveArena");
        ItemMeta bwSaveMeta = this.bwSave.getItemMeta();
        bwSaveMeta.setDisplayName(this.a("General.saveArena"));
        this.bwSave.setItemMeta(bwSaveMeta);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfig().getString("Messages.Errors.notPlayer"));
            return true;
        }
        Player p = (Player)sender;
        if (!p.hasPermission("arenasetup.admin")) {
            this.sendMessage(p, "Errors.noPermission");
            return true;
        }
        if (args.length == 0) {
            this.usageMessage(p);
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("reload")) {
                this.plugin.reloadConfig();
                this.sendMessage(p, "reloadConfig");
                return true;
            }
            PlayerInventory inv = p.getInventory();
            BedWars bedWars = ArenaSetup.getBedWars();
            if (args[0].equalsIgnoreCase("waiting")) {
                if (!bedWars.isInSetupSession(p.getUniqueId())) {
                    this.sendMessage(p, "Errors.notInSession");
                    return true;
                }
                this.giveWaitingItems((Inventory)inv);
                return true;
            }
            if (args[0].equalsIgnoreCase("spawn")) {
                if (!bedWars.isInSetupSession(p.getUniqueId())) {
                    this.sendMessage(p, "Errors.notInSession");
                    return true;
                }
                this.giveSpawnItems((Inventory)inv);
                return true;
            }
            if (args[0].equalsIgnoreCase("generator")) {
                if (!bedWars.isInSetupSession(p.getUniqueId())) {
                    this.sendMessage(p, "Errors.notInSession");
                    return true;
                }
                this.giveGeneratorItems((Inventory)inv);
                return true;
            }
            this.usageMessage(p);
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("arenasetup.admin")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> complete = new ArrayList<String>();
            complete.add("waiting");
            complete.add("spawn");
            complete.add("generator");
            complete.add("reload");
            return complete;
        }
        return Collections.emptyList();
    }

    private void sendMessage(Player p, String configPath) {
        p.sendMessage(Utils.color(this.plugin.getConfig().getString("Messages." + configPath)));
    }

    private void giveWaitingItems(Inventory inv) {
        inv.clear();
        inv.setItem(this.b("Waiting.lobbySpawn"), this.bwSpawn);
        inv.setItem(this.b("Waiting.spectatorSpawn"), this.specSpawn);
        inv.setItem(this.b("Waiting.createTeams"), this.createTeams);
        inv.setItem(this.b("Waiting.waitingLoc1"), this.waitingLoc1);
        inv.setItem(this.b("Waiting.waitingLoc2"), this.waitingLoc2);
        inv.setItem(this.b("General.goToSpawnSetup"), this.spawnSetup);
    }

    private void giveSpawnItems(Inventory inv) {
        inv.clear();
        inv.setItem(this.b("Spawn.teamSpawn"), this.teamSpawn);
        inv.setItem(this.b("Spawn.teamGenerator"), this.teamGenerator);
        inv.setItem(this.b("Spawn.killDrops"), this.killDrops);
        inv.setItem(this.b("General.teleportToCenter"), this.centerView);
        inv.setItem(this.b("Spawn.setShop"), this.teamShop);
        inv.setItem(this.b("Spawn.setUpgrade"), this.teamUpgrade);
        inv.setItem(this.b("General.goToGeneratorSetup"), this.generatorSetup);
    }

    private void giveGeneratorItems(Inventory inv) {
        inv.clear();
        inv.setItem(this.b("Generators.emeraldGenerator"), this.emeraldGenerator);
        inv.setItem(this.b("Generators.diamondGenerator"), this.diamondGenerator);
        inv.setItem(this.b("General.teleportToCenter"), this.centerView);
        inv.setItem(this.b("General.saveArena"), this.bwSave);
    }

    private void usageMessage(Player p) {
        p.sendMessage(Utils.color("&7\n &8BedWars1058-ArenaSetup by Sohqil v" + this.plugin.getDescription().getVersion() + "\n&e/bwsetup waiting - &bGet waiting items\n&e/bwsetup spawn - &bGet spawn items\n&e/bwsetup generator - &bGet generator items\n&e/bwsetup reload - &bReload the config \n"));
    }

    private String a(String configPath) {
        return Utils.color(this.plugin.getConfig().getString("Items." + configPath));
    }

    private int b(String configPath) {
        return this.plugin.getConfig().getInt("Materials." + configPath + ".Slot") - 1;
    }

    private ItemStack getMaterial(String item) {
        FileConfiguration c = this.plugin.getConfig();
        return new ItemStack(Material.valueOf((String)c.getString("Materials." + item + ".Id").toUpperCase()), c.getInt("Materials." + item + ".Amount"), (short)((byte)c.getInt("Materials." + item + ".Data")));
    }
}

