/*
 * Decompiled with CFR 0.152.
 */
package me.liangchenghqr.minigamesaddons.MySQL;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import me.liangchenghqr.minigamesaddons.MinigamesAddons;
import me.liangchenghqr.minigamesaddons.MySQL.MysqlSetup;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MysqlTools {
    public static void createStringTable(String str) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("CREATE TABLE IF NOT EXISTS " + str + " (UUID varchar(80), Selected varchar(80));");
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b[MinigamesAddons] &cUnable to connect to MySQL to read &b{name}&c! Please check your config!".replace("{name}", str)));
        }
    }

    public static void createIntTable(String str) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("CREATE TABLE IF NOT EXISTS " + str + " (UUID varchar(80), Coins int(11));");
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b[MinigamesAddons] &cUnable to connect to MySQL to read &b{name}&c! Please check your config!".replace("{name}", str)));
        }
    }

    public static void registerMoney(Player p) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("INSERT INTO Money (uuid, money) VALUES (?, ?)");
            ps.setString(1, p.getUniqueId().toString());
            ps.setInt(2, 0);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRegisteredMoney(Player p) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("SELECT * FROM Money WHERE uuid=?");
            ps.setString(1, p.getUniqueId().toString());
            ResultSet rs = ps.executeQuery();
            boolean user = rs.next();
            rs.close();
            ps.close();
            return user;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getPlayerMoney(Player p) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("SELECT * FROM Money WHERE uuid=?");
            ps.setString(1, p.getUniqueId().toString());
            ResultSet rs = ps.executeQuery();
            rs.next();
            int coins = rs.getInt("Money");
            rs.close();
            ps.close();
            return coins;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void setPlayerMoney(Player p, int newMoney) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("UPDATE Money SET Money=? WHERE uuid=?");
            ps.setInt(1, newMoney);
            ps.setString(2, p.getUniqueId().toString());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerCosmetic(Player p, String str) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("INSERT INTO " + str + " (uuid, selected) VALUES (?, ?)");
            ps.setString(1, p.getUniqueId().toString());
            ps.setString(2, "None");
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRegisteredCosmetic(Player p, String cosmeticType) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("SELECT * FROM " + cosmeticType + " WHERE uuid=?");
            ps.setString(1, p.getUniqueId().toString());
            ResultSet rs = ps.executeQuery();
            boolean user = rs.next();
            rs.close();
            ps.close();
            return user;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getCosmetic(Player p, String cosmetic) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("SELECT * FROM " + cosmetic + " WHERE uuid=?");
            ps.setString(1, p.getUniqueId().toString());
            ResultSet rs = ps.executeQuery();
            rs.next();
            String selected = rs.getString("Selected");
            rs.close();
            ps.close();
            return selected;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setCosmetic(Player p, String newCosmetic, String cosmeticType) {
        try {
            PreparedStatement ps = MysqlSetup.getStatement("UPDATE " + cosmeticType + " SET Selected=? WHERE uuid=?");
            ps.setString(1, newCosmetic);
            ps.setString(2, p.getUniqueId().toString());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startReconnectCountdown() {
        MinigamesAddons.sendConsoleMsg("&e-----------------------------------------------");
        MinigamesAddons.sendConsoleMsg("&b[MinigamesAddons] &eThe &bMySQL&e will re-connect in 30 minutes!");
        MinigamesAddons.sendConsoleMsg("&e-----------------------------------------------");
        new BukkitRunnable(){

            public void run() {
                MysqlSetup.Reconnect();
                MysqlTools.startReconnectCountdown();
            }
        }.runTaskLater((Plugin)MinigamesAddons.plugin, 36000L);
    }
}

