/*
 * Decompiled with CFR 0.152.
 */
package me.liangchenghqr.minigamesaddons.Utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import me.liangchenghqr.minigamesaddons.MinigamesAddons;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileManager {
    private MinigamesAddons plugin;
    private FileConfiguration customfile = null;
    private File customfileFile = null;

    public FileManager(MinigamesAddons plugin) {
        this.plugin = plugin;
    }

    private FileConfiguration getFile(String filePath, String fileHere) {
        if (this.customfile == null) {
            this.reloadFile(filePath, fileHere);
        }
        return this.customfile;
    }

    private void reloadFile(String filePath, String fileHere) {
        if (this.customfile == null) {
            this.customfileFile = new File(this.plugin.getDataFolder() + filePath, fileHere + ".yml");
        }
        this.customfile = YamlConfiguration.loadConfiguration((File)this.customfileFile);
        try {
            InputStreamReader defConfigStream = new InputStreamReader(this.plugin.getResource(fileHere + ".yml"), "UTF8");
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
                this.customfile.setDefaults((Configuration)defConfig);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void saveFile(String filePath, String fileName) {
        this.getFile(filePath, fileName);
        try {
            this.customfile.save(this.customfileFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerCustomFile(String filePath, String fileHere) {
        this.customfileFile = new File(this.plugin.getDataFolder() + filePath, fileHere + ".yml");
        if (!this.customfileFile.exists()) {
            this.getFile(filePath, fileHere).options().copyDefaults(true);
            this.saveFile(filePath, fileHere + ".yml");
        }
    }

    public static void createCustomFile(String filePath, String fileName) {
        FileManager fileManager = new FileManager(MinigamesAddons.plugin);
        fileManager.registerCustomFile(filePath, fileName);
    }

    public static void saveCustomFile(String filePath, String fileName) {
        FileManager fileManager = new FileManager(MinigamesAddons.plugin);
        fileManager.saveFile(filePath, fileName);
    }

    public static void reloadCustomFile(String filePath, String fileName) {
        FileManager fileManager = new FileManager(MinigamesAddons.plugin);
        fileManager.reloadFile(filePath, fileName);
    }

    public static FileConfiguration getCustomFile(String filePath, String fileName) {
        FileManager fileManager = new FileManager(MinigamesAddons.plugin);
        return fileManager.getFile(filePath, fileName);
    }
}

