/*
 * Decompiled with CFR 0.152.
 */
package me.liangchenghqr.minigamesaddons.Utils;

import java.util.ArrayList;
import java.util.List;
import me.liangchenghqr.minigamesaddons.MinigamesAddons;
import me.liangchenghqr.minigamesaddons.Utils.CosmeticManager;
import me.liangchenghqr.minigamesaddons.Utils.EconomyManager;
import me.liangchenghqr.minigamesaddons.Utils.HeadManager;
import me.liangchenghqr.minigamesaddons.Utils.StringUtil;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemManager {
    public static String processLore(String originalLoreLine, Player player) {
        String s1 = ChatColor.translateAlternateColorCodes((char)'&', (String)originalLoreLine);
        String s2 = StringUtil.replaceStr(s1, "{var_vd}", CosmeticManager.getVictoryDanceName(player));
        String s3 = StringUtil.replaceStr(s2, "{var_bt}", CosmeticManager.getBowTrailName(player));
        String s4 = StringUtil.replaceStr(s3, "{var_ke}", CosmeticManager.getKillEffectName(player));
        String s5 = StringUtil.replaceStr(s4, "{var_dc}", CosmeticManager.getDeathCryName(player));
        String s6 = StringUtil.replaceStr(s5, "{var_auras}", CosmeticManager.getAurasName(player));
        String s7 = StringUtil.replaceStr(s6, "{var_bbe}", CosmeticManager.getBedBreakEffectName(player));
        String s8 = StringUtil.replaceStr(s7, "{var_km}", CosmeticManager.getKillMessagesName(player));
        String s9 = StringUtil.replaceStr(s8, "{var_skin}", CosmeticManager.getShopKeeperSkinsName(player));
        String end = StringUtil.replaceStr(s9, "{var_money}", String.valueOf(EconomyManager.getPlayerMoney(player)));
        return end;
    }

    public static String processCosmeticLore(String originalLoreLine, Player player, FileConfiguration cosmeticFile, String cosmeticKey, String cosmeticType, String permType, String targetCosmetic, boolean buyAble, int price) {
        String s1 = ChatColor.translateAlternateColorCodes((char)'&', (String)originalLoreLine);
        String s2 = StringUtil.replaceStr(s1, "{var_vd}", CosmeticManager.getVictoryDanceName(player));
        String s3 = StringUtil.replaceStr(s2, "{var_bt}", CosmeticManager.getBowTrailName(player));
        String s4 = StringUtil.replaceStr(s3, "{var_ke}", CosmeticManager.getKillEffectName(player));
        String s5 = StringUtil.replaceStr(s4, "{var_dc}", CosmeticManager.getDeathCryName(player));
        String s6 = StringUtil.replaceStr(s5, "{var_auras}", CosmeticManager.getAurasName(player));
        String s7 = StringUtil.replaceStr(s6, "{var_bbe}", CosmeticManager.getBedBreakEffectName(player));
        String s8 = StringUtil.replaceStr(s7, "{var_km}", CosmeticManager.getKillMessagesName(player));
        String s9 = StringUtil.replaceStr(s8, "{var_skin}", CosmeticManager.getShopKeeperSkinsName(player));
        String s10 = StringUtil.replaceStr(s9, "{var_money}", String.valueOf(EconomyManager.getPlayerMoney(player)));
        String s11 = StringUtil.replaceStr(s10, "{selectStatus}", ItemManager.getSelectStatus(cosmeticType, permType, targetCosmetic, player, buyAble, price));
        String end = StringUtil.replaceStr(s11, "{price}", String.valueOf(cosmeticFile.getInt(cosmeticKey + ".Purchase.Price")));
        return end;
    }

    public static ItemStack getItem(Material material, int amount, int data, String nameColored, List<String> lores) {
        ItemStack itemStack = new ItemStack(material, amount, (short)data);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)nameColored));
        ArrayList<String> lore = new ArrayList<String>();
        for (String temp : lores) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)temp));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static String getSelectStatus(String cosmeticType, String permType, String targetCosmetic, Player player, boolean buyAble, int price) {
        FileConfiguration file = MinigamesAddons.plugin.getConfig();
        String selected = "";
        String selectedName = "";
        if (cosmeticType.equals("BowTrail")) {
            selected = CosmeticManager.getBowTrail(player);
            selectedName = CosmeticManager.getBowTrailName(player);
        } else if (cosmeticType.equals("DeathCry")) {
            selected = CosmeticManager.getDeathCry(player);
            selectedName = CosmeticManager.getDeathCryName(player);
        } else if (cosmeticType.equals("KillEffects")) {
            selected = CosmeticManager.getKillEffect(player);
            selectedName = CosmeticManager.getKillEffectName(player);
        } else if (cosmeticType.equals("VictoryDances")) {
            selected = CosmeticManager.getVictoryDance(player);
            selectedName = CosmeticManager.getVictoryDanceName(player);
        } else if (cosmeticType.equals("Auras")) {
            selected = CosmeticManager.getAuras(player);
            selectedName = CosmeticManager.getAurasName(player);
        } else if (cosmeticType.equals("ShopkeeperSkins")) {
            selected = CosmeticManager.getShopKeeperSkins(player);
            selectedName = CosmeticManager.getShopKeeperSkinsName(player);
        } else if (cosmeticType.equals("KillMessages")) {
            selected = CosmeticManager.getKillMessages(player);
            selectedName = CosmeticManager.getKillMessagesName(player);
        } else if (cosmeticType.equals("BedBreakEffects")) {
            selected = CosmeticManager.getBedBreakEffect(player);
            selectedName = CosmeticManager.getBedBreakEffectName(player);
        }
        if (player.hasPermission("ma.{type}.{target}".replace("{type}", permType).replace("{target}", targetCosmetic))) {
            if (selected.equals(targetCosmetic)) {
                return ChatColor.translateAlternateColorCodes((char)'&', (String)file.getString("Menus.SelectStatus.Selected"));
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)file.getString("Menus.SelectStatus.Unlocked"));
        }
        if (buyAble) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)file.getString("Menus.SelectStatus.ClickBuy"));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)file.getString("Menus.SelectStatus.NoBuy"));
    }

    public static ItemStack getItemWithKey(FileConfiguration menuFile, String menuKey, Player player) {
        if (menuFile.getString(menuKey + ".Item").equals("CUSTOM_SKULL")) {
            if (menuFile.getString(menuKey + ".Skull").equals("<PLAYER>")) {
                ItemStack itemStack = new ItemStack(Material.SKULL_ITEM, 1, 3);
                SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                skullMeta.setOwner(player.getName());
                skullMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)menuFile.getString(menuKey + ".Name")));
                ArrayList<String> lore = new ArrayList<String>();
                for (String temp : menuFile.getStringList(menuKey + ".Lore")) {
                    lore.add(ItemManager.processLore(temp, player));
                }
                skullMeta.setLore(lore);
                itemStack.setItemMeta((ItemMeta)skullMeta);
                return itemStack;
            }
            ItemStack itemStack = HeadManager.getSkull(menuFile.getString(menuKey + ".Skull"));
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)menuFile.getString(menuKey + ".Name")));
            ArrayList<String> lore = new ArrayList<String>();
            for (String temp : menuFile.getStringList(menuKey + ".Lore")) {
                lore.add(ItemManager.processLore(temp, player));
            }
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }
        ItemStack itemStack = new ItemStack(Material.valueOf((String)menuFile.getString(menuKey + ".Item")), menuFile.getInt(menuKey + ".Amount"), (short)menuFile.getInt(menuKey + ".Data"));
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)menuFile.getString(menuKey + ".Name")));
        ArrayList<String> lore = new ArrayList<String>();
        for (String temp : menuFile.getStringList(menuKey + ".Lore")) {
            lore.add(ItemManager.processLore(temp, player));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack getItemByCosmetic(FileConfiguration cosmeticFile, String cosmeticKey, Player player, String cosmeticType, String permType) {
        if (cosmeticFile.getString(cosmeticKey + ".MenuItem.Item").equals("CUSTOM_SKULL")) {
            if (cosmeticFile.getString(cosmeticKey + ".MenuItem.Skull").equals("<PLAYER>")) {
                ItemStack itemStack = new ItemStack(Material.SKULL_ITEM, 1, 3);
                SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                skullMeta.setOwner(player.getName());
                skullMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)cosmeticFile.getString(cosmeticKey + ".MenuItem.Name")));
                ArrayList<String> lore = new ArrayList<String>();
                for (String temp : cosmeticFile.getStringList(cosmeticKey + ".MenuItem.Lore")) {
                    lore.add(ItemManager.processCosmeticLore(temp, player, cosmeticFile, cosmeticKey, cosmeticType, permType, cosmeticKey, cosmeticFile.getBoolean(cosmeticKey + ".Purchase.BuyAble"), cosmeticFile.getInt(cosmeticKey + ".Purchase.Price")));
                }
                skullMeta.setLore(lore);
                itemStack.setItemMeta((ItemMeta)skullMeta);
                return itemStack;
            }
            ItemStack itemStack = HeadManager.getSkull(cosmeticFile.getString(cosmeticKey + ".MenuItem.Skull"));
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)cosmeticFile.getString(cosmeticKey + ".MenuItem.Name")));
            ArrayList<String> lore = new ArrayList<String>();
            for (String temp : cosmeticFile.getStringList(cosmeticKey + ".MenuItem.Lore")) {
                lore.add(ItemManager.processCosmeticLore(temp, player, cosmeticFile, cosmeticKey, cosmeticType, permType, cosmeticKey, cosmeticFile.getBoolean(cosmeticKey + ".Purchase.BuyAble"), cosmeticFile.getInt(cosmeticKey + ".Purchase.Price")));
            }
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }
        ItemStack itemStack = new ItemStack(Material.valueOf((String)cosmeticFile.getString(cosmeticKey + ".MenuItem.Item")), cosmeticFile.getInt(cosmeticKey + ".MenuItem.Amount"), (short)cosmeticFile.getInt(cosmeticKey + ".MenuItem.Data"));
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)cosmeticFile.getString(cosmeticKey + ".MenuItem.Name")));
        ArrayList<String> lore = new ArrayList<String>();
        for (String temp : cosmeticFile.getStringList(cosmeticKey + ".MenuItem.Lore")) {
            lore.add(ItemManager.processCosmeticLore(temp, player, cosmeticFile, cosmeticKey, cosmeticType, permType, cosmeticKey, cosmeticFile.getBoolean(cosmeticKey + ".Purchase.BuyAble"), cosmeticFile.getInt(cosmeticKey + ".Purchase.Price")));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

