/*
 * Decompiled with CFR 0.152.
 */
package me.liangchenghqr.nbtapi;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.liangchenghqr.nbtapi.ReflectionUtils;
import me.liangchenghqr.nbtapi.TagCompound;
import me.liangchenghqr.nbtapi.TagList;
import org.apache.commons.lang3.Validate;
import org.bukkit.entity.Entity;

public class EntityUtils {
    public static TagCompound getTagCompound(Entity e) {
        return EntityUtils.getTagCompound(e, true);
    }

    public static TagCompound getTagCompound(Entity e, boolean update) {
        Object nmsEntity = ReflectionUtils.invokeBukkitMethod("getHandle", e);
        Object nbt = ReflectionUtils.newNMS("NBTTagCompound");
        ReflectionUtils.invokeNMSMethod("b", nmsEntity, new Class[]{ReflectionUtils.getNMSClass("NBTTagCompound")}, nbt);
        return TagCompound.fromNMS(nbt, update ? e : null);
    }

    public static void setTagCompound(Entity e, TagCompound tag) {
        Object nmsEntity = ReflectionUtils.invokeBukkitMethod("getHandle", e);
        Object nbt = tag.convertToNMS();
        ReflectionUtils.invokeNMSMethod("a", nmsEntity, new Class[]{ReflectionUtils.getNMSClass("NBTTagCompound")}, nbt);
    }

    public static Map<EntityAttributes, Double> getAllAttributes(Entity e) {
        HashMap map = Maps.newHashMap();
        TagCompound tag = EntityUtils.getTagCompound(e, false);
        TagList attributesTag = tag.getList("Attributes");
        if (attributesTag == null) {
            attributesTag = new TagList();
        }
        for (Object o : attributesTag) {
            TagCompound attributeTag = (TagCompound)o;
            EntityAttributes attributes = EntityAttributes.getByName(attributeTag.getString("Name"));
            double value = attributeTag.getDouble("Base");
            map.put(attributes, value);
        }
        return map;
    }

    public static double getAttribute(Entity e, EntityAttributes attributes) {
        return EntityUtils.getAllAttributes(e).getOrDefault((Object)attributes, attributes.getDefaultValue());
    }

    public static void setAllAttributes(Entity e, Map<EntityAttributes, Double> allAttributes) {
        TagCompound tag = EntityUtils.getTagCompound(e);
        TagList attributesTag = new TagList();
        for (Map.Entry<EntityAttributes, Double> entry : allAttributes.entrySet()) {
            Validate.inclusiveBetween((double)entry.getKey().getMinimum(), (double)entry.getKey().getMaximum(), (double)entry.getValue(), (String)(entry.getKey().getAttributeName() + " attribute must be inclusive between " + entry.getKey().getMinimum() + " and " + entry.getKey().getMaximum()));
            TagCompound attributeTag = new TagCompound();
            attributeTag.setString("Name", entry.getKey().getAttributeName());
            attributeTag.setDouble("Base", entry.getValue());
            attributesTag.add(attributeTag);
        }
        tag.setList("Attributes", attributesTag);
    }

    public static void setAttribute(Entity e, EntityAttributes attributes, double value) {
        Map<EntityAttributes, Double> map = EntityUtils.getAllAttributes(e);
        map.put(attributes, value);
        EntityUtils.setAllAttributes(e, map);
    }

    public static enum EntityAttributes {
        MAX_HEALTH("generic.maxHealth", 20.0, 0.0, Double.MAX_VALUE),
        FOLLOW_RANGE("generic.followRange", 32.0, 0.0, 2048.0),
        KNOCKBACK_RESISTANCE("generic.knockbackResistance", 0.0, 0.0, 1.0),
        MOVEMENT_SPEED("generic.movementSpeed", (double)0.7f, 0.0, Double.MAX_VALUE),
        ATTACK_DAMAGE("generic.attackDamage", 2.0, 0.0, Double.MAX_VALUE),
        ARMOR("generic.armor", 0.0, 0.0, 30.0),
        ARMOR_TOUGHNESS("generic.armorToughness", 0.0, 0.0, 20.0),
        ATTACK_SPEED("generic.attackSpeed", 4.0, 0.0, 1024.0),
        LUCK("generic.luck", 0.0, -1024.0, 1024.0),
        JUMP_STRENGTH("horse.jumpStrength", 0.7, 0.0, 2.0),
        SPAWN_REINFORCEMENTS("zombie.spawnReinforcements", 0.0, 0.0, 1.0);

        private static final Map<String, EntityAttributes> BY_NAME;
        private final String name;
        private final double defaultValue;
        private final double minimum;
        private final double maximum;

        private EntityAttributes(String name, double defaultValue, double minimum, double maximum) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public static EntityAttributes getByName(String name) {
            if (BY_NAME.isEmpty()) {
                Arrays.stream(EntityAttributes.values()).forEach(attributes -> BY_NAME.put(attributes.getAttributeName(), (EntityAttributes)((Object)attributes)));
            }
            return BY_NAME.get(name);
        }

        public String getAttributeName() {
            return this.name;
        }

        public double getDefaultValue() {
            return this.defaultValue;
        }

        public double getMinimum() {
            return this.minimum;
        }

        public double getMaximum() {
            return this.maximum;
        }

        static {
            BY_NAME = Maps.newHashMap();
        }
    }
}

