/*
 * Decompiled with CFR 0.152.
 */
package me.liangchenghqr.nbtapi;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.liangchenghqr.nbtapi.ReflectionUtils;
import me.liangchenghqr.nbtapi.TagCompound;
import me.liangchenghqr.nbtapi.TagList;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackUtils {
    public static String toId(Material material) {
        Object registry = ReflectionUtils.getNMSStaticField("Item", "REGISTRY");
        Object item = ReflectionUtils.invokeBukkitStaticMethod("util.CraftMagicNumbers", "getItem", new Class[]{Material.class}, material);
        Object mcKey = ReflectionUtils.invokeNMSMethod(ReflectionUtils.getServerVersion().contains("1_8") ? "c" : "b", registry, new Class[]{Object.class}, item);
        return "minecraft:" + (mcKey == null ? "null" : ReflectionUtils.invokeNMSMethod("a", mcKey));
    }

    public static Material toMaterial(String id) {
        Object registry = ReflectionUtils.getNMSStaticField("Item", "REGISTRY");
        Object mcKey = ReflectionUtils.newNMS("MinecraftKey", new Class[]{String.class}, id);
        Object item = ReflectionUtils.invokeNMSMethod("get", registry, new Class[]{Object.class}, mcKey);
        return (Material)ReflectionUtils.invokeBukkitStaticMethod("util.CraftMagicNumbers", "getMaterial", new Class[]{ReflectionUtils.getNMSClass("Item")}, item);
    }

    public static TagCompound getAllStackCompound(ItemStack stack) {
        Object nbt = ReflectionUtils.newNMS("NBTTagCompound");
        ReflectionUtils.invokeNMSMethod("save", ItemStackUtils.asNMSCopy(stack), new Class[]{nbt.getClass()}, nbt);
        return TagCompound.fromNMS(nbt);
    }

    public static ItemStack fromTagCompound(TagCompound tag) {
        Object nms = ReflectionUtils.invokeNMSStaticMethod("ItemStack", "createStack", new Class[]{ReflectionUtils.getNMSClass("NBTTagCompound")}, tag.convertToNMS());
        return ItemStackUtils.asBukkitCopy(nms);
    }

    public static Object asNMSCopy(ItemStack stack) {
        return ReflectionUtils.invokeBukkitStaticMethod("inventory.CraftItemStack", "asNMSCopy", new Class[]{ItemStack.class}, stack);
    }

    public static ItemStack asBukkitCopy(Object object) {
        Validate.isTrue((object.getClass() == ReflectionUtils.getNMSClass("ItemStack") ? 1 : 0) != 0, (String)"Parameter must be a Notch ItemStack", (Object[])new Object[0]);
        return (ItemStack)ReflectionUtils.invokeBukkitStaticMethod("inventory.CraftItemStack", "asBukkitCopy", new Class[]{ReflectionUtils.getNMSClass("ItemStack")}, object);
    }

    public static List<Material> getCanDestroy(ItemStack stack) {
        TagCompound tag = ItemStackUtils.getTagCompound(stack, false);
        TagList list = tag.getList("CanDestroy");
        if (list == null) {
            return Lists.newArrayList();
        }
        return ItemStackUtils.toMaterials(list.stream().map(o -> o.toString().substring(10)).collect(Collectors.toList()).toArray(new String[list.size()]));
    }

    public static TagCompound getTagCompound(ItemStack stack) {
        return ItemStackUtils.getTagCompound(stack, true);
    }

    public static TagCompound getTagCompound(ItemStack stack, boolean update) {
        return TagCompound.fromNMS(ReflectionUtils.invokeNMSMethod("getTag", ItemStackUtils.asNMSCopy(stack)), update ? stack : null);
    }

    public static List<Material> toMaterials(String ... ids) {
        return Arrays.stream(ids).map(ItemStackUtils::toMaterial).collect(Collectors.toList());
    }

    public static void setCanDestroy(ItemStack stack, Material ... blocks) {
        List<String> ids = ItemStackUtils.toIds(blocks);
        TagCompound tag = ItemStackUtils.getTagCompound(stack);
        if (tag == null) {
            tag = new TagCompound();
        }
        tag.setList("CanDestroy", new TagList(ids));
    }

    public static List<String> toIds(Material ... materials) {
        return Arrays.stream(materials).map(ItemStackUtils::toId).collect(Collectors.toList());
    }

    public static void setTagCompound(ItemStack stack, TagCompound tag) {
        Object copy = ItemStackUtils.asNMSCopy(stack);
        ReflectionUtils.invokeNMSMethod("setTag", copy, new Class[]{ReflectionUtils.getNMSClass("NBTTagCompound")}, tag.convertToNMS());
        stack.setItemMeta((ItemMeta)ReflectionUtils.invokeBukkitStaticMethod("inventory.CraftItemStack", "getItemMeta", new Class[]{ReflectionUtils.getNMSClass("ItemStack")}, copy));
    }

    public static List<Material> getCanPlaceOn(ItemStack stack) {
        TagCompound tag = ItemStackUtils.getTagCompound(stack, false);
        TagList list = tag.getList("CanPlaceOn");
        if (list == null) {
            return Lists.newArrayList();
        }
        return ItemStackUtils.toMaterials(list.stream().map(o -> o.toString().substring(10)).collect(Collectors.toList()).toArray(new String[list.size()]));
    }

    public static void setCanPlaceOn(ItemStack stack, Material ... blocks) {
        List<String> ids = ItemStackUtils.toIds(blocks);
        TagCompound tag = ItemStackUtils.getTagCompound(stack);
        if (tag == null) {
            tag = new TagCompound();
        }
        tag.setList("CanPlaceOn", new TagList(ids));
    }
}

