/*
 * Decompiled with CFR 0.152.
 */
package me.liangchenghqr.nbtapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;

public class ReflectionUtils {
    private static final String SERVER_VERSION = Bukkit.getServer().getClass().getName().split("\\.")[3];

    public static <T> T invokeNMSStaticMethod(String className, String method, Class<?>[] parameterClasses, Object ... params) {
        return ReflectionUtils.invokeNMSMethod(className, method, null, parameterClasses, params);
    }

    public static <T> T invokeNMSMethod(String className, String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        Validate.isTrue((parameterClasses.length == params.length ? 1 : 0) != 0, (String)"Parameter array's length must be equal to the params array's length", (Object[])new Object[0]);
        try {
            Class<?> clazz = ReflectionUtils.getNMSClass(className);
            Method m = clazz.getDeclaredMethod(method, parameterClasses);
            m.setAccessible(true);
            return (T)m.invoke(invoker, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T invokeNMSMethod(String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        Validate.isTrue((invoker != null ? 1 : 0) != 0, (String)"Invoker cannot be null", (Object[])new Object[0]);
        return ReflectionUtils.invokeNMSMethod(invoker.getClass().getSimpleName(), method, invoker, parameterClasses, params);
    }

    public static <T> T invokeNMSMethod(String method, Object invoker) {
        Validate.isTrue((invoker != null ? 1 : 0) != 0, (String)"Invoker cannot be null", (Object[])new Object[0]);
        return ReflectionUtils.invokeNMSMethod(method, invoker, new Class[0], new Object[0]);
    }

    public static Object newNMS(String className) {
        return ReflectionUtils.newNMS(className, new Class[0], new Object[0]);
    }

    public static Object newNMS(String className, Class<?>[] parameterClasses, Object ... params) {
        try {
            Class<?> clazz = ReflectionUtils.getNMSClass(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterClasses);
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <T> T getNMSField(Object owner, String fieldName) {
        return ReflectionUtils.getNMSField(owner.getClass().getSimpleName(), owner, fieldName);
    }

    public static <T> T getNMSField(String className, Object owner, String fieldName) {
        try {
            Class<?> clazz = ReflectionUtils.getNMSClass(className);
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(owner);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <T> T getNMSStaticField(String className, String fieldName) {
        return ReflectionUtils.getNMSField(className, null, fieldName);
    }

    public static Class<?> getNMSClass(String className) {
        try {
            return Class.forName("net.minecraft.server." + SERVER_VERSION + "." + className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public static <T> T invokeBukkitStaticMethod(String className, String method, Class<?>[] parameterClasses, Object ... params) {
        return ReflectionUtils.invokeBukkitMethod(className, method, null, parameterClasses, params);
    }

    public static <T> T invokeBukkitMethod(String className, String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        Validate.isTrue((parameterClasses.length == params.length ? 1 : 0) != 0, (String)"Parameter array's length must be equal to the params array's length", (Object[])new Object[0]);
        try {
            Class<?> clazz = ReflectionUtils.getBukkitClass(className);
            Method m = clazz.getDeclaredMethod(method, parameterClasses);
            m.setAccessible(true);
            return (T)m.invoke(invoker, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T invokeBukkitMethod(String method, Object invoker, Class<?>[] parameterClasses, Object ... params) {
        return ReflectionUtils.invokeBukkitMethod(invoker.getClass().getName().replace("org.bukkit.craftbukkit." + SERVER_VERSION + ".", ""), method, invoker, parameterClasses, params);
    }

    public static <T> T invokeBukkitMethod(String method, Object invoker) {
        return ReflectionUtils.invokeBukkitMethod(method, invoker, new Class[0], new Object[0]);
    }

    public static Object newBukkit(String className) {
        return ReflectionUtils.newBukkit(className, new Class[0], new Object[0]);
    }

    public static Object newBukkit(String className, Class<?>[] parameterClasses, Object ... params) {
        try {
            Class<?> clazz = ReflectionUtils.getBukkitClass(className);
            Constructor<?> constructor = clazz.getConstructor(parameterClasses);
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <T> T getBukkitField(Object owner, String fieldName) {
        return ReflectionUtils.getBukkitField(owner.getClass().getName().replace("org.bukkit.craftbukkit." + SERVER_VERSION + ".", ""), owner, fieldName);
    }

    public static <T> T getBukkitField(String className, Object owner, String fieldName) {
        try {
            Class<?> clazz = ReflectionUtils.getBukkitClass(className);
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(owner);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <T> T getBukkitStaticField(String className, String fieldName) {
        return ReflectionUtils.getBukkitField(className, null, fieldName);
    }

    public static Class<?> getBukkitClass(String className) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + SERVER_VERSION + "." + className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public static String getServerVersion() {
        return SERVER_VERSION;
    }
}

