/*
 * Decompiled with CFR 0.152.
 */
package me.liangchenghqr.nbtapi;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import me.liangchenghqr.nbtapi.EntityUtils;
import me.liangchenghqr.nbtapi.ItemStackUtils;
import me.liangchenghqr.nbtapi.ReflectionUtils;
import me.liangchenghqr.nbtapi.TagList;
import org.apache.commons.lang3.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class TagCompound
extends HashMap<String, Object> {
    private final Object owner;

    public TagCompound() {
        this((Object)null);
    }

    public TagCompound(@Nullable Object owner) {
        this.owner = owner;
    }

    public static TagCompound fromNMS(Object nms) {
        return TagCompound.fromNMS(nms, null);
    }

    protected static TagCompound fromNMS(Object o, @Nullable Object owner) {
        if (o == null) {
            return new TagCompound(owner);
        }
        Validate.isTrue((boolean)o.getClass().getSimpleName().equalsIgnoreCase("NBTTagCompound"), (String)"Only a NBTTagCompound can be transformed into a TagCompound", (Object[])new Object[0]);
        TagCompound tag = new TagCompound(owner);
        Set keys = (Set)ReflectionUtils.invokeNMSMethod("c", o);
        for (String key : keys) {
            Cloneable data;
            Object base = ReflectionUtils.invokeNMSMethod("get", o, new Class[]{String.class}, key);
            switch (base.getClass().getSimpleName()) {
                case "NBTTagEnd": {
                    data = null;
                    break;
                }
                case "NBTTagCompound": {
                    data = TagCompound.fromNMS(base);
                    break;
                }
                case "NBTTagList": {
                    data = TagList.fromNMS(base);
                    break;
                }
                default: {
                    data = ReflectionUtils.getNMSField(base, "data");
                }
            }
            tag.put(key, (Object)data);
        }
        return tag;
    }

    public void setString(String key, String value) {
        this.put(key, (Object)value);
    }

    public void setInt(String key, int value) {
        this.put(key, (Object)value);
    }

    public void setByte(String key, byte value) {
        this.put(key, (Object)value);
    }

    public void setFloat(String key, float value) {
        this.put(key, (Object)Float.valueOf(value));
    }

    public void setDouble(String key, double value) {
        this.put(key, (Object)value);
    }

    public void setShort(String key, short value) {
        this.put(key, (Object)value);
    }

    public void setLong(String key, long value) {
        this.put(key, (Object)value);
    }

    public void setCompound(String key, TagCompound value) {
        this.put(key, (Object)value);
    }

    public void setList(String key, TagList value) {
        this.put(key, (Object)value);
    }

    public void setByteArray(String key, byte[] value) {
        this.put(key, (Object)value);
    }

    public void setIntArray(String key, int[] value) {
        this.put(key, (Object)value);
    }

    public void setEnd(String key) {
        this.put(key, (Object)null);
    }

    @Override
    public Object put(String key, Object value) {
        Object ret = super.put(key, value);
        if (this.owner != null) {
            if (this.owner instanceof ItemStack) {
                ItemStackUtils.setTagCompound((ItemStack)this.owner, this);
            } else if (this.owner instanceof Entity) {
                EntityUtils.setTagCompound((Entity)this.owner, this);
            }
        }
        return ret;
    }

    @Override
    public Object get(Object key) {
        return super.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public byte getByte(String key) {
        return (Byte)this.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public float getFloat(String key) {
        return ((Float)this.get(key)).floatValue();
    }

    public short getShort(String key) {
        return (Short)this.get(key);
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public TagCompound getCompound(String key) {
        return (TagCompound)this.get(key);
    }

    public TagList getList(String key) {
        return (TagList)this.get(key);
    }

    public byte[] getByteArray(String key) {
        return (byte[])this.get(key);
    }

    public int[] getIntArray(String key) {
        return (int[])this.get(key);
    }

    public Object convertToNMS() {
        Object tag = ReflectionUtils.newNMS("NBTTagCompound");
        for (Map.Entry entry : this.entrySet()) {
            if (entry.getValue() == null) {
                ReflectionUtils.invokeNMSMethod("set", tag, new Class[]{String.class, ReflectionUtils.getNMSClass("NBTBase")}, entry.getKey(), ReflectionUtils.newNMS("NBTTagEnd"));
                continue;
            }
            if (entry.getValue() instanceof String) {
                ReflectionUtils.invokeNMSMethod("setString", tag, new Class[]{String.class, String.class}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Byte) {
                ReflectionUtils.invokeNMSMethod("setByte", tag, new Class[]{String.class, Byte.TYPE}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Short) {
                ReflectionUtils.invokeNMSMethod("setShort", tag, new Class[]{String.class, Short.TYPE}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Float) {
                ReflectionUtils.invokeNMSMethod("setFloat", tag, new Class[]{String.class, Float.TYPE}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Double) {
                ReflectionUtils.invokeNMSMethod("setDouble", tag, new Class[]{String.class, Double.TYPE}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                ReflectionUtils.invokeNMSMethod("setInt", tag, new Class[]{String.class, Integer.TYPE}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Long) {
                ReflectionUtils.invokeNMSMethod("setLong", tag, new Class[]{String.class, Long.TYPE}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof int[]) {
                ReflectionUtils.invokeNMSMethod("setIntArray", tag, new Class[]{String.class, int[].class}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof byte[]) {
                ReflectionUtils.invokeNMSMethod("setByteArray", tag, new Class[]{String.class, byte[].class}, entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof TagCompound) {
                ReflectionUtils.invokeNMSMethod("set", tag, new Class[]{String.class, ReflectionUtils.getNMSClass("NBTBase")}, entry.getKey(), ((TagCompound)entry.getValue()).convertToNMS());
                continue;
            }
            if (!(entry.getValue() instanceof TagList)) continue;
            ReflectionUtils.invokeNMSMethod("set", tag, new Class[]{String.class, ReflectionUtils.getNMSClass("NBTBase")}, entry.getKey(), ((TagList)entry.getValue()).convertToNMS());
        }
        return tag;
    }
}

