/*
 * Decompiled with CFR 0.152.
 */
package me.liangchenghqr.nbtapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.liangchenghqr.nbtapi.ReflectionUtils;
import me.liangchenghqr.nbtapi.TagCompound;
import org.apache.commons.lang3.Validate;

public class TagList
extends ArrayList<Object> {
    public TagList() {
    }

    public TagList(Object ... objs) {
        Arrays.stream(objs).forEach(this::add);
    }

    public TagList(Iterable objs) {
        objs.forEach(this::add);
    }

    public static TagList fromNMS(Object nbt) {
        if (nbt == null) {
            return new TagList();
        }
        Validate.isTrue((boolean)nbt.getClass().getSimpleName().equalsIgnoreCase("NBTTagList"), (String)"Only a NBTTagList can be transformed into a TagList", (Object[])new Object[0]);
        TagList tag = new TagList();
        List list = (List)ReflectionUtils.getNMSField(nbt, "list");
        for (Object base : list) {
            Cloneable data;
            if (base == null) continue;
            switch (base.getClass().getSimpleName()) {
                case "NBTTagEnd": {
                    data = null;
                    break;
                }
                case "NBTTagCompound": {
                    data = TagCompound.fromNMS(base);
                    break;
                }
                case "NBTTagList": {
                    data = TagList.fromNMS(base);
                    break;
                }
                default: {
                    data = ReflectionUtils.getNMSField(base, "data");
                }
            }
            tag.add(data);
        }
        return tag;
    }

    public Object convertToNMS() {
        Object tag = ReflectionUtils.newNMS("NBTTagList");
        for (Object o : this) {
            Object data = o instanceof Integer ? ReflectionUtils.newNMS("NBTTagInt", new Class[]{Integer.TYPE}, o) : (o instanceof Byte ? ReflectionUtils.newNMS("NBTTagByte", new Class[]{Byte.TYPE}, o) : (o instanceof Double ? ReflectionUtils.newNMS("NBTTagDouble", new Class[]{Double.TYPE}, o) : (o instanceof Float ? ReflectionUtils.newNMS("NBTTagFloat", new Class[]{Float.TYPE}, o) : (o instanceof Long ? ReflectionUtils.newNMS("NBTTagLong", new Class[]{Long.TYPE}, o) : (o instanceof Short ? ReflectionUtils.newNMS("NBTTagShort", new Class[]{Short.TYPE}, o) : (o instanceof String ? ReflectionUtils.newNMS("NBTTagString", new Class[]{String.class}, o) : (o instanceof int[] ? ReflectionUtils.newNMS("NBTTagIntArray", new Class[]{int[].class}, o) : (o instanceof byte[] ? ReflectionUtils.newNMS("NBTTagByteArray", new Class[]{byte[].class}, o) : (o instanceof TagCompound ? ((TagCompound)o).convertToNMS() : (o instanceof TagList ? ((TagList)o).convertToNMS() : ReflectionUtils.newNMS("NBTTagEnd")))))))))));
            ReflectionUtils.invokeNMSMethod("add", tag, new Class[]{ReflectionUtils.getNMSClass("NBTBase")}, data);
        }
        return tag;
    }
}

