/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.spigot.versionsupport;

import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public interface ParticleSupport {
    default public boolean isParticle(String name) {
        try {
            Particle.valueOf((String)name);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    default public void spawnParticle(World w, float x, float y, float z, String particle) {
        w.spawnParticle(Particle.valueOf((String)particle), (double)x, (double)y, (double)z, 1);
    }

    default public void spawnParticle(World w, String particle, float x, float y, float z, int offsetX, int offsetY, int offsetZ, int speed, int amount) {
        w.spawnParticle(Particle.valueOf((String)particle), (double)x, (double)y, (double)z, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed);
    }

    default public void spawnRedstoneParticle(World w, float x, float y, float z, int offsetX, int offsetY, int offsetZ, int speed, int color) {
        w.spawnParticle(Particle.REDSTONE, (double)x, (double)y, (double)z, color, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed);
    }

    default public String getForVersion(String v18, String v19, String V12, String V13) {
        return V13;
    }

    public static class SupportBuilder {
        @Nullable
        public static ParticleSupport load() {
            Class<?> c;
            String version = Bukkit.getServer().getClass().getName().split("\\.")[3];
            try {
                c = Class.forName("com.andrei1058.spigot.versionsupport.particle_" + version);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            try {
                return (ParticleSupport)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                return null;
            }
        }
    }
}

