/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures;

import com.andrei1058.spigot.versionsupport.CommandSupport;
import com.andrei1058.spigot.versionsupport.ItemStackSupport;
import com.andrei1058.spigot.versionsupport.ParticleSupport;
import com.andrei1058.vipfeatures.api.DatabaseAdapter;
import com.andrei1058.vipfeatures.api.IVipFeatures;
import com.andrei1058.vipfeatures.api.MiniGame;
import com.andrei1058.vipfeatures.api.MiniGameAlreadyRegistered;
import com.andrei1058.vipfeatures.commands.VipFeaturesCMD;
import com.andrei1058.vipfeatures.configuration.Config;
import com.andrei1058.vipfeatures.configuration.Language;
import com.andrei1058.vipfeatures.database.MySQL;
import com.andrei1058.vipfeatures.database.SQLite;
import com.andrei1058.vipfeatures.items.ItemCreator;
import com.andrei1058.vipfeatures.listeners.GeneralListeners;
import com.andrei1058.vipfeatures.metrics.bukkit.Metrics;
import com.andrei1058.vipfeatures.perks.BoostersManager;
import com.andrei1058.vipfeatures.perks.ParticleManager;
import com.andrei1058.vipfeatures.perks.SpellsManager;
import com.andrei1058.vipfeatures.perks.TrailsManager;
import com.andrei1058.vipfeatures.tasks.ParticlesTask;
import com.andrei1058.vipfeatures.tasks.TrailsTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class VipFeatures
extends JavaPlugin
implements IVipFeatures {
    public static VipFeatures plugin;
    public static Config config;
    public static Config mainGUI;
    public static Config trailsGUI;
    public static Config spellsGUI;
    public static Config particlesGUI;
    public static Config boostersGUI;
    public static DatabaseAdapter databaseAdapter;
    private static ParticleSupport particleSupport;
    private static ItemStackSupport itemStackSupport;
    public static final String INTERACT_TAG = "avf-in";
    private static final List<MiniGame> miniGames;

    static {
        miniGames = new ArrayList<MiniGame>();
    }

    public void onEnable() {
        plugin = this;
        String version = Bukkit.getServer().getClass().getName().split("\\.")[3];
        particleSupport = ParticleSupport.SupportBuilder.load();
        itemStackSupport = ItemStackSupport.SupportBuilder.load();
        CommandSupport commandSupport = CommandSupport.SupportBuilder.load();
        if (particleSupport == null || itemStackSupport == null || commandSupport == null) {
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            this.getLogger().log(Level.SEVERE, "Your server version is not supported: " + version);
            return;
        }
        Bukkit.getServicesManager().register(IVipFeatures.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        Config.setupConfiguration();
        Language.initializeLanguages();
        Config.setupMainGUI();
        Config.setupTrailsGUI();
        Config.setupSpellsGUI();
        Config.setupParticlesGUI();
        Config.setupBoostersGUI();
        if (config.getBoolean("database.enable")) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
                databaseAdapter = new MySQL();
            }, 10L);
        } else {
            databaseAdapter = new SQLite();
        }
        commandSupport.registerCommand((Plugin)this, "vipfeatures", new VipFeaturesCMD("vipfeatures", Collections.singletonList("vf"), "Opens a GUI"));
        new TrailsTask().runTaskTimerAsynchronously((Plugin)this, 0L, 1L);
        new ParticlesTask().runTaskTimerAsynchronously((Plugin)this, 0L, 6L);
        Bukkit.getPluginManager().registerEvents((Listener)new GeneralListeners(), (Plugin)this);
        Metrics metrics = new Metrics((Plugin)this, 8977);
        metrics.addCustomChart(new Metrics.AdvancedPie("mini_games", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            for (MiniGame mg : VipFeatures.getMiniGames()) {
                valueMap.put(mg.getOwner().getName(), 1);
            }
            return valueMap;
        }));
        metrics.addCustomChart(new Metrics.SimplePie("default_language", () -> config.getYml().getString("defaultLang")));
        metrics.addCustomChart(new Metrics.SimplePie("database_adapter", () -> databaseAdapter.getClass().getName()));
    }

    public static List<MiniGame> getMiniGames() {
        return miniGames;
    }

    @Override
    public void registerMiniGame(MiniGame miniGame) throws MiniGameAlreadyRegistered {
        for (MiniGame mg : miniGames) {
            if (mg.getOwner() != miniGame.getOwner()) continue;
            throw new MiniGameAlreadyRegistered(miniGame.getOwner());
        }
        miniGames.add(miniGame);
    }

    @Override
    public void givePlayerItemStack(Player player) {
        ItemCreator.givePlayerItemStack(player, config, "perksItem", "perksItem", ItemCreator.ItemType.VIPFEATURES_MAIN_GUI_OPENER, "vipfeatures.open.maingui");
    }

    @Override
    public IVipFeatures.ParticlesUtil getParticlesUtil() {
        return ParticleManager.getINSTANCE();
    }

    @Override
    public IVipFeatures.VersionUtil getVersionUtil() {
        return VipFeatures::getForCurrentVersion;
    }

    @Override
    public IVipFeatures.SpellsUtil getSpellsUtil() {
        return SpellsManager.getINSTANCE();
    }

    @Override
    public IVipFeatures.TrailsUtil getTrailsUtil() {
        return TrailsManager.getINSTANCE();
    }

    @Override
    public IVipFeatures.BoostersUtil getBoostersUtil() {
        return BoostersManager.getINSTANCE();
    }

    @Override
    public Plugin getVipFeatures() {
        return this;
    }

    @Override
    public void setDatabaseAdapter(DatabaseAdapter newAdapter) {
        if (newAdapter == null) {
            databaseAdapter = new SQLite();
            return;
        }
        databaseAdapter = newAdapter;
    }

    @Override
    public DatabaseAdapter getDatabaseAdapter() {
        return databaseAdapter;
    }

    public static String getForCurrentVersion(String v18, String v12, String v13) {
        return VipFeatures.getParticleSupport().getForVersion(v18, v12, v12, v13);
    }

    public static ParticleSupport getParticleSupport() {
        return particleSupport;
    }

    public static ItemStackSupport getItemStackSupport() {
        return itemStackSupport;
    }
}

