/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.configuration;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.api.BoosterType;
import com.andrei1058.vipfeatures.api.ParticleType;
import com.andrei1058.vipfeatures.api.SpellType;
import com.andrei1058.vipfeatures.api.TrailType;
import com.andrei1058.vipfeatures.configuration.Language;
import com.andrei1058.vipfeatures.customgui.CustomGUI;
import com.andrei1058.vipfeatures.customgui.PlayerGUI;
import com.andrei1058.vipfeatures.items.ItemCreator;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private YamlConfiguration yml;
    private final File config;

    public Config(String name, String dir) {
        File d = new File(dir);
        if (!d.exists()) {
            d.mkdir();
        }
        this.config = new File(String.valueOf(dir) + "/" + name + ".yml");
        if (!this.config.exists()) {
            try {
                this.config.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.yml = YamlConfiguration.loadConfiguration((File)this.config);
            VipFeatures.plugin.getLogger().info("Creating " + dir + "/" + name + ".yml");
        }
        this.yml = YamlConfiguration.loadConfiguration((File)this.config);
    }

    public static void setupConfiguration() {
        VipFeatures.config = new Config("config", "plugins/" + VipFeatures.plugin.getName());
        YamlConfiguration yml = VipFeatures.config.getYml();
        yml.options().copyDefaults(true);
        yml.options().header("Plugin by " + VipFeatures.plugin.getDescription().getAuthors() + "\nconfig.yml - Documentation\n\n" + "defaultLang" + ": en - Default language iso code. Make sure messages_en.yml exists!\n\n" + "database.host" + ": localhost - Database IP or DNS.\n" + "database.port" + ": 3306 - Database port.\n" + "database.ssl" + ": false - Set to true to use a https connection.\n" + "database.name" + ": vipFeatures - Database name.\n" + "database.user" + ": root - Database user.\n" + "database.pass" + ": p4ss11 - User password.\n\n" + "disableChangesWhenPlaying" + ": true - Set false to allow players select perks during the game.\n\n" + "perksItem" + ".enable - true if you want to give the item on join.\n" + "perksItem" + ".material - Item material.\n" + "perksItem" + ".data - Material data.\n" + "perksItem" + ".slot - The slot where to receive the item.\n" + "perksItem" + ".enchant - true if you want to have an enchanted item.\n\n");
        yml.addDefault("defaultLang", (Object)"en");
        yml.addDefault("database.enable", (Object)false);
        yml.addDefault("database.host", (Object)"localhost");
        yml.addDefault("database.port", (Object)3306);
        yml.addDefault("database.ssl", (Object)false);
        yml.addDefault("database.name", (Object)"vipFeatures");
        yml.addDefault("database.user", (Object)"root");
        yml.addDefault("database.pass", (Object)"bread");
        yml.addDefault("disableChangesWhenPlaying", (Object)true);
        ItemCreator.saveItemStackToConfig(VipFeatures.config, "perksItem", "perksItem", "&8Perks", Arrays.asList("", "&eRight-Click to open!"), false, 7, 0, Material.CHEST);
        VipFeatures.config.save();
    }

    public static void setupMainGUI() {
        Config c;
        VipFeatures.mainGUI = c = new Config("mainGUI", "plugins/" + VipFeatures.plugin.getName());
        PlayerGUI.setupGUI(c, "", "mainGUI", "&8Vip Perks", 27);
        PlayerGUI.createItem(c, "mainGUI.trailsGUI", Material.BLAZE_POWDER, 0, 1, 10, false, "&7Arrow &eTrails", Arrays.asList("", "&fClick to open!"), "mainGUI.trailsGUI");
        PlayerGUI.createItem(c, "mainGUI.spellsGUI", Material.valueOf((String)VipFeatures.getForCurrentVersion("WEB", "WEB", "COBWEB")), 0, 1, 12, false, "&7Arrow &eSpells", Arrays.asList("", "&fClick to open!"), "mainGUI.spellsGUI");
        PlayerGUI.createItem(c, "mainGUI.particlesGUI", Material.REDSTONE, 0, 1, 14, false, "&7Player &eParticles", Arrays.asList("", "&fClick to open!"), "mainGUI.particlesGUI");
        PlayerGUI.createItem(c, "mainGUI.boostersGUI", Material.APPLE, 0, 1, 16, false, "&7Points &eBoosters", Arrays.asList("", "&fClick to open!"), "mainGUI.boostersGUI");
        for (Language l : Language.getLanguages()) {
            CustomGUI g = l.getGUI("mainGUI");
            g.addItem("mainGUI.trailsGUI", "mainGUI.trailsGUI");
            g.addItem("mainGUI.spellsGUI", "mainGUI.spellsGUI");
            g.addItem("mainGUI.particlesGUI", "mainGUI.particlesGUI");
            g.addItem("mainGUI.boostersGUI", "mainGUI.boostersGUI");
        }
    }

    public static void setupTrailsGUI() {
        Config c;
        VipFeatures.trailsGUI = c = new Config("trailsGUI", "plugins/" + VipFeatures.plugin.getName());
        PlayerGUI.setupGUI(c, "", "trailsGUI", "&8Arrow Trails", 27);
        PlayerGUI.createItem(c, "trailsGUI." + (Object)((Object)TrailType.FIRE), Material.BLAZE_POWDER, 0, 1, 11, false, "&cFire &7Trail", Arrays.asList("", "&f{status}"), "trailsGUI.fireTrails");
        PlayerGUI.createItem(c, "trailsGUI." + (Object)((Object)TrailType.SLIME), Material.SLIME_BALL, 0, 1, 12, false, "&aSlime &7Trail", Arrays.asList("", "&f{status}"), "trailsGUI.slimeTrail");
        PlayerGUI.createItem(c, "trailsGUI." + (Object)((Object)TrailType.WATER), Material.WATER_BUCKET, 0, 1, 13, false, "&bWater &7Trail", Arrays.asList("", "&f{status}"), "trailsGUI.waterTrail");
        PlayerGUI.createItem(c, "trailsGUI." + (Object)((Object)TrailType.NOTES), Material.JUKEBOX, 0, 1, 14, false, "&dNotes &7Trail", Arrays.asList("", "&f{status}"), "trailsGUI.notesTrail");
        PlayerGUI.createItem(c, "trailsGUI." + (Object)((Object)TrailType.CRYSTAL), Material.GLASS, 0, 1, 15, false, "&fCrystal &7Trail", Arrays.asList("", "&f{status}"), "trailsGUI.crystalTrail");
        PlayerGUI.createItem(c, "trailsGUI.backItem", Material.ARROW, 0, 1, 22, false, "&8Back", Arrays.asList("", "&fClick to go back!"), "trailsGUI.backItem");
        for (Language l : Language.getLanguages()) {
            CustomGUI g = l.getGUI("trailsGUI");
            g.addItem("trailsGUI." + (Object)((Object)TrailType.FIRE), "trailsGUI.fireTrails");
            g.addItem("trailsGUI." + (Object)((Object)TrailType.SLIME), "trailsGUI.slimeTrail");
            g.addItem("trailsGUI." + (Object)((Object)TrailType.WATER), "trailsGUI.waterTrail");
            g.addItem("trailsGUI." + (Object)((Object)TrailType.NONE), "trailsGUI.notesTrail");
            g.addItem("trailsGUI." + (Object)((Object)TrailType.CRYSTAL), "trailsGUI.crystalTrail");
            g.addItem("trailsGUI.backItem", "trailsGUI.backItem");
        }
    }

    public static void setupSpellsGUI() {
        Config c;
        VipFeatures.spellsGUI = c = new Config("spellsGUI", "plugins/" + VipFeatures.plugin.getName());
        PlayerGUI.setupGUI(c, "", "spellsGUI", "&8Arrow Spells", 27);
        PlayerGUI.createItem(c, "spellsGUI." + (Object)((Object)SpellType.EXPLOSIVE), Material.TNT, 0, 1, 11, false, "&cExplosive &7Spell", Arrays.asList("", "&f{status}"), "spellsGUI.explosiveSpell");
        PlayerGUI.createItem(c, "spellsGUI." + (Object)((Object)SpellType.FIRE), Material.BLAZE_POWDER, 0, 0, 12, false, "&cFire &7Spell", Arrays.asList("", "&f{status}"), "spellsGUI.fireSpell");
        PlayerGUI.createItem(c, "spellsGUI." + (Object)((Object)SpellType.WEB), Material.valueOf((String)VipFeatures.getForCurrentVersion("WEB", "WEB", "COBWEB")), 0, 1, 13, false, "&fWeb &7Spell", Arrays.asList("", "&f{status}"), "spellsGUI.webSpell");
        PlayerGUI.createItem(c, "spellsGUI." + (Object)((Object)SpellType.ZOMBIE), Material.valueOf((String)VipFeatures.getForCurrentVersion("SKULL_ITEM", "SKULL_ITEM", "PLAYER_HEAD")), 2, 1, 14, false, "&dZombie &7Spell", Arrays.asList("", "&f{status}"), "spellsGUI.zombieSpell");
        PlayerGUI.createItem(c, "spellsGUI." + (Object)((Object)SpellType.POISON), Material.POTION, 0, 1, 15, false, "&cPoison &7Spell", Arrays.asList("", "&f{status}"), "spellsGUI.poisonSpell");
        PlayerGUI.createItem(c, "spellsGUI.backItem", Material.ARROW, 0, 1, 22, false, "&8Back", Arrays.asList("", "&fClick to go back!"), "spellsGUI.backItem");
        for (Language l : Language.getLanguages()) {
            CustomGUI g = l.getGUI("spellsGUI");
            g.addItem("spellsGUI." + (Object)((Object)SpellType.EXPLOSIVE), "spellsGUI.explosiveSpell");
            g.addItem("spellsGUI." + (Object)((Object)SpellType.FIRE), "spellsGUI.fireSpell");
            g.addItem("spellsGUI." + (Object)((Object)SpellType.WEB), "spellsGUI.webSpell");
            g.addItem("spellsGUI." + (Object)((Object)SpellType.ZOMBIE), "spellsGUI.zombieSpell");
            g.addItem("spellsGUI." + (Object)((Object)SpellType.POISON), "spellsGUI.poisonSpell");
            g.addItem("spellsGUI.backItem", "spellsGUI.backItem");
        }
    }

    public static void setupParticlesGUI() {
        Config c;
        VipFeatures.particlesGUI = c = new Config("particlesGUI", "plugins/" + VipFeatures.plugin.getName());
        PlayerGUI.setupGUI(c, "", "particlesGUI", "&8Player Particles", 27);
        PlayerGUI.createItem(c, "particlesGUI." + (Object)((Object)ParticleType.SPIRAL), Material.REDSTONE, 0, 1, 10, false, "&eSpiral &7Particles", Arrays.asList("", "&f{status}"), "particlesGUI.spiralParticles");
        PlayerGUI.createItem(c, "particlesGUI." + (Object)((Object)ParticleType.ANGRY_VILLAGER), Material.GLOWSTONE_DUST, 0, 0, 11, false, "&cAngry Villager &7Particles", Arrays.asList("", "&f{status}"), "particlesGUI.angryParticles");
        PlayerGUI.createItem(c, "particlesGUI." + (Object)((Object)ParticleType.DOUBLE_WITCH), Material.ANVIL, 0, 1, 12, false, "&fDouble Witch &7Particles", Arrays.asList("", "&f{status}"), "particlesGUI.doubleWitchParticles");
        PlayerGUI.createItem(c, "particlesGUI." + (Object)((Object)ParticleType.NOTES), Material.JUKEBOX, 0, 1, 14, false, "&dMusic &7Particles", Arrays.asList("", "&f{status}"), "particlesGUI.notesParticles");
        PlayerGUI.createItem(c, "particlesGUI." + (Object)((Object)ParticleType.MAGIC), Material.valueOf((String)VipFeatures.getForCurrentVersion("ENCHANTMENT_TABLE", "ENCHANTMENT_TABLE", "ENCHANTING_TABLE")), 0, 1, 15, false, "&3Magic &7Particles", Arrays.asList("", "&f{status}"), "particlesGUI.magicParticles");
        PlayerGUI.createItem(c, "particlesGUI." + (Object)((Object)ParticleType.HAPPY_VILLAGER), Material.EMERALD, 0, 1, 16, false, "&aHappy Villager &7Particles", Arrays.asList("", "&f{status}"), "particlesGUI.happyParticles");
        PlayerGUI.createItem(c, "particlesGUI.backItem" + (Object)((Object)ParticleType.SPIRAL), Material.ARROW, 0, 1, 22, false, "&8Back", Arrays.asList("", "&fClick to go back!"), "particlesGUI.backItem");
        for (Language l : Language.getLanguages()) {
            CustomGUI g = l.getGUI("particlesGUI");
            g.addItem("particlesGUI." + (Object)((Object)ParticleType.SPIRAL), "particlesGUI.spiralParticles");
            g.addItem("particlesGUI." + (Object)((Object)ParticleType.ANGRY_VILLAGER), "particlesGUI.angryParticles");
            g.addItem("particlesGUI." + (Object)((Object)ParticleType.DOUBLE_WITCH), "particlesGUI.doubleWitchParticles");
            g.addItem("particlesGUI." + (Object)((Object)ParticleType.NOTES), "particlesGUI.notesParticles");
            g.addItem("particlesGUI." + (Object)((Object)ParticleType.MAGIC), "particlesGUI.magicParticles");
            g.addItem("particlesGUI." + (Object)((Object)ParticleType.HAPPY_VILLAGER), "particlesGUI.happyParticles");
            g.addItem("particlesGUI.backItem", "particlesGUI.backItem");
        }
    }

    public static void setupBoostersGUI() {
        Config c;
        VipFeatures.boostersGUI = c = new Config("boostersGUI", "plugins/" + VipFeatures.plugin.getName());
        PlayerGUI.setupGUI(c, "", "boostersGUI", "&8Coins Multipliers", 27);
        PlayerGUI.createItem(c, "boostersGUI." + (Object)((Object)BoosterType.BOOSTER_X_2), Material.IRON_INGOT, 0, 1, 11, false, "&cCoins Booster &dx2", Arrays.asList("", "&f{status}"), "boostersGUI.boosterX2");
        PlayerGUI.createItem(c, "boostersGUI." + (Object)((Object)BoosterType.BOOSTER_X_3), Material.GOLD_INGOT, 0, 1, 15, false, "&cCoins Booster &dx3", Arrays.asList("", "&f{status}"), "boostersGUI.boosterX3");
        PlayerGUI.createItem(c, "boostersGUI.backItem", Material.ARROW, 0, 1, 22, false, "&8Back", Arrays.asList("", "&fClick to go back!"), "boostersGUI.backItem");
        for (Language l : Language.getLanguages()) {
            CustomGUI g = l.getGUI("boostersGUI");
            g.addItem("boostersGUI." + (Object)((Object)BoosterType.BOOSTER_X_2), "boostersGUI.boosterX2");
            g.addItem("boostersGUI." + (Object)((Object)BoosterType.BOOSTER_X_3), "boostersGUI.boosterX3");
            g.addItem("boostersGUI.backItem", "boostersGUI.backItem");
        }
    }

    public void set(String path, Object value) {
        this.yml.set(path, value);
        this.save();
    }

    public YamlConfiguration getYml() {
        return this.yml;
    }

    public void save() {
        try {
            this.yml.save(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean exists(String path) {
        return this.yml.get(path) != null;
    }

    public List<String> getList(String path) {
        return this.yml.getStringList(path).stream().map(s -> s.replace("&", "\u00a7")).collect(Collectors.toList());
    }

    public boolean getBoolean(String path) {
        return this.yml.getBoolean(path);
    }

    public int getInt(String path) {
        return this.yml.getInt(path);
    }
}

