/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.configuration;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.customgui.CustomGUI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Language {
    private YamlConfiguration yml;
    private File config;
    private String iso;
    private String prefixColor = "";
    private String langName = "English";
    private static HashMap<Player, Language> langByPlayer = new HashMap();
    private static List<Language> languages = new ArrayList<Language>();
    private List<CustomGUI> langGUIs = new ArrayList<CustomGUI>();
    private VipFeatures plugin = VipFeatures.plugin;
    private static Language defaultLanguage;

    public Language(String iso, boolean addToList) {
        this.iso = iso;
        File d = new File("plugins/" + this.plugin.getDescription().getName() + "/Languages");
        if (!d.exists()) {
            d.mkdir();
        }
        this.config = new File(d.toPath() + "/messages_" + iso + ".yml");
        if (!this.config.exists()) {
            try {
                this.config.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.plugin.getLogger().info("Creating " + d.toPath() + "/messages_" + iso + ".yml");
        }
        this.yml = YamlConfiguration.loadConfiguration((File)this.config);
        Language.setupLang(this);
        if (addToList) {
            languages.add(this);
        }
    }

    private static void setupLang(Language lbj) {
        YamlConfiguration yml = lbj.yml;
        yml.options().copyDefaults(true);
        String string = lbj.iso;
        string.hashCode();
        yml.addDefault("prefix", (Object)"&8Perks> ");
        yml.addDefault("name", (Object)"English");
        yml.addDefault("statusReplacement.noPerm", (Object)"&c&o(Locked) &3Requires a higher rank!");
        yml.addDefault("statusReplacement.clickToSelect", (Object)"&eClick to select!");
        yml.addDefault("statusReplacement.selected", (Object)"&aClick to deselect!");
        yml.addDefault("trailSelected", (Object)"{prefix}&eTrail selected &a{name}&e!");
        yml.addDefault("arrowSelected", (Object)"{prefix}&eSpell selected &a{name}&e!");
        yml.addDefault("boosterSelected", (Object)"{prefix}&eBooster selected &a{name}&e!");
        yml.addDefault("particlesSelected", (Object)"{prefix}&eParticles selected &a{name}&e!");
        yml.addDefault("cantOpenWhilePlaying", (Object)"{prefix}&eYou can't do this while playing :(");
        yml.addDefault("cantOpenNoPerm", (Object)"{prefix}&cYou can't do that :(");
        yml.addDefault("noBoostersForMinigame", (Object)"{prefix}&eThis booster won't be applied for &c{minigame}&e.");
        yml.addDefault("none", (Object)"None");
        lbj.save();
        lbj.langName = lbj.m("name");
        lbj.prefixColor = ChatColor.translateAlternateColorCodes((char)'&', (String)yml.getString("prefix"));
    }

    public static void initializeLanguages() {
        new Language("en", false);
        String whatLang = "en";
        File[] fileArray = Objects.requireNonNull(new File("plugins/" + VipFeatures.plugin.getDescription().getName() + "/Languages").listFiles());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().contains("messages_") && f.getName().contains(".yml")) {
                String lang = f.getName().replace("messages_", "").replace(".yml", "");
                if (lang.equalsIgnoreCase(VipFeatures.config.getYml().getString("defaultLang"))) {
                    whatLang = f.getName().replace("messages_", "").replace(".yml", "");
                }
                Language.setupLang(new Language(lang, true));
            }
            ++n2;
        }
        Language.setDefaultLanguage(Language.getLang(whatLang));
    }

    public void set(String path, Object value) {
        this.yml.set(path, value);
        this.save();
    }

    public String getLangName() {
        return this.langName;
    }

    public void save() {
        try {
            this.yml.save(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getMsg(Player p, String path) {
        return langByPlayer.containsKey(p) ? langByPlayer.get(p).m(path) : defaultLanguage.m(path);
    }

    public static Language getPlayerLanguage(Player p) {
        return langByPlayer.containsKey(p) ? langByPlayer.get(p) : defaultLanguage;
    }

    public boolean exists(String path) {
        return this.yml.get(path) != null;
    }

    public static List<String> getList(Player p, String path) {
        return langByPlayer.containsKey(p) ? langByPlayer.get(p).l(path) : defaultLanguage.l(path);
    }

    public static void saveIfNotExists(String path, Object data) {
        Bukkit.getScheduler().runTaskLater((Plugin)VipFeatures.plugin, () -> {
            for (Language l : languages) {
                if (l.yml.get(path) != null) continue;
                l.set(path, data);
            }
        }, 10L);
    }

    public String m(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.yml.getString(path).replace("{prefix}", this.prefixColor));
    }

    public List<String> l(String path) {
        return this.yml.getStringList(path).stream().map(s -> s.replace("&", "\u00a7")).collect(Collectors.toList());
    }

    public static HashMap<Player, Language> getLangByPlayer() {
        return langByPlayer;
    }

    public static boolean isLanguageExist(String iso) {
        for (Language l : languages) {
            if (!l.iso.equalsIgnoreCase(iso)) continue;
            return true;
        }
        return false;
    }

    public static Language getLang(String iso) {
        for (Language l : languages) {
            if (!l.iso.equalsIgnoreCase(iso)) continue;
            return l;
        }
        return defaultLanguage;
    }

    public void reload() {
        this.yml = YamlConfiguration.loadConfiguration((File)this.config);
    }

    public String getIso() {
        return this.iso;
    }

    public static List<Language> getLanguages() {
        return languages;
    }

    public List<CustomGUI> getLangGUIs() {
        return this.langGUIs;
    }

    public CustomGUI getGUI(String name) {
        for (CustomGUI sg : this.langGUIs) {
            if (!sg.getName().equalsIgnoreCase(name)) continue;
            return sg;
        }
        return null;
    }

    public static void setDefaultLanguage(Language defaultLanguage) {
        Language.defaultLanguage = defaultLanguage;
    }

    public void openGUI(String name, Player p, String permission) {
        CustomGUI gui = this.getGUI(name);
        if (gui == null) {
            return;
        }
        if (permission != null && !permission.isEmpty() && !p.hasPermission(permission)) {
            p.sendMessage(Language.getMsg(p, "cantOpenNoPerm"));
            p.closeInventory();
            return;
        }
        gui.open(p);
    }
}

