/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.customgui;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.api.BoosterType;
import com.andrei1058.vipfeatures.api.ParticleType;
import com.andrei1058.vipfeatures.api.SpellType;
import com.andrei1058.vipfeatures.api.TrailType;
import com.andrei1058.vipfeatures.configuration.Config;
import com.andrei1058.vipfeatures.configuration.Language;
import com.andrei1058.vipfeatures.customgui.CustomGUI;
import com.andrei1058.vipfeatures.perks.BoostersManager;
import com.andrei1058.vipfeatures.perks.ParticleManager;
import com.andrei1058.vipfeatures.perks.SpellsManager;
import com.andrei1058.vipfeatures.perks.TrailsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerGUI
extends CustomGUI {
    private final HashMap<String, String> paths = new HashMap();

    public PlayerGUI(String name, int size, Config cm, Language lang) {
        super(name, size, cm, lang);
        this.setDisplayName(lang.m(String.valueOf(name) + ".name"));
    }

    @Override
    public void open(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(), (String)this.getDisplayName().replace("{player}", p.getName()));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)VipFeatures.plugin, () -> {
            String selected = "";
            String permission = "";
            if (this.getName().equalsIgnoreCase("particlesGUI")) {
                ParticleType particlesType = ParticleManager.getINSTANCE().getPlayerParticles(p);
                selected = particlesType.toString();
                permission = particlesType.getPermission();
            } else if (this.getName().contains("spellsGUI")) {
                SpellType spellType = SpellsManager.getINSTANCE().getPlayerSpells(p);
                selected = spellType.toString();
                permission = spellType.getPermission();
            } else if (this.getName().equalsIgnoreCase("boostersGUI")) {
                BoosterType boosterType = BoostersManager.getINSTANCE().getPlayerBooster(p);
                selected = boosterType.toString();
                permission = boosterType.getPermission();
            } else if (this.getName().equalsIgnoreCase("trailsGUI")) {
                TrailType trailType = TrailsManager.getINSTANCE().getPlayerTrails(p);
                selected = trailType.toString();
                permission = trailType.getPermission();
            }
            for (Map.Entry<String, String> e : this.paths.entrySet()) {
                String itemName = e.getValue();
                if (itemName.contains(".")) {
                    String[] temp = itemName.split("\\.");
                    itemName = itemName.split("\\.")[temp.length - 1];
                }
                this.addItemStack(e.getKey(), e.getValue(), inv, selected.equals(itemName), p.hasPermission(permission));
            }
            Bukkit.getScheduler().runTask((Plugin)VipFeatures.plugin, () -> {
                InventoryView inventoryView = p.openInventory(inv);
            });
        });
    }

    @Override
    public void addItem(String itemPath, String langPath) {
        if (!this.getCm().exists(itemPath)) {
            return;
        }
        if (!this.getCm().exists(String.valueOf(itemPath) + ".material")) {
            return;
        }
        try {
            Material.valueOf((String)this.getCm().getYml().getString(String.valueOf(itemPath) + ".material"));
        }
        catch (Exception e) {
            return;
        }
        if (!this.getCm().exists(String.valueOf(itemPath) + ".slot")) {
            return;
        }
        if (!this.getLang().exists(langPath)) {
            this.getLang().set(String.valueOf(langPath) + ".name", "&cNAME NOT SET");
            this.getLang().set(String.valueOf(langPath) + ".lore", Arrays.asList("", "&7Lore not set!"));
        }
        this.paths.put(itemPath, langPath);
    }

    public void addItemStack(String itemPath, String langPath, Inventory inv, boolean selected, boolean permission) {
        String name = "";
        if (this.getLang().exists(String.valueOf(langPath) + ".name")) {
            name = this.getLang().m(String.valueOf(langPath) + ".name");
        }
        if (selected) {
            name = ChatColor.BOLD + name;
        }
        boolean enchanted = false;
        if (this.getCm().exists(String.valueOf(itemPath) + ".enchanted")) {
            enchanted = this.getCm().getBoolean(String.valueOf(itemPath) + ".enchanted");
        }
        ArrayList<String> newLore = new ArrayList<String>();
        if (this.getLang().exists(String.valueOf(langPath) + ".lore")) {
            for (String s : this.getLang().l(String.valueOf(langPath) + ".lore")) {
                if (s.contains("{status}")) {
                    s = !permission ? s.replace("{status}", this.getLang().m("statusReplacement.noPerm")) : (selected ? s.replace("{status}", this.getLang().m("statusReplacement.selected")) : s.replace("{status}", this.getLang().m("statusReplacement.clickToSelect")));
                }
                newLore.add(s);
            }
        }
        inv.setItem(this.getCm().getInt(String.valueOf(itemPath) + ".slot"), PlayerGUI.createItemStack(name, enchanted, newLore, Material.valueOf((String)this.getCm().getYml().getString(String.valueOf(itemPath) + ".material")), this.getCm().exists(String.valueOf(itemPath) + ".data") ? this.getCm().getInt(String.valueOf(itemPath) + ".data") : 0, this.getCm().exists(String.valueOf(itemPath) + ".amount") ? this.getCm().getInt(String.valueOf(itemPath) + ".amount") : 1));
    }

    public static void createItem(Config cm, String itemPath, Material material, int data, int amount, int slot, boolean enchanted, String name, List<String> lore, String langPath) {
        if (!cm.exists(String.valueOf(itemPath) + ".material")) {
            cm.set(String.valueOf(itemPath) + ".material", material.toString());
        }
        if (data != 0 || !cm.exists(String.valueOf(itemPath) + ".data")) {
            cm.set(String.valueOf(itemPath) + ".data", data);
        }
        if (amount > 1 && !cm.exists(String.valueOf(itemPath) + ".amount")) {
            cm.set(String.valueOf(itemPath) + ".amount", amount);
        }
        if (!cm.exists(String.valueOf(itemPath) + ".slot")) {
            cm.set(String.valueOf(itemPath) + ".slot", slot);
        }
        if (enchanted && !cm.exists(String.valueOf(itemPath) + ".enchanted")) {
            cm.set(String.valueOf(itemPath) + ".enchanted", enchanted);
        }
        for (Language l : Language.getLanguages()) {
            if (!l.exists(String.valueOf(langPath) + ".name")) {
                l.set(String.valueOf(langPath) + ".name", name);
            }
            if (lore == null || l.exists(String.valueOf(langPath) + ".lore")) continue;
            l.set(String.valueOf(langPath) + ".lore", lore);
        }
    }

    public static void setupGUI(Config cm, String path, String name, String displayName, int size) {
        if (!path.isEmpty()) {
            path = String.valueOf(path) + ".";
        }
        if (!cm.exists(String.valueOf(path) + name + ".invSize")) {
            cm.set(String.valueOf(path) + name + ".invSize", size);
        }
        for (Language l : Language.getLanguages()) {
            if (l.exists(String.valueOf(name) + ".name")) continue;
            l.set(String.valueOf(name) + ".name", displayName);
        }
        for (Language l : Language.getLanguages()) {
            l.getLangGUIs().add(new PlayerGUI(name, size, cm, l));
        }
    }

    public static ItemStack createItemStack(String name, boolean enchanted, List<String> lore, Material material, int data, int amount) {
        ItemStack i = new ItemStack(material, amount, (short)data);
        ItemMeta im = i.getItemMeta();
        if (enchanted) {
            im.addEnchant(Enchantment.LUCK, 1, true);
        }
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        im.setDisplayName(name);
        if (lore != null) {
            im.setLore(lore);
        }
        i.setItemMeta(im);
        return i;
    }
}

