/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.database;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.api.BoosterType;
import com.andrei1058.vipfeatures.api.DatabaseAdapter;
import com.andrei1058.vipfeatures.api.ParticleType;
import com.andrei1058.vipfeatures.api.SpellType;
import com.andrei1058.vipfeatures.api.TrailType;
import com.andrei1058.vipfeatures.configuration.Config;
import com.andrei1058.vipfeatures.database.SQLite;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

public class MySQL
implements DatabaseAdapter {
    private Connection connection;
    private String host;
    private String database;
    private String user;
    private String pass;
    private Config config = VipFeatures.config;
    private VipFeatures plugin = VipFeatures.plugin;
    int port;
    boolean ssl;

    public MySQL() {
        this.host = this.config.getYml().getString("database.host");
        this.database = this.config.getYml().getString("database.name");
        this.user = this.config.getYml().getString("database.user");
        this.pass = this.config.getYml().getString("database.pass");
        this.port = this.config.getYml().getInt("database.port");
        this.ssl = this.config.getYml().getBoolean("database.ssl");
        try {
            try {
                this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?user=" + this.user + "&password=" + this.pass + "&useSSL=" + this.ssl);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.plugin.getLogger().severe("Can't connect to database: " + this.database);
                this.plugin.getLogger().severe(e.getMessage());
                VipFeatures.databaseAdapter = new SQLite();
                if (this.isConnected()) {
                    this.connect();
                    this.plugin.getLogger().info("Connected to database: " + this.database);
                    this.setupBoostersTable();
                    this.setupParticlesTable();
                    this.setupSpellsTable();
                    this.setupTrailsTable();
                }
            }
        }
        finally {
            if (this.isConnected()) {
                this.connect();
                this.plugin.getLogger().info("Connected to database: " + this.database);
                this.setupBoostersTable();
                this.setupParticlesTable();
                this.setupSpellsTable();
                this.setupTrailsTable();
            }
        }
    }

    public boolean connect() {
        try {
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?autoReconnect=true&user=" + this.user + "&password=" + this.pass + "&useSSL=" + this.ssl);
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public void close() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setupTrailsTable() {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS vipFeatures_trails (id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(36), selected VARCHAR(30));");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setupSpellsTable() {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS vipFeatures_spells (id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(36), selected VARCHAR(30));");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setupParticlesTable() {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS vipFeatures_particles (id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(36), selected VARCHAR(30));");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setupBoostersTable() {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS vipFeatures_boosters (id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(36), selected VARCHAR(30));");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TrailType getSelectedTrails(UUID uuid) {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT selected FROM vipFeatures_trails WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                return TrailType.valueOf(rs.getString("selected"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return TrailType.NONE;
    }

    @Override
    public SpellType getSelectedSpells(UUID uuid) {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT selected FROM vipFeatures_spells WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                return SpellType.valueOf(rs.getString("selected"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return SpellType.NONE;
    }

    @Override
    public ParticleType getSelectedParticles(UUID uuid) {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT selected FROM vipFeatures_particles WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                return ParticleType.valueOf(rs.getString("selected"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ParticleType.NONE;
    }

    @Override
    public BoosterType getSelectedBooster(UUID uuid) {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT selected FROM vipFeatures_boosters WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                return BoosterType.valueOf(rs.getString("selected"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return BoosterType.NONE;
    }

    @Override
    public void setSelectedBooster(UUID uuid, BoosterType boosterType) {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT id FROM vipFeatures_boosters WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                this.connection.createStatement().executeUpdate("UPDATE vipFeatures_boosters SET selected='" + boosterType.toString() + "' WHERE uuid='" + uuid.toString() + "';");
            } else {
                this.connection.createStatement().executeUpdate("INSERT INTO vipFeatures_boosters VALUES(0, '" + uuid.toString() + "', '" + boosterType.toString() + "');");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSelectedParticles(UUID uuid, ParticleType particlesType) {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT id FROM vipFeatures_particles WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                this.connection.createStatement().executeUpdate("UPDATE vipFeatures_particles SET selected='" + particlesType.toString() + "' WHERE uuid='" + uuid.toString() + "';");
            } else {
                this.connection.createStatement().executeUpdate("INSERT INTO vipFeatures_particles VALUES(0, '" + uuid.toString() + "', '" + particlesType.toString() + "');");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSelectedSpells(UUID uuid, SpellType spellType) {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT id FROM vipFeatures_spells WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                this.connection.createStatement().executeUpdate("UPDATE vipFeatures_spells SET selected='" + spellType.toString() + "' WHERE uuid='" + uuid.toString() + "';");
            } else {
                this.connection.createStatement().executeUpdate("INSERT INTO vipFeatures_spells VALUES(0, '" + uuid.toString() + "', '" + spellType.toString() + "');");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSelectedTrails(UUID uuid, TrailType trailType) {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT id FROM vipFeatures_trails WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                this.connection.createStatement().executeUpdate("UPDATE vipFeatures_trails SET selected='" + trailType.toString() + "' WHERE uuid='" + uuid.toString() + "';");
            } else {
                this.connection.createStatement().executeUpdate("INSERT INTO vipFeatures_trails VALUES(0, '" + uuid.toString() + "', '" + trailType.toString() + "');");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return this.connection != null;
    }
}

