/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.database;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.api.BoosterType;
import com.andrei1058.vipfeatures.api.DatabaseAdapter;
import com.andrei1058.vipfeatures.api.ParticleType;
import com.andrei1058.vipfeatures.api.SpellType;
import com.andrei1058.vipfeatures.api.TrailType;
import com.andrei1058.vipfeatures.database.None;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.bukkit.Bukkit;

public class SQLite
implements DatabaseAdapter {
    private Connection connection;

    public SQLite() {
        File dataFolder;
        File folder = VipFeatures.plugin.getDataFolder();
        if (!folder.exists() && !folder.mkdir()) {
            VipFeatures.plugin.getLogger().severe("Could not create plugin folder!");
        }
        if (!(dataFolder = new File(String.valueOf(folder.getPath()) + "/local-database.db")).exists()) {
            try {
                if (!dataFolder.createNewFile()) {
                    VipFeatures.plugin.getLogger().severe("Could not create /Cache/shop.db file!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            ClassLoader cl = Bukkit.getServer().getClass().getClassLoader();
            Driver d = (Driver)cl.loadClass("org.sqlite.JDBC").newInstance();
            DriverManager.registerDriver(d);
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dataFolder);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
            if (e instanceof ClassNotFoundException) {
                VipFeatures.plugin.getLogger().severe("Could Not Found SQLite Driver on your system!");
            }
            e.printStackTrace();
            VipFeatures.databaseAdapter = new None();
            return;
        }
        VipFeatures.plugin.getLogger().info("Using SQLite adapter.");
        this.setupBoostersTable();
        this.setupParticlesTable();
        this.setupSpellsTable();
        this.setupTrailsTable();
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void setupTrailsTable() {
        String sql = "CREATE TABLE IF NOT EXISTS vipFeatures_trails (id INTEGER PRIMARY KEY AUTOINCREMENT, uuid VARCHAR(36), selected VARCHAR(30));";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(sql);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setupSpellsTable() {
        String sql = "CREATE TABLE IF NOT EXISTS vipFeatures_spells (id INTEGER PRIMARY KEY AUTOINCREMENT, uuid VARCHAR(36), selected VARCHAR(30));";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(sql);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setupParticlesTable() {
        String sql = "CREATE TABLE IF NOT EXISTS vipFeatures_particles (id INTEGER PRIMARY KEY AUTOINCREMENT, uuid VARCHAR(36), selected VARCHAR(30));";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(sql);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setupBoostersTable() {
        String sql = "CREATE TABLE IF NOT EXISTS vipFeatures_boosters (id INTEGER PRIMARY KEY AUTOINCREMENT, uuid VARCHAR(36), selected VARCHAR(30));";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(sql);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public TrailType getSelectedTrails(UUID uuid) {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT selected FROM vipFeatures_trails WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                return TrailType.valueOf(rs.getString("selected"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return TrailType.NONE;
    }

    @Override
    public SpellType getSelectedSpells(UUID uuid) {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT selected FROM vipFeatures_spells WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                return SpellType.valueOf(rs.getString("selected"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return SpellType.NONE;
    }

    @Override
    public ParticleType getSelectedParticles(UUID uuid) {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT selected FROM vipFeatures_particles WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                return ParticleType.valueOf(rs.getString("selected"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ParticleType.NONE;
    }

    @Override
    public BoosterType getSelectedBooster(UUID uuid) {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT selected FROM vipFeatures_boosters WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                return BoosterType.valueOf(rs.getString("selected"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return BoosterType.NONE;
    }

    @Override
    public void setSelectedBooster(UUID uuid, BoosterType boosterType) {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT id FROM vipFeatures_boosters WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                this.connection.createStatement().executeUpdate("UPDATE vipFeatures_boosters SET selected='" + boosterType.toString() + "' WHERE uuid='" + uuid.toString() + "';");
            } else {
                this.connection.createStatement().executeUpdate("INSERT INTO vipFeatures_boosters VALUES(0, '" + uuid.toString() + "', '" + boosterType.toString() + "');");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSelectedParticles(UUID uuid, ParticleType particlesType) {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT id FROM vipFeatures_particles WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                this.connection.createStatement().executeUpdate("UPDATE vipFeatures_particles SET selected='" + particlesType.toString() + "' WHERE uuid='" + uuid.toString() + "';");
            } else {
                this.connection.createStatement().executeUpdate("INSERT INTO vipFeatures_particles VALUES(0, '" + uuid.toString() + "', '" + particlesType.toString() + "');");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSelectedSpells(UUID uuid, SpellType spellType) {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT id FROM vipFeatures_spells WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                this.connection.createStatement().executeUpdate("UPDATE vipFeatures_spells SET selected='" + spellType.toString() + "' WHERE uuid='" + uuid.toString() + "';");
            } else {
                this.connection.createStatement().executeUpdate("INSERT INTO vipFeatures_spells VALUES(0, '" + uuid.toString() + "', '" + spellType.toString() + "');");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSelectedTrails(UUID uuid, TrailType trailType) {
        try {
            ResultSet rs = this.connection.createStatement().executeQuery("SELECT id FROM vipFeatures_trails WHERE uuid='" + uuid.toString() + "';");
            if (rs.next()) {
                this.connection.createStatement().executeUpdate("UPDATE vipFeatures_trails SET selected='" + trailType.toString() + "' WHERE uuid='" + uuid.toString() + "';");
            } else {
                this.connection.createStatement().executeUpdate("INSERT INTO vipFeatures_trails VALUES(0, '" + uuid.toString() + "', '" + trailType.toString() + "');");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

