/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.items;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.configuration.Config;
import com.andrei1058.vipfeatures.configuration.Language;
import com.andrei1058.vipfeatures.exceptions.InvalidMaterial;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemCreator {
    public static void givePlayerItemStack(Player p, Config config, String configPath, String langPath, ItemType itemType, String permission) {
        if (!config.getBoolean(String.valueOf(configPath) + ".enable")) {
            return;
        }
        if (!p.hasPermission(permission)) {
            return;
        }
        try {
            p.getInventory().setItem(config.getInt(String.valueOf(configPath) + ".slot"), ItemCreator.getItemStack(config, configPath, langPath, Language.getPlayerLanguage(p), itemType));
        }
        catch (InvalidMaterial invalidMaterial) {
            invalidMaterial.printStackTrace();
        }
    }

    public static void saveItemStackToConfig(Config config, String configPath, String langPath, String displayName, List<String> lore, boolean enchant, int slot, int data, Material material) {
        if (!config.exists(String.valueOf(configPath) + ".material")) {
            config.set(String.valueOf(configPath) + ".material", material.toString());
        }
        if (!config.exists(String.valueOf(configPath) + ".data")) {
            config.set(String.valueOf(configPath) + ".data", data);
        }
        if (!config.exists(String.valueOf(configPath) + ".enchanted")) {
            config.set(String.valueOf(configPath) + ".enchanted", enchant);
        }
        if (!config.exists(String.valueOf(configPath) + ".slot")) {
            config.set(String.valueOf(configPath) + ".slot", slot);
        }
        if (!config.exists(String.valueOf(configPath) + ".enable")) {
            config.set(String.valueOf(configPath) + ".enable", true);
        }
        Language.saveIfNotExists(String.valueOf(langPath) + ".name", displayName);
        Language.saveIfNotExists(String.valueOf(langPath) + ".lore", lore);
    }

    public static ItemStack getItemStack(Config config, String configPath, String langPath, Language language, ItemType itemType) throws InvalidMaterial {
        ItemStack i;
        try {
            i = new ItemStack(Material.valueOf((String)config.getYml().getString(String.valueOf(configPath) + ".material")), 1, (short)config.getInt(String.valueOf(configPath) + ".data"));
        }
        catch (Exception ex) {
            throw new InvalidMaterial("Invalid material at: " + configPath);
        }
        ItemMeta im = i.getItemMeta();
        if (config.getBoolean(String.valueOf(configPath) + ".enchanted")) {
            im.addEnchant(Enchantment.LUCK, 1, true);
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        im.setDisplayName(language.m(String.valueOf(langPath) + ".name"));
        im.setLore(language.l(String.valueOf(langPath) + ".lore"));
        i.setItemMeta(im);
        return VipFeatures.getItemStackSupport().addTag(i, "avf-in", itemType.toString());
    }

    public static enum ItemType {
        VIPFEATURES_MAIN_GUI_OPENER;

    }
}

