/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.listeners;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.api.BoosterType;
import com.andrei1058.vipfeatures.api.MiniGame;
import com.andrei1058.vipfeatures.api.ParticleType;
import com.andrei1058.vipfeatures.api.SpellType;
import com.andrei1058.vipfeatures.api.TrailType;
import com.andrei1058.vipfeatures.configuration.Language;
import com.andrei1058.vipfeatures.customgui.CustomGUI;
import com.andrei1058.vipfeatures.items.ItemCreator;
import com.andrei1058.vipfeatures.perks.BoostersManager;
import com.andrei1058.vipfeatures.perks.ParticleManager;
import com.andrei1058.vipfeatures.perks.SpellsManager;
import com.andrei1058.vipfeatures.perks.TrailsManager;
import com.andrei1058.vipfeatures.tasks.ParticlesTask;
import com.andrei1058.vipfeatures.tasks.TrailsTask;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GeneralListeners
implements Listener {
    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        ItemStack i = VipFeatures.getItemStackSupport().getInHand(e.getPlayer());
        if (i == null) {
            return;
        }
        if (i.getType() == Material.AIR) {
            return;
        }
        for (MiniGame m : VipFeatures.getMiniGames()) {
            if (!m.isPlaying(e.getPlayer())) continue;
            return;
        }
        String tag = VipFeatures.getItemStackSupport().getTag(i, "avf-in");
        if (tag != null && tag.equalsIgnoreCase(ItemCreator.ItemType.VIPFEATURES_MAIN_GUI_OPENER.toString())) {
            if (!e.isCancelled()) {
                e.setCancelled(true);
            }
            Language.getPlayerLanguage(e.getPlayer()).openGUI("mainGUI", e.getPlayer(), "vipfeatures.open.maingui");
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (e.getWhoClicked() == null) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        Language l = Language.getPlayerLanguage(player);
        block22: for (CustomGUI cg : l.getLangGUIs()) {
            if (!l.m(String.valueOf(cg.getName()) + ".name").equalsIgnoreCase(e.getInventory().getTitle())) continue;
            if (!e.isCancelled()) {
                e.setCancelled(true);
            }
            switch (cg.getName()) {
                case "mainGUI": {
                    for (String s : VipFeatures.mainGUI.getYml().getConfigurationSection("mainGUI").getKeys(false)) {
                        if (s.equalsIgnoreCase("invSize") || VipFeatures.mainGUI.getYml().get("mainGUI." + s + ".slot") == null || VipFeatures.mainGUI.getInt("mainGUI." + s + ".slot") != e.getSlot()) continue;
                        Language.getPlayerLanguage(player).openGUI(s, player, "");
                        return;
                    }
                    continue block22;
                }
                case "trailsGUI": {
                    for (String s : VipFeatures.trailsGUI.getYml().getConfigurationSection("trailsGUI").getKeys(false)) {
                        String trailName;
                        TrailType selected;
                        if (VipFeatures.trailsGUI.getYml().get("trailsGUI." + s + ".slot") == null || VipFeatures.trailsGUI.getInt("trailsGUI." + s + ".slot") != e.getSlot()) continue;
                        if (s.equalsIgnoreCase("backItem")) {
                            Language.getPlayerLanguage(player).openGUI("mainGUI", player, "");
                            return;
                        }
                        TrailType current = TrailsManager.getINSTANCE().getPlayerTrails(player);
                        try {
                            selected = TrailType.valueOf(s);
                        }
                        catch (Exception exception) {
                            player.closeInventory();
                            return;
                        }
                        if (current.equals((Object)selected)) {
                            selected = TrailType.NONE;
                            trailName = Language.getMsg(player, "none");
                        } else {
                            trailName = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
                        }
                        TrailType finalSelected = selected;
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)VipFeatures.plugin, () -> VipFeatures.databaseAdapter.setSelectedTrails(player.getUniqueId(), finalSelected));
                        player.sendMessage(Language.getMsg(player, "trailSelected").replace("{name}", trailName));
                        e.getWhoClicked().closeInventory();
                        TrailsManager.getINSTANCE().setPlayerTrails(player, selected);
                        return;
                    }
                    continue block22;
                }
                case "spellsGUI": {
                    for (String s : VipFeatures.spellsGUI.getYml().getConfigurationSection("spellsGUI").getKeys(false)) {
                        String spellName;
                        SpellType selected;
                        if (VipFeatures.spellsGUI.getYml().get("spellsGUI." + s + ".slot") == null || VipFeatures.spellsGUI.getInt("spellsGUI." + s + ".slot") != e.getSlot()) continue;
                        if (s.equalsIgnoreCase("backItem")) {
                            Language.getPlayerLanguage(player).openGUI("mainGUI", player, "");
                            return;
                        }
                        SpellType current = SpellsManager.getINSTANCE().getPlayerSpells(player);
                        try {
                            selected = SpellType.valueOf(s);
                        }
                        catch (Exception exception) {
                            player.closeInventory();
                            return;
                        }
                        if (current.equals((Object)selected)) {
                            selected = SpellType.NONE;
                            spellName = Language.getMsg(player, "none");
                        } else {
                            spellName = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
                        }
                        SpellType finalSelected = selected;
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)VipFeatures.plugin, () -> VipFeatures.databaseAdapter.setSelectedSpells(player.getUniqueId(), finalSelected));
                        player.sendMessage(Language.getMsg(player, "arrowSelected").replace("{name}", spellName));
                        e.getWhoClicked().closeInventory();
                        SpellsManager.getINSTANCE().setPlayerSpells(player, selected);
                        return;
                    }
                    continue block22;
                }
                case "particlesGUI": {
                    for (String s : VipFeatures.particlesGUI.getYml().getConfigurationSection("particlesGUI").getKeys(false)) {
                        String displayName;
                        ParticleType selected;
                        if (VipFeatures.particlesGUI.getYml().get("particlesGUI." + s + ".slot") == null || VipFeatures.particlesGUI.getInt("particlesGUI." + s + ".slot") != e.getSlot()) continue;
                        if (s.equalsIgnoreCase("backItem")) {
                            Language.getPlayerLanguage(player).openGUI("mainGUI", player, "");
                            return;
                        }
                        ParticleType current = ParticleManager.getINSTANCE().getPlayerParticles(player);
                        try {
                            selected = ParticleType.valueOf(s);
                        }
                        catch (Exception exception) {
                            player.closeInventory();
                            return;
                        }
                        if (current.equals((Object)selected)) {
                            selected = ParticleType.NONE;
                            displayName = Language.getMsg(player, "none");
                        } else {
                            displayName = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
                        }
                        ParticleType finalSelected = selected;
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)VipFeatures.plugin, () -> VipFeatures.databaseAdapter.setSelectedParticles(player.getUniqueId(), finalSelected));
                        player.sendMessage(Language.getMsg(player, "particlesSelected").replace("{name}", displayName));
                        e.getWhoClicked().closeInventory();
                        ParticleManager.getINSTANCE().setPlayerParticles(player, selected);
                        return;
                    }
                    continue block22;
                }
                case "boostersGUI": {
                    for (String s : VipFeatures.boostersGUI.getYml().getConfigurationSection("boostersGUI").getKeys(false)) {
                        String displayName;
                        BoosterType selected;
                        if (VipFeatures.boostersGUI.getYml().get("boostersGUI." + s + ".slot") == null || VipFeatures.boostersGUI.getInt("boostersGUI." + s + ".slot") != e.getSlot()) continue;
                        if (s.equalsIgnoreCase("backItem")) {
                            Language.getPlayerLanguage(player).openGUI("mainGUI", player, "");
                            return;
                        }
                        BoosterType current = BoostersManager.getINSTANCE().getPlayerBooster(player);
                        try {
                            selected = BoosterType.valueOf(s);
                        }
                        catch (Exception exception) {
                            player.closeInventory();
                            return;
                        }
                        if (current.equals((Object)selected)) {
                            selected = BoosterType.NONE;
                            displayName = Language.getMsg(player, "none");
                        } else {
                            displayName = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
                        }
                        BoosterType finalSelected = selected;
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)VipFeatures.plugin, () -> VipFeatures.databaseAdapter.setSelectedBooster(player.getUniqueId(), finalSelected));
                        player.sendMessage(Language.getMsg(player, "boosterSelected").replace("{name}", displayName));
                        e.getWhoClicked().closeInventory();
                        BoostersManager.getINSTANCE().setPlayerBooster(player, selected, false);
                        return;
                    }
                    continue block22;
                }
            }
        }
    }

    @EventHandler
    public void onBow(EntityShootBowEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getEntity();
        Arrow arrow = (Arrow)e.getProjectile();
        for (MiniGame m : VipFeatures.getMiniGames()) {
            if (m.isPlaying(player)) continue;
            return;
        }
        if (player.hasPermission("vipfeatures.open.trails") && TrailsManager.getINSTANCE().hasTrails(player)) {
            arrow.setMetadata("trailName", (MetadataValue)new FixedMetadataValue((Plugin)VipFeatures.plugin, (Object)TrailsManager.getINSTANCE().getPlayerTrails(player).getParticle()));
            TrailsTask.getProjectiles().add(arrow);
        }
        if (player.hasPermission("vipfeatures.open.spells") && SpellsManager.getINSTANCE().hasSpells(player)) {
            arrow.setMetadata("spellName", (MetadataValue)new FixedMetadataValue((Plugin)VipFeatures.plugin, (Object)SpellsManager.getINSTANCE().getPlayerSpells(player).toString()));
        }
    }

    @EventHandler
    public void onHit(ProjectileHitEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        if (!(e.getEntity() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)e.getEntity();
        if (arrow.hasMetadata("trailName")) {
            TrailsTask.getProjectiles().remove(arrow);
        }
        if (arrow.hasMetadata("spellName")) {
            SpellType spell;
            if (e.getEntity().getShooter() == null) {
                return;
            }
            if (!(e.getEntity().getShooter() instanceof Player)) {
                return;
            }
            Player player = (Player)e.getEntity().getShooter();
            try {
                spell = SpellType.valueOf(((MetadataValue)arrow.getMetadata("spellName").get(0)).asString());
            }
            catch (Exception exception) {
                return;
            }
            spell.execute(arrow.getLocation(), player);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)VipFeatures.plugin, () -> {
            if (player.hasPermission("vipfeatures.open.trails")) {
                TrailsManager.getINSTANCE().setPlayerTrails(player, VipFeatures.databaseAdapter.getSelectedTrails(player.getUniqueId()));
            }
            if (player.hasPermission("vipfeatures.open.spells")) {
                SpellsManager.getINSTANCE().setPlayerSpells(player, VipFeatures.databaseAdapter.getSelectedSpells(player.getUniqueId()));
            }
            if (player.hasPermission("vipfeatures.open.particles")) {
                ParticleManager.getINSTANCE().setPlayerParticles(player, VipFeatures.databaseAdapter.getSelectedParticles(player.getUniqueId()));
            }
            if (player.hasPermission("vipfeatures.open.boosters")) {
                BoostersManager.getINSTANCE().setPlayerBooster(player, VipFeatures.databaseAdapter.getSelectedBooster(player.getUniqueId()), true);
            }
        });
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        BukkitTask task = ParticleManager.getINSTANCE().getSpiralRunnables().get(player);
        if (task != null) {
            task.cancel();
            ParticleManager.getINSTANCE().getSpiralRunnables().remove(player);
        }
        if (ParticleManager.getINSTANCE().hasParticles(player)) {
            ParticlesTask.getParticlesOnHead().remove(player);
            ParticleManager.getINSTANCE().getPlayerParticles().remove(player);
        }
        if (SpellsManager.getINSTANCE().hasSpells(player)) {
            SpellsManager.getINSTANCE().getSpellByPlayer().remove(player);
        }
        if (BoostersManager.getINSTANCE().hasBooster(player)) {
            BoostersManager.getINSTANCE().getPlayerBoosters().remove(player);
        }
        if (TrailsManager.getINSTANCE().hasTrails(player)) {
            TrailsManager.getINSTANCE().getTrailByPlayer().remove(player);
        }
    }
}

