/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.perks;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.api.BoosterType;
import com.andrei1058.vipfeatures.api.IVipFeatures;
import com.andrei1058.vipfeatures.api.MiniGame;
import com.andrei1058.vipfeatures.configuration.Language;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class BoostersManager
implements IVipFeatures.BoostersUtil {
    private static BoostersManager INSTANCE;
    private final HashMap<Player, BoosterType> playerBooster = new HashMap();

    BoostersManager() {
    }

    public HashMap<Player, BoosterType> getPlayerBoosters() {
        return this.playerBooster;
    }

    public boolean hasBooster(Player p) {
        return this.getPlayerBoosters().containsKey(p);
    }

    public int getMultiplier(Player p) {
        return this.getPlayerBooster(p).getMultiplier();
    }

    public void setPlayerBooster(Player p, BoosterType boosterType, boolean skipPermMsg) {
        if (!p.isOnline()) {
            return;
        }
        if (boosterType == BoosterType.NONE) {
            if (this.hasBooster(p)) {
                this.getPlayerBoosters().remove(p);
            }
            return;
        }
        if (!BoostersManager.hasPermission(p, boosterType)) {
            return;
        }
        for (MiniGame m : VipFeatures.getMiniGames()) {
            if (m.hasBoosters() || skipPermMsg) continue;
            p.sendMessage(Language.getMsg(p, "noBoostersForMinigame").replace("{minigame}", m.getDisplayName()));
        }
        if (this.playerBooster.containsKey(p)) {
            this.playerBooster.remove(p, (Object)boosterType);
        } else {
            this.playerBooster.put(p, boosterType);
        }
    }

    private static boolean hasPermission(Player p, BoosterType boosterType) {
        return p.hasPermission("vipfeatures.*") || p.hasPermission("vipfeatures.boosters.*") || p.hasPermission(boosterType.getPermission());
    }

    @Override
    public BoosterType getPlayerBooster(Player p) {
        if (this.hasBooster(p)) {
            return this.getPlayerBoosters().get(p);
        }
        return BoosterType.NONE;
    }

    @Override
    public void togglePlayerBooster(Player player, BoosterType type) {
        this.setPlayerBooster(player, type, true);
    }

    public static BoostersManager getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new BoostersManager();
        }
        return INSTANCE;
    }
}

