/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.perks;

import com.andrei1058.vipfeatures.VipFeatures;
import com.andrei1058.vipfeatures.api.IVipFeatures;
import com.andrei1058.vipfeatures.api.ParticleType;
import com.andrei1058.vipfeatures.tasks.ParticlesTask;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ParticleManager
implements IVipFeatures.ParticlesUtil {
    private static ParticleManager INSTANCE;
    private final HashMap<Player, ParticleType> playerParticles = new HashMap();
    private final HashMap<Player, BukkitTask> spiralRunnables = new HashMap();

    public HashMap<Player, ParticleType> getPlayerParticles() {
        return this.playerParticles;
    }

    ParticleManager() {
    }

    public boolean hasParticles(Player p) {
        return this.getPlayerParticles().containsKey(p);
    }

    @Override
    public ParticleType getPlayerParticles(Player p) {
        if (this.hasParticles(p)) {
            return this.getPlayerParticles().get(p);
        }
        return ParticleType.NONE;
    }

    @Override
    public void togglePlayerParticles(Player player, ParticleType particleType) {
        this.setPlayerParticles(player, particleType);
    }

    public void setPlayerParticles(Player p, ParticleType particlesType) {
        if (!p.isOnline()) {
            return;
        }
        if (particlesType == ParticleType.NONE) {
            if (this.hasParticles(p)) {
                this.getPlayerParticles().remove(p);
                if (this.getSpiralRunnables().containsKey(p)) {
                    this.getSpiralRunnables().get(p).cancel();
                    this.getSpiralRunnables().remove(p);
                }
                ParticlesTask.getParticlesOnHead().remove(p);
            }
            return;
        }
        if (!ParticleManager.hasPermission(p, particlesType)) {
            return;
        }
        if (this.hasParticles(p)) {
            this.getPlayerParticles().replace(p, particlesType);
        } else {
            this.getPlayerParticles().put(p, particlesType);
        }
        if (particlesType == ParticleType.SPIRAL) {
            ParticlesTask.getParticlesOnHead().remove(p);
            this.spiralEffect(p);
        } else {
            if (this.getSpiralRunnables().containsKey(p)) {
                this.getSpiralRunnables().get(p).cancel();
                this.getSpiralRunnables().remove(p);
            }
            if (ParticlesTask.getParticlesOnHead().containsKey(p)) {
                ParticlesTask.getParticlesOnHead().replace(p, particlesType.getParticle());
            } else {
                ParticlesTask.getParticlesOnHead().put(p, particlesType.getParticle());
            }
        }
    }

    public void spiralEffect(final Player player) {
        if (this.getSpiralRunnables().containsKey(player)) {
            this.getSpiralRunnables().get(player).cancel();
            this.getSpiralRunnables().remove(player);
        }
        this.spiralRunnables.put(player, new BukkitRunnable(){
            double phi = 0.0;

            public void run() {
                this.phi += 0.39269908169872414;
                Location location1 = player.getLocation();
                double t = 0.0;
                while (t <= Math.PI * 2) {
                    double i = 0.0;
                    while (i <= 1.0) {
                        double x = 0.4 * (Math.PI * 2 - t) * 0.5 * Math.cos(t + this.phi + i * Math.PI);
                        double y = 0.5 * t;
                        double z = 0.4 * (Math.PI * 2 - t) * 0.5 * StrictMath.sin(t + this.phi + i * Math.PI);
                        location1.add(x, y, z);
                        VipFeatures.getParticleSupport().spawnRedstoneParticle(location1.getWorld(), (float)location1.getX(), (float)location1.getY(), (float)location1.getZ(), 0, 0, 0, 0, 1);
                        location1.subtract(x, y, z);
                        i += 1.0;
                    }
                    t += 0.19634954084936207;
                }
                if (this.phi > 62.83185307179586) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)VipFeatures.plugin, 0L, 3L));
    }

    public HashMap<Player, BukkitTask> getSpiralRunnables() {
        return this.spiralRunnables;
    }

    private static boolean hasPermission(Player p, ParticleType particlesType) {
        return p.hasPermission("vipfeatures.*") || p.hasPermission("vipfeatures.particles.*") || p.hasPermission(particlesType.getPermission());
    }

    public static ParticleManager getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new ParticleManager();
        }
        return INSTANCE;
    }
}

