/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.perks;

import com.andrei1058.vipfeatures.api.IVipFeatures;
import com.andrei1058.vipfeatures.api.SpellType;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class SpellsManager
implements IVipFeatures.SpellsUtil {
    private static SpellsManager INSTANCE;
    private final HashMap<Player, SpellType> spellByPlayer = new HashMap();

    SpellsManager() {
    }

    public HashMap<Player, SpellType> getSpellByPlayer() {
        return this.spellByPlayer;
    }

    public boolean hasSpells(Player p) {
        return this.getSpellByPlayer().containsKey(p);
    }

    @Override
    public SpellType getPlayerSpells(Player p) {
        if (this.hasSpells(p)) {
            return this.getSpellByPlayer().get(p);
        }
        return SpellType.NONE;
    }

    @Override
    public void togglePlayerSpells(Player player, SpellType type) {
        this.setPlayerSpells(player, type);
    }

    public void setPlayerSpells(Player p, SpellType spellType) {
        if (!p.isOnline()) {
            return;
        }
        if (spellType == SpellType.NONE) {
            if (this.hasSpells(p)) {
                this.getSpellByPlayer().remove(p);
            }
            return;
        }
        if (!SpellsManager.hasPermission(p, spellType)) {
            return;
        }
        if (this.hasSpells(p)) {
            this.getSpellByPlayer().replace(p, spellType);
        } else {
            this.getSpellByPlayer().put(p, spellType);
        }
    }

    private static boolean hasPermission(Player p, SpellType spellType) {
        return p.hasPermission("vipfeatures.*") || p.hasPermission("vipfeatures.spells.*") || p.hasPermission(spellType.getPermission());
    }

    public static SpellsManager getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new SpellsManager();
        }
        return INSTANCE;
    }
}

