/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.vipfeatures.perks;

import com.andrei1058.vipfeatures.api.IVipFeatures;
import com.andrei1058.vipfeatures.api.TrailType;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class TrailsManager
implements IVipFeatures.TrailsUtil {
    private static TrailsManager INSTANCE;
    private final HashMap<Player, TrailType> trailByPlayer = new HashMap();

    TrailsManager() {
    }

    public HashMap<Player, TrailType> getTrailByPlayer() {
        return this.trailByPlayer;
    }

    public boolean hasTrails(Player p) {
        return this.getTrailByPlayer().containsKey(p);
    }

    @Override
    public TrailType getPlayerTrails(Player p) {
        if (this.hasTrails(p)) {
            return this.getTrailByPlayer().get(p);
        }
        return TrailType.NONE;
    }

    @Override
    public void togglePlayerTrails(Player player, TrailType type) {
        this.setPlayerTrails(player, type);
    }

    public void setPlayerTrails(Player p, TrailType trailType) {
        if (!p.isOnline()) {
            return;
        }
        if (trailType == TrailType.NONE) {
            if (this.hasTrails(p)) {
                this.getTrailByPlayer().remove(p);
            }
            return;
        }
        if (!TrailsManager.hasPermission(p, trailType)) {
            return;
        }
        if (this.getTrailByPlayer().containsKey(p)) {
            this.getTrailByPlayer().replace(p, trailType);
        } else {
            this.getTrailByPlayer().put(p, trailType);
        }
    }

    private static boolean hasPermission(Player p, TrailType trailType) {
        return p.hasPermission("vipfeatures.*") || p.hasPermission("vipfeatures.trails.*") || p.hasPermission(trailType.getPermission());
    }

    public static TrailsManager getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new TrailsManager();
        }
        return INSTANCE;
    }
}

