/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.rammelkast.anticheatreloaded.command.CommandHandler;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.event.BlockListener;
import com.rammelkast.anticheatreloaded.event.EntityListener;
import com.rammelkast.anticheatreloaded.event.InventoryListener;
import com.rammelkast.anticheatreloaded.event.PlayerListener;
import com.rammelkast.anticheatreloaded.event.VehicleListener;
import com.rammelkast.anticheatreloaded.manage.AntiCheatManager;
import com.rammelkast.anticheatreloaded.metrics.Metrics;
import com.rammelkast.anticheatreloaded.util.PacketListener;
import com.rammelkast.anticheatreloaded.util.UpdateManager;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AntiCheatReloaded
extends JavaPlugin {
    public static final List<UUID> MUTE_ENABLED_MODS = new ArrayList<UUID>();
    private static AntiCheatManager manager;
    private static AntiCheatReloaded plugin;
    private static List<Listener> eventList;
    private static Configuration config;
    private static boolean verbose;
    private static ProtocolManager protocolManager;
    private static SecureRandom random;
    private static Long loadTime;
    private static UpdateManager updateManager;
    private double tps = -1.0;
    private String symbiosisMetric = "None";
    private int playersKicked = 0;

    public void onEnable() {
        plugin = this;
        random = new SecureRandom();
        loadTime = System.currentTimeMillis();
        manager = new AntiCheatManager(this, this.getLogger());
        eventList.add(new PlayerListener());
        eventList.add(new BlockListener());
        eventList.add(new EntityListener());
        eventList.add(new VehicleListener());
        eventList.add(new InventoryListener());
        this.setupConfig();
        this.setupEvents();
        this.setupCommands();
        this.setupEnterprise();
        this.restoreLevels();
        if (Bukkit.getPluginManager().getPlugin("ProtocolLib") == null) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "ACR " + ChatColor.DARK_GRAY + "> " + ChatColor.RED + "Could not find ProtocolLib. Shutting down!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setupProtocol();
        Bukkit.getConsoleSender().sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "ACR " + ChatColor.DARK_GRAY + "> " + ChatColor.GRAY + "Running Minecraft version " + VersionUtil.getVersion() + " " + (VersionUtil.isSupported() ? ChatColor.GREEN + "(supported)" : ChatColor.RED + "(NOT SUPPORTED!)"));
        this.getLogger().info("Enabling packet listeners");
        PacketListener.listenMovementPackets();
        PacketListener.listenKeepAlivePackets();
        PacketListener.listenUseItemPackets();
        updateManager = new UpdateManager();
        this.verboseLog("Finished loading.");
        this.getServer().getScheduler().runTaskLater((Plugin)this, new Runnable(){

            @Override
            public void run() {
                AntiCheatReloaded.this.checkForSymbiosis();
                try {
                    Metrics metrics = new Metrics((Plugin)AntiCheatReloaded.this, 202);
                    metrics.addCustomChart(new Metrics.SingleLineChart("cheaters_kicked", new Callable<Integer>(){

                        @Override
                        public Integer call() throws Exception {
                            int kicked = AntiCheatReloaded.this.playersKicked;
                            AntiCheatReloaded.this.playersKicked = 0;
                            return kicked;
                        }
                    }));
                    metrics.addCustomChart(new Metrics.SimplePie("protocollib_version", new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return Bukkit.getPluginManager().getPlugin("ProtocolLib").getDescription().getVersion();
                        }
                    }));
                    metrics.addCustomChart(new Metrics.SimplePie("nms_version", new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return VersionUtil.getVersion();
                        }
                    }));
                    metrics.addCustomChart(new Metrics.SimplePie("symbiosis", new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return AntiCheatReloaded.this.symbiosisMetric;
                        }
                    }));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 90L);
        new BukkitRunnable(){
            long sec;
            long currentSec;
            int ticks;

            public void run() {
                this.sec = System.currentTimeMillis() / 1000L;
                if (this.currentSec == this.sec) {
                    ++this.ticks;
                } else {
                    this.currentSec = this.sec;
                    AntiCheatReloaded.this.tps = AntiCheatReloaded.this.tps == 0.0 ? (double)this.ticks : (AntiCheatReloaded.this.tps + (double)this.ticks) / 2.0;
                    this.ticks = 1;
                }
                if (this.ticks % 864000 == 0) {
                    updateManager.update();
                }
            }
        }.runTaskTimer((Plugin)this, 40L, 1L);
    }

    public void onDisable() {
        this.verboseLog("Saving user levels...");
        config.getLevels().saveLevelsFromUsers(AntiCheatReloaded.getManager().getUserManager().getUsers());
        AntiCheatManager.close();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.cleanup();
    }

    private void setupProtocol() {
        protocolManager = ProtocolLibrary.getProtocolManager();
        this.verboseLog("Hooked into ProtocolLib");
    }

    private void setupEvents() {
        for (Listener listener : eventList) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
            this.verboseLog("Registered events for ".concat(listener.toString().split("@")[0].split(".anticheat.")[1]));
        }
    }

    private void setupCommands() {
        this.getCommand("anticheat").setExecutor((CommandExecutor)new CommandHandler());
        this.verboseLog("Registered commands.");
    }

    private void setupConfig() {
        config = manager.getConfiguration();
        this.verboseLog("Setup the config.");
    }

    private void setupEnterprise() {
        if (AntiCheatReloaded.config.getConfig().enterprise.getValue().booleanValue() && AntiCheatReloaded.config.getEnterprise().loggingEnabled.getValue().booleanValue()) {
            AntiCheatReloaded.config.getEnterprise().database.cleanEvents();
        }
    }

    private void restoreLevels() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            UUID uuid = player.getUniqueId();
            User user = new User(uuid);
            user.setIsWaitingOnLevelSync(true);
            config.getLevels().loadLevelToUser(user);
            manager.getUserManager().addUser(user);
            this.verboseLog("Data for " + uuid + " loaded");
        }
    }

    public static AntiCheatReloaded getPlugin() {
        return plugin;
    }

    public static AntiCheatManager getManager() {
        return manager;
    }

    public static SecureRandom getRandom() {
        return random;
    }

    public static String getVersion() {
        return manager.getPlugin().getDescription().getVersion();
    }

    private void cleanup() {
        eventList = null;
        manager = null;
        config = null;
    }

    public static void debugLog(final String string) {
        Bukkit.getScheduler().runTask((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (AntiCheatReloaded.getManager().getConfiguration().getConfig().debugMode.getValue().booleanValue()) {
                    manager.debugLog("[DEBUG] " + string);
                }
            }
        });
    }

    public void verboseLog(String string) {
        if (verbose) {
            this.getLogger().info(string);
        }
    }

    public void setVerbose(boolean b) {
        verbose = b;
    }

    public Long getLoadTime() {
        return loadTime;
    }

    public static ProtocolManager getProtocolManager() {
        return protocolManager;
    }

    public void onPlayerKicked() {
        ++this.playersKicked;
    }

    protected void checkForSymbiosis() {
        if (Bukkit.getPluginManager().getPlugin("NoCheatPlus") != null) {
            this.symbiosisMetric = this.symbiosisMetric.equals("None") ? "NoCheatPlus" : this.symbiosisMetric + ", NoCheatPlus";
        }
        if (Bukkit.getPluginManager().getPlugin("Matrix") != null) {
            this.symbiosisMetric = this.symbiosisMetric.equals("None") ? "Matrix" : this.symbiosisMetric + ", Matrix";
        }
        if (Bukkit.getPluginManager().getPlugin("AAC") != null) {
            this.symbiosisMetric = this.symbiosisMetric.equals("None") ? "AAC" : this.symbiosisMetric + ", AAC";
        }
        if (Bukkit.getPluginManager().getPlugin("Spartan") != null) {
            this.symbiosisMetric = this.symbiosisMetric.equals("None") ? "Spartan" : this.symbiosisMetric + ", Spartan";
        }
        if (Bukkit.getPluginManager().getPlugin("Negativity") != null) {
            this.symbiosisMetric = this.symbiosisMetric.equals("None") ? "Negativity" : this.symbiosisMetric + ", Negativity";
        }
    }

    public static void sendToMainThread(Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)AntiCheatReloaded.getPlugin(), runnable);
    }

    public void sendToStaff(String message) {
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.hasPermission("anticheat.system.alert") && !MUTE_ENABLED_MODS.contains(player.getUniqueId())) {
                player.sendMessage(message);
            }
        });
    }

    public static UpdateManager getUpdateManager() {
        return updateManager;
    }

    public double getTPS() {
        if (this.tps < 0.0 || this.tps > 20.0) {
            return 20.0;
        }
        return this.tps;
    }

    static {
        eventList = new ArrayList<Listener>();
    }
}

