/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.check.combat.KillAuraCheck;
import com.rammelkast.anticheatreloaded.check.combat.VelocityCheck;
import com.rammelkast.anticheatreloaded.check.movement.AimbotCheck;
import com.rammelkast.anticheatreloaded.check.movement.ElytraCheck;
import com.rammelkast.anticheatreloaded.check.movement.FlightCheck;
import com.rammelkast.anticheatreloaded.check.movement.NoSlowCheck;
import com.rammelkast.anticheatreloaded.check.packet.MorePacketsCheck;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.config.providers.Lang;
import com.rammelkast.anticheatreloaded.config.providers.Magic;
import com.rammelkast.anticheatreloaded.manage.AntiCheatManager;
import com.rammelkast.anticheatreloaded.util.Distance;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class Backend {
    public Map<UUID, Long> velocitized = new HashMap<UUID, Long>();
    private Map<UUID, Long> levitatingEnd = new HashMap<UUID, Long>();
    private Map<UUID, Integer> chatLevel = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> commandLevel = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> nofallViolation = new HashMap<UUID, Integer>();
    private Map<UUID, Boolean> blockBreakHolder = new HashMap<UUID, Boolean>();
    private Map<UUID, Integer> fastPlaceViolation = new HashMap<UUID, Integer>();
    private Map<UUID, Long> lastBlockPlaced = new HashMap<UUID, Long>();
    private Map<UUID, Long> lastBlockPlaceTime = new HashMap<UUID, Long>();
    private Map<UUID, Integer> blockPunches = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> projectilesShot = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> velocitytrack = new HashMap<UUID, Integer>();
    private Map<UUID, Long> startEat = new HashMap<UUID, Long>();
    private Map<UUID, Long> lastHeal = new HashMap<UUID, Long>();
    private Map<UUID, Long> projectileTime = new HashMap<UUID, Long>();
    private Map<UUID, Long> bowWindUp = new HashMap<UUID, Long>();
    private Map<UUID, Long> sprinted = new HashMap<UUID, Long>();
    private Map<UUID, Long> brokenBlock = new HashMap<UUID, Long>();
    public Map<UUID, Long> placedBlock = new HashMap<UUID, Long>();
    private Map<UUID, Long> blockTime = new HashMap<UUID, Long>();
    private Map<UUID, Integer> blocksDropped = new HashMap<UUID, Integer>();
    private Map<UUID, Long> lastInventoryTime = new HashMap<UUID, Long>();
    private Map<UUID, Long> inventoryTime = new HashMap<UUID, Long>();
    private Map<UUID, Integer> inventoryClicks = new HashMap<UUID, Integer>();
    private HashSet<Byte> transparent = new HashSet();
    private Map<UUID, Long> lastFallPacket = new HashMap<UUID, Long>();
    private Map<UUID, Integer> fastSneakViolations = new HashMap<UUID, Integer>();
    private Map<UUID, Long> lastSneak = new HashMap<UUID, Long>();
    private Magic magic;
    private Checks checksConfig;
    private AntiCheatManager manager = null;
    private Lang lang = null;
    private static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);

    public Backend(AntiCheatManager instance) {
        this.magic = instance.getConfiguration().getMagic();
        this.checksConfig = instance.getConfiguration().getChecks();
        this.manager = instance;
        this.lang = this.manager.getConfiguration().getLang();
        this.transparent.add((byte)-1);
    }

    public Magic getMagic() {
        return this.magic;
    }

    public void updateConfig(Configuration config) {
        this.magic = config.getMagic();
        this.lang = config.getLang();
    }

    public void resetChatLevel(User user) {
        this.chatLevel.put(user.getUUID(), 0);
    }

    public void garbageClean(Player player) {
        UUID uuid = player.getUniqueId();
        this.blocksDropped.remove(uuid);
        this.blockTime.remove(uuid);
        this.brokenBlock.remove(uuid);
        this.placedBlock.remove(uuid);
        this.bowWindUp.remove(uuid);
        this.startEat.remove(uuid);
        this.lastHeal.remove(uuid);
        this.sprinted.remove(uuid);
        this.nofallViolation.remove(uuid);
        this.blockBreakHolder.remove(uuid);
        this.fastPlaceViolation.remove(uuid);
        this.lastBlockPlaced.remove(uuid);
        this.lastBlockPlaceTime.remove(uuid);
        this.blockPunches.remove(uuid);
        this.projectilesShot.remove(uuid);
        this.velocitized.remove(uuid);
        this.velocitytrack.remove(uuid);
        this.startEat.remove(uuid);
        this.lastHeal.remove(uuid);
        this.projectileTime.remove(uuid);
        this.bowWindUp.remove(uuid);
        this.sprinted.remove(uuid);
        this.brokenBlock.remove(uuid);
        this.placedBlock.remove(uuid);
        this.blockTime.remove(uuid);
        this.blocksDropped.remove(uuid);
        this.lastInventoryTime.remove(uuid);
        this.inventoryTime.remove(uuid);
        this.inventoryClicks.remove(uuid);
        this.lastFallPacket.remove(uuid);
        this.fastSneakViolations.remove(uuid);
        this.lastSneak.remove(uuid);
        this.levitatingEnd.remove(uuid);
        AimbotCheck.LAST_DELTA_YAW.remove(uuid);
        VelocityCheck.VIOLATIONS.remove(uuid);
        MorePacketsCheck.LAST_PACKET_TIME.remove(uuid);
        MorePacketsCheck.PACKET_BALANCE.remove(uuid);
        MorePacketsCheck.EXEMPT_TIMINGS.remove(uuid);
        ElytraCheck.JUMP_Y_VALUE.remove(uuid);
        KillAuraCheck.ANGLE_FLAGS.remove(uuid);
        KillAuraCheck.PACKETORDER_FLAGS.remove(uuid);
        FlightCheck.MOVING_EXEMPT.remove(uuid);
        NoSlowCheck.LAST_RELEASE.remove(uuid);
        NoSlowCheck.VIOLATIONS.remove(uuid);
    }

    public CheckResult checkFastBow(Player player, float force) {
        if (!this.bowWindUp.containsKey(player.getUniqueId())) {
            return PASS;
        }
        int ticks = (int)((System.currentTimeMillis() - this.bowWindUp.get(player.getUniqueId())) * 20L / 1000L + 3L);
        this.bowWindUp.remove(player.getUniqueId());
        float f = (float)ticks / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        f = f > 1.0f ? 1.0f : f;
        double bowError = this.checksConfig.getDouble(CheckType.FAST_BOW, "bowError");
        if ((double)Math.abs(force - f) > bowError) {
            return new CheckResult(CheckResult.Result.FAILED, "fired their bow too fast (actual force=" + force + ", calculated force=" + f + ")");
        }
        return PASS;
    }

    public CheckResult checkProjectile(Player player) {
        this.incrementOld(player, this.projectilesShot, 10);
        int projectilesToWait = this.checksConfig.getInteger(CheckType.FAST_PROJECTILE, "projectilesToWait");
        if (!this.projectileTime.containsKey(player.getUniqueId())) {
            this.projectileTime.put(player.getUniqueId(), System.currentTimeMillis());
            return new CheckResult(CheckResult.Result.PASSED);
        }
        if (this.projectilesShot.get(player.getUniqueId()) == projectilesToWait) {
            long time = System.currentTimeMillis() - this.projectileTime.get(player.getUniqueId());
            int minimumTime = this.checksConfig.getInteger(CheckType.FAST_PROJECTILE, "minimumTime");
            this.projectileTime.remove(player.getUniqueId());
            this.projectilesShot.remove(player.getUniqueId());
            if (time < (long)minimumTime) {
                return new CheckResult(CheckResult.Result.FAILED, "wound up a bow too fast (actual time=" + time + ", min time=" + minimumTime + ")");
            }
        }
        return PASS;
    }

    public CheckResult checkFastDrop(Player player) {
        this.incrementOld(player, this.blocksDropped, 10);
        int dropsToWait = this.checksConfig.getInteger(CheckType.ITEM_SPAM, "dropsToWait");
        if (!this.blockTime.containsKey(player.getUniqueId())) {
            this.blockTime.put(player.getUniqueId(), System.currentTimeMillis());
            return new CheckResult(CheckResult.Result.PASSED);
        }
        if (this.blocksDropped.get(player.getUniqueId()) == dropsToWait) {
            long time = System.currentTimeMillis() - this.blockTime.get(player.getUniqueId());
            int minimumTime = this.checksConfig.getInteger(CheckType.ITEM_SPAM, "minimumTime");
            this.blockTime.remove(player.getUniqueId());
            this.blocksDropped.remove(player.getUniqueId());
            if (time < (long)minimumTime) {
                return new CheckResult(CheckResult.Result.FAILED, "dropped an item too fast (actual time=" + time + ", min time=" + minimumTime + ")");
            }
        }
        return PASS;
    }

    public CheckResult checkSpider(Player player, double y) {
        if (y <= 0.11761 && y >= 0.11759 && !Utilities.isClimbableBlock(player.getLocation().getBlock()) && !Utilities.isClimbableBlock(player.getEyeLocation().getBlock()) && !Utilities.isClimbableBlock(player.getLocation().clone().add(0.0, -0.98, 0.0).getBlock()) && !Utilities.isNearClimbable(player)) {
            return new CheckResult(CheckResult.Result.FAILED, "tried to climb a non-climbable block (" + player.getLocation().getBlock().getType() + ")");
        }
        return PASS;
    }

    public CheckResult checkNoFall(Player player, double y) {
        UUID uuid = player.getUniqueId();
        if (!(player.getGameMode() == GameMode.CREATIVE || player.isInsideVehicle() || player.isSleeping() || this.isMovingExempt(player) || this.justPlaced(player) || Utilities.isNearWater(player) || Utilities.isInWeb(player) || player.getLocation().getBlock().getType().name().endsWith("TRAPDOOR") || VersionUtil.isSlowFalling(player) || Utilities.isNearShulkerBox(player.getLocation().getBlock().getRelative(BlockFace.DOWN).getLocation()) || Utilities.isNearClimbable(player) || Utilities.isNearWater(player.getLocation().clone().subtract(0.0, 1.5, 0.0)))) {
            if (player.getFallDistance() == 0.0f) {
                if (this.nofallViolation.get(uuid) == null) {
                    this.nofallViolation.put(uuid, 1);
                } else {
                    this.nofallViolation.put(uuid, this.nofallViolation.get(player.getUniqueId()) + 1);
                }
                int i = this.nofallViolation.get(uuid);
                int vlBeforeFlag = this.checksConfig.getInteger(CheckType.NOFALL, "vlBeforeFlag");
                if (i >= vlBeforeFlag) {
                    this.nofallViolation.put(player.getUniqueId(), 1);
                    return new CheckResult(CheckResult.Result.FAILED, "tried to avoid fall damage (" + i + " times in a row, max=" + vlBeforeFlag + ")");
                }
                return PASS;
            }
            this.nofallViolation.put(uuid, 0);
            return PASS;
        }
        return PASS;
    }

    public CheckResult checkSneakToggle(Player player) {
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId());
        long lastSneak = this.lastSneak.getOrDefault(player.getUniqueId(), 0L);
        this.lastSneak.put(player.getUniqueId(), System.currentTimeMillis());
        if (System.currentTimeMillis() - lastSneak < (long)this.checksConfig.getInteger(CheckType.SNEAK, "minToggleTime") && AntiCheatReloaded.getPlugin().getTPS() > (double)this.checksConfig.getInteger(CheckType.SNEAK, "minimumTps")) {
            if (user.isLagging() && this.checksConfig.getBoolean(CheckType.SNEAK, "disableForLagging")) {
                return PASS;
            }
            if (!this.silentMode()) {
                player.teleport(user.getGoodLocation(player.getLocation()));
            }
            return new CheckResult(CheckResult.Result.FAILED, "toggled sneak too fast (time=" + (System.currentTimeMillis() - lastSneak) + ")");
        }
        return PASS;
    }

    public CheckResult checkSprintHungry(PlayerToggleSprintEvent event) {
        Player player = event.getPlayer();
        int sprintFoodMin = this.checksConfig.getInteger(CheckType.SPRINT, "sprintFoodMin");
        if (event.isSprinting() && player.getGameMode() != GameMode.CREATIVE && player.getFoodLevel() <= sprintFoodMin) {
            return new CheckResult(CheckResult.Result.FAILED, "sprinted while hungry (food=" + player.getFoodLevel() + ", min=" + sprintFoodMin + ")");
        }
        return PASS;
    }

    public CheckResult checkVClip(Player player, Distance distance) {
        double from = Math.round(distance.fromY());
        double to = Math.round(distance.toY());
        if (player.isInsideVehicle() || from == to || from < to || Math.round(distance.getYDifference()) < 2L) {
            return PASS;
        }
        int i = 0;
        while ((long)i < Math.round(distance.getYDifference()) + 1L) {
            Block block = new Location(player.getWorld(), player.getLocation().getX(), to + (double)i, player.getLocation().getZ()).getBlock();
            if (block.getType() != Material.AIR && block.getType().isSolid()) {
                return new CheckResult(CheckResult.Result.FAILED, "tried to move through a solid block", (int)from + 3);
            }
            ++i;
        }
        return PASS;
    }

    public CheckResult checkFastPlace(Player player) {
        int vlBeforeFlagSurvival = this.checksConfig.getInteger(CheckType.FAST_PLACE, "vlBeforeFlagSurvival");
        int vlBeforeFlagCreative = this.checksConfig.getInteger(CheckType.FAST_PLACE, "vlBeforeFlagCreative");
        int blockPlacementTime = this.checksConfig.getInteger(CheckType.FAST_PLACE, "blockPlacementTime");
        int violations = player.getGameMode() == GameMode.CREATIVE ? vlBeforeFlagCreative : vlBeforeFlagSurvival;
        long time = System.currentTimeMillis();
        UUID uuid = player.getUniqueId();
        if (!this.lastBlockPlaceTime.containsKey(uuid) || !this.fastPlaceViolation.containsKey(uuid)) {
            this.lastBlockPlaceTime.put(uuid, 0L);
            if (!this.fastPlaceViolation.containsKey(uuid)) {
                this.fastPlaceViolation.put(uuid, 0);
            }
        } else if (this.fastPlaceViolation.containsKey(uuid) && this.fastPlaceViolation.get(uuid) > violations) {
            Long math = System.currentTimeMillis() - this.lastBlockPlaced.get(uuid);
            if (this.lastBlockPlaced.get(uuid) > 0L && math < (long)blockPlacementTime) {
                this.lastBlockPlaced.put(uuid, time);
                return new CheckResult(CheckResult.Result.FAILED, "placed blocks too fast " + this.fastPlaceViolation.get(uuid) + " times in a row (max=" + violations + ")");
            }
            if (this.lastBlockPlaced.get(uuid) > 0L && math > (long)blockPlacementTime) {
                this.fastPlaceViolation.put(uuid, 0);
            }
        } else if (this.lastBlockPlaced.containsKey(uuid)) {
            long last = this.lastBlockPlaced.get(uuid);
            long lastTime = this.lastBlockPlaceTime.get(uuid);
            long thisTime = time - last;
            int minimumTime = this.checksConfig.getInteger(CheckType.FAST_PLACE, "minimumTime");
            if (lastTime != 0L && thisTime < (long)minimumTime) {
                this.lastBlockPlaceTime.put(uuid, time - last);
                this.lastBlockPlaced.put(uuid, time);
                this.fastPlaceViolation.put(uuid, this.fastPlaceViolation.get(uuid) + 1);
                return new CheckResult(CheckResult.Result.FAILED, "tried to place a block " + thisTime + " ms after the last one (min=" + minimumTime + " ms)");
            }
            this.lastBlockPlaceTime.put(uuid, time - last);
        }
        this.lastBlockPlaced.put(uuid, time);
        return PASS;
    }

    public void logBowWindUp(Player player) {
        this.bowWindUp.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void logEatingStart(Player player) {
        this.startEat.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public boolean isEating(Player player) {
        return this.startEat.containsKey(player.getUniqueId()) && this.startEat.get(player.getUniqueId()) < (long)this.checksConfig.getInteger(CheckType.FAST_EAT, "eatTimeMin");
    }

    public void logHeal(Player player) {
        this.lastHeal.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public CheckResult checkChatSpam(Player player, String msg) {
        UUID uuid = player.getUniqueId();
        User user = this.manager.getUserManager().getUser(uuid);
        if (user.getLastMessageTime() != -1L) {
            String m;
            for (int i = 0; i < 2 && (m = user.getMessage(i)) != null; ++i) {
                Long l = user.getMessageTime(i);
                int repeatIgnore = this.checksConfig.getInteger(CheckType.CHAT_SPAM, "repeatIgnore");
                if (System.currentTimeMillis() - l > (long)repeatIgnore) {
                    user.clearMessages();
                    break;
                }
                int timeMin = this.checksConfig.getInteger(CheckType.CHAT_SPAM, "timeMin");
                if (this.manager.getConfiguration().getConfig().blockChatSpamRepetition.getValue().booleanValue() && m.equalsIgnoreCase(msg) && i == 1) {
                    this.manager.getLoggingManager().logFineInfo(player.getName() + " spam-repeated \"" + msg + "\"");
                    return new CheckResult(CheckResult.Result.FAILED, this.lang.SPAM_WARNING());
                }
                if (!this.manager.getConfiguration().getConfig().blockChatSpamSpeed.getValue().booleanValue() || System.currentTimeMillis() - user.getLastCommandTime() >= (long)timeMin) continue;
                this.manager.getLoggingManager().logFineInfo(player.getName() + " spammed quickly \"" + msg + "\"");
                return new CheckResult(CheckResult.Result.FAILED, this.lang.SPAM_WARNING());
            }
        }
        user.addMessage(msg);
        return PASS;
    }

    public CheckResult checkChatUnicode(Player player, String msg) {
        UUID uuid = player.getUniqueId();
        User user = this.manager.getUserManager().getUser(uuid);
        for (char ch : msg.toCharArray()) {
            if (Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.BASIC_LATIN || Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.LATIN_EXTENDED_A || Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.GENERAL_PUNCTUATION || Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.CYRILLIC || Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.CYRILLIC_EXTENDED_A) continue;
            return new CheckResult(CheckResult.Result.FAILED, "Unicode chat is not allowed.");
        }
        user.addMessage(msg);
        return PASS;
    }

    public CheckResult checkCommandSpam(Player player, String cmd) {
        UUID uuid = player.getUniqueId();
        User user = this.manager.getUserManager().getUser(uuid);
        if (user.getLastCommandTime() != -1L) {
            String m;
            for (int i = 0; i < 2 && (m = user.getCommand(i)) != null; ++i) {
                Long l = user.getCommandTime(i);
                int repeatIgnore = this.checksConfig.getInteger(CheckType.COMMAND_SPAM, "repeatIgnore");
                if (System.currentTimeMillis() - l > (long)repeatIgnore) {
                    user.clearCommands();
                    break;
                }
                int timeMin = this.checksConfig.getInteger(CheckType.COMMAND_SPAM, "timeMin");
                if (this.manager.getConfiguration().getConfig().blockCommandSpamRepetition.getValue().booleanValue() && m.equalsIgnoreCase(cmd) && i == 1) {
                    return new CheckResult(CheckResult.Result.FAILED, this.lang.SPAM_WARNING());
                }
                if (!this.manager.getConfiguration().getConfig().blockCommandSpamSpeed.getValue().booleanValue() || System.currentTimeMillis() - user.getLastCommandTime() >= (long)timeMin) continue;
                return new CheckResult(CheckResult.Result.FAILED, this.lang.SPAM_WARNING());
            }
        }
        user.addCommand(cmd);
        return PASS;
    }

    public CheckResult checkInventoryClicks(Player player) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return PASS;
        }
        UUID uuid = player.getUniqueId();
        int clicks = 1;
        if (this.inventoryClicks.containsKey(uuid)) {
            clicks = this.inventoryClicks.get(uuid) + 1;
        }
        this.inventoryClicks.put(uuid, clicks);
        int clicksToWait = this.checksConfig.getInteger(CheckType.FAST_INVENTORY, "clicksToWait");
        if (clicks == 1) {
            this.inventoryTime.put(uuid, System.currentTimeMillis());
        } else if (clicks == clicksToWait) {
            int minimumTime = this.checksConfig.getInteger(CheckType.FAST_INVENTORY, "clicksToWait");
            long time = System.currentTimeMillis() - this.inventoryTime.get(uuid);
            this.inventoryClicks.put(uuid, 0);
            if (time < (long)minimumTime) {
                return new CheckResult(CheckResult.Result.FAILED, "clicked inventory slots " + clicks + " times in " + time + " ms (max=" + clicksToWait + " in " + minimumTime + " ms)");
            }
        }
        return PASS;
    }

    public CheckResult checkFastHeal(Player player) {
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId());
        if (this.lastHeal.containsKey(player.getUniqueId())) {
            double tps = AntiCheatReloaded.getPlugin().getTPS();
            if (tps < this.checksConfig.getDouble(CheckType.FAST_HEAL, "minimumTps") || user.isLagging() && this.checksConfig.getBoolean(CheckType.FAST_HEAL, "disableForLagging")) {
                return PASS;
            }
            long minHealTime = this.checksConfig.getInteger(CheckType.FAST_HEAL, "minHealTime");
            long lastHealTime = this.lastHeal.get(player.getUniqueId());
            int ping = user.getPing();
            double pingCompensation = this.checksConfig.getInteger(CheckType.FAST_HEAL, "pingCompensation");
            long allowedHealTime = (long)((double)minHealTime - (double)ping * pingCompensation);
            this.lastHeal.remove(player.getUniqueId());
            if (System.currentTimeMillis() - lastHealTime < allowedHealTime) {
                return new CheckResult(CheckResult.Result.FAILED, "healed too quickly (time=" + (System.currentTimeMillis() - lastHealTime) + " ms, min=" + allowedHealTime + " ms)");
            }
        }
        return PASS;
    }

    public CheckResult checkFastEat(Player player) {
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId());
        if (this.startEat.containsKey(player.getUniqueId())) {
            if (AntiCheatReloaded.getPlugin().getTPS() < 17.5 || user.isLagging()) {
                return PASS;
            }
            long l = this.startEat.get(player.getUniqueId());
            this.startEat.remove(player.getUniqueId());
            int eatTimeMin = this.checksConfig.getInteger(CheckType.FAST_EAT, "eatTimeMin");
            if (System.currentTimeMillis() - l < (long)eatTimeMin) {
                return new CheckResult(CheckResult.Result.FAILED, "ate too quickly (time=" + (System.currentTimeMillis() - l) + " ms, min=" + eatTimeMin + " ms)");
            }
        }
        return PASS;
    }

    public void logSprint(Player player) {
        this.sprinted.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void logBlockBreak(Player player) {
        this.brokenBlock.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public boolean justBroke(Player player) {
        return this.isDoing(player, this.brokenBlock, 0.1);
    }

    public void logVelocity(Player player) {
        this.velocitized.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void logLevitating(Player player, int duration) {
        this.levitatingEnd.put(player.getUniqueId(), System.currentTimeMillis() + (long)duration * 1000L);
    }

    public boolean justVelocity(Player player) {
        return this.velocitized.containsKey(player.getUniqueId()) ? System.currentTimeMillis() - this.velocitized.get(player.getUniqueId()) < (long)this.magic.VELOCITY_TIME() : false;
    }

    public boolean justLevitated(Player player) {
        return this.levitatingEnd.containsKey(player.getUniqueId()) ? System.currentTimeMillis() - this.levitatingEnd.get(player.getUniqueId()) < (long)this.magic.VELOCITY_TIME() : false;
    }

    public boolean extendVelocityTime(final Player player) {
        if (this.velocitytrack.containsKey(player.getUniqueId())) {
            this.velocitytrack.put(player.getUniqueId(), this.velocitytrack.get(player.getUniqueId()) + 1);
            if (this.velocitytrack.get(player.getUniqueId()) > this.magic.VELOCITY_MAXTIMES()) {
                this.velocitized.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.magic.VELOCITY_PREVENT());
                this.manager.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.manager.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        Backend.this.velocitytrack.put(player.getUniqueId(), 0);
                    }
                }, (long)this.magic.VELOCITY_EXTENSION() * 20L);
                return true;
            }
        } else {
            this.velocitytrack.put(player.getUniqueId(), 0);
        }
        return false;
    }

    public void logBlockPlace(Player player) {
        this.placedBlock.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public boolean justPlaced(Player player) {
        return this.isDoing(player, this.placedBlock, 0.1);
    }

    public void logDamage(Player player, int type) {
        long time;
        switch (type) {
            case 1: {
                time = this.magic.DAMAGE_TIME();
                break;
            }
            case 2: {
                time = this.magic.KNOCKBACK_DAMAGE_TIME();
                break;
            }
            case 3: {
                time = this.magic.EXPLOSION_DAMAGE_TIME();
                break;
            }
            default: {
                time = this.magic.DAMAGE_TIME();
            }
        }
        FlightCheck.MOVING_EXEMPT.put(player.getUniqueId(), System.currentTimeMillis() + time);
    }

    public void logEnterExit(Player player) {
        FlightCheck.MOVING_EXEMPT.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.magic.ENTERED_EXITED_TIME());
    }

    public void logTeleport(Player player) {
        this.manager.getUserManager().getUser((UUID)player.getUniqueId()).getMovementManager().lastTeleport = System.currentTimeMillis();
        this.nofallViolation.remove(player.getUniqueId());
        ElytraCheck.JUMP_Y_VALUE.remove(player.getUniqueId());
    }

    public void logBoatCollision(Player player) {
        FlightCheck.MOVING_EXEMPT.put(player.getUniqueId(), System.currentTimeMillis() + 100L);
    }

    public void logJoin(Player player) {
        FlightCheck.MOVING_EXEMPT.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.magic.JOIN_TIME());
        MorePacketsCheck.EXEMPT_TIMINGS.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.magic.JOIN_TIME());
    }

    public boolean isMovingExempt(Player player) {
        return this.isDoing(player, FlightCheck.MOVING_EXEMPT, -1.0);
    }

    public boolean isDoing(Player player, Map<UUID, Long> map, double max) {
        if (map.containsKey(player.getUniqueId())) {
            if (max != -1.0) {
                if ((double)((System.currentTimeMillis() - map.get(player.getUniqueId())) / 1000L) > max) {
                    map.remove(player.getUniqueId());
                    return false;
                }
                return true;
            }
            if (map.get(player.getUniqueId()) < System.currentTimeMillis()) {
                map.remove(player.getUniqueId());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasJumpPotion(Player player) {
        return player.hasPotionEffect(PotionEffectType.JUMP);
    }

    public boolean hasSpeedPotion(Player player) {
        return player.hasPotionEffect(PotionEffectType.SPEED);
    }

    public void processChatSpammer(Player player) {
        User user = this.manager.getUserManager().getUser(player.getUniqueId());
        int level = this.chatLevel.containsKey(user.getUUID()) ? this.chatLevel.get(user.getUUID()) : 0;
        int levelActionOne = this.checksConfig.getInteger(CheckType.CHAT_SPAM, "levelActionOne");
        int levelActionTwo = this.checksConfig.getInteger(CheckType.CHAT_SPAM, "levelActionTwo");
        if (player != null && player.isOnline() && level >= levelActionOne) {
            String event = level >= levelActionTwo ? this.manager.getConfiguration().getConfig().chatSpamActionTwo.getValue() : this.manager.getConfiguration().getConfig().chatSpamActionOne.getValue();
            this.manager.getUserManager().execute(this.manager.getUserManager().getUser(player.getUniqueId()), Utilities.stringToList(event), CheckType.CHAT_SPAM, this.lang.SPAM_KICK_REASON(), Utilities.stringToList(this.lang.SPAM_WARNING()), this.lang.SPAM_BAN_REASON());
        }
        this.chatLevel.put(user.getUUID(), level + 1);
    }

    public void processCommandSpammer(Player player) {
        User user = this.manager.getUserManager().getUser(player.getUniqueId());
        int level = this.commandLevel.containsKey(user.getUUID()) ? this.commandLevel.get(user.getUUID()) : 0;
        int levelActionOne = this.checksConfig.getInteger(CheckType.COMMAND_SPAM, "levelActionOne");
        int levelActionTwo = this.checksConfig.getInteger(CheckType.COMMAND_SPAM, "levelActionTwo");
        if (player != null && player.isOnline() && level >= levelActionOne) {
            String event = level >= levelActionTwo ? this.manager.getConfiguration().getConfig().commandSpamActionTwo.getValue() : this.manager.getConfiguration().getConfig().commandSpamActionOne.getValue();
            this.manager.getUserManager().execute(this.manager.getUserManager().getUser(player.getUniqueId()), Utilities.stringToList(event), CheckType.COMMAND_SPAM, this.lang.SPAM_KICK_REASON(), Utilities.stringToList(this.lang.SPAM_WARNING()), this.lang.SPAM_BAN_REASON());
        }
        this.commandLevel.put(user.getUUID(), level + 1);
    }

    public int increment(Player player, Map<UUID, Integer> map, int num) {
        UUID name = player.getUniqueId();
        if (map.get(name) == null) {
            map.put(name, 1);
            return 1;
        }
        int amount = map.get(name) + 1;
        if (amount < num + 1) {
            map.put(name, amount);
            return amount;
        }
        map.put(name, num);
        return num;
    }

    public int incrementOld(Player player, Map<UUID, Integer> map, int num) {
        UUID uuid = player.getUniqueId();
        if (map.get(uuid) == null) {
            map.put(uuid, 1);
            return 1;
        }
        int amount = map.get(uuid) + 1;
        if (amount < num + 1) {
            map.put(uuid, amount);
            return amount;
        }
        map.put(uuid, num);
        return num;
    }

    public boolean silentMode() {
        return this.manager.getConfiguration().getConfig().silentMode.getValue();
    }
}

