/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.combat;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.util.MovementManager;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Vector;

public class KillAuraCheck {
    public static final Map<UUID, Integer> ANGLE_FLAGS = new HashMap<UUID, Integer>();
    public static final Map<UUID, Integer> PACKETORDER_FLAGS = new HashMap<UUID, Integer>();
    private static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);

    public static CheckResult checkReach(Player player, Entity target) {
        double allowedReach;
        if (!(target instanceof LivingEntity)) {
            return PASS;
        }
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId());
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        if (!checksConfig.isSubcheckEnabled(CheckType.KILLAURA, "reach")) {
            return PASS;
        }
        double d = allowedReach = target.getVelocity().length() < 0.08 ? checksConfig.getDouble(CheckType.KILLAURA, "reach", "baseMaxValue.normal") : checksConfig.getDouble(CheckType.KILLAURA, "reach", "baseMaxValue.velocitized");
        if (player.getGameMode() == GameMode.CREATIVE) {
            allowedReach += 1.5;
        }
        double lagExtraReach = checksConfig.getDouble(CheckType.KILLAURA, "reach", "lagCompensation.lagExtraReach");
        double pingCompensation = checksConfig.getDouble(CheckType.KILLAURA, "reach", "lagCompensation.pingCompensation");
        allowedReach += (double)user.getPing() * pingCompensation;
        if (user.isLagging()) {
            allowedReach += lagExtraReach;
        }
        if (target instanceof Player) {
            User targetUser = AntiCheatReloaded.getManager().getUserManager().getUser(target.getUniqueId());
            allowedReach += (double)targetUser.getPing() * pingCompensation;
            if (targetUser.isLagging()) {
                allowedReach += lagExtraReach;
            }
        }
        double velocityMultiplier = checksConfig.getDouble(CheckType.KILLAURA, "reach", "velocityMultiplier");
        allowedReach += Math.abs(target.getVelocity().length()) * velocityMultiplier;
        double reachedDistance = ((LivingEntity)target).getLocation().toVector().distance(player.getLocation().toVector());
        if (reachedDistance > allowedReach) {
            return new CheckResult(CheckResult.Result.FAILED, "Reach", "reached too far (distance=" + Utilities.roundDouble(reachedDistance, 6) + ", max=" + Utilities.roundDouble(allowedReach, 6) + ")");
        }
        return PASS;
    }

    public static CheckResult checkAngle(Player player, EntityDamageEvent event) {
        UUID uuid = player.getUniqueId();
        Entity entity = event.getEntity();
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        if (!checksConfig.isSubcheckEnabled(CheckType.KILLAURA, "angle")) {
            return PASS;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Location eyeLocation = player.getEyeLocation();
            double yawDifference = KillAuraCheck.calculateYawDifference(eyeLocation, living.getLocation());
            double playerYaw = player.getEyeLocation().getYaw();
            double angleDifference = Math.abs(180.0 - Math.abs(Math.abs(yawDifference - playerYaw) - 180.0));
            int maxDifference = checksConfig.getInteger(CheckType.KILLAURA, "angle", "maxDifference");
            if (Math.round(angleDifference) > (long)maxDifference) {
                int vlBeforeFlag;
                if (!ANGLE_FLAGS.containsKey(uuid)) {
                    ANGLE_FLAGS.put(uuid, 1);
                    return PASS;
                }
                int flags = ANGLE_FLAGS.get(uuid);
                if (flags >= (vlBeforeFlag = checksConfig.getInteger(CheckType.KILLAURA, "angle", "vlBeforeFlag"))) {
                    ANGLE_FLAGS.remove(uuid);
                    return new CheckResult(CheckResult.Result.FAILED, "Angle", "tried to attack from an illegal angle (angle=" + Math.round(angleDifference) + ")");
                }
                ANGLE_FLAGS.put(uuid, flags + 1);
            }
        }
        return PASS;
    }

    public static CheckResult checkPacketOrder(Player player, Entity entity) {
        UUID uuid = player.getUniqueId();
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(uuid);
        MovementManager movementManager = user.getMovementManager();
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        if (!checksConfig.isSubcheckEnabled(CheckType.KILLAURA, "packetOrder")) {
            return PASS;
        }
        if (user.isLagging() || System.currentTimeMillis() - movementManager.lastTeleport <= 100L || AntiCheatReloaded.getPlugin().getTPS() < checksConfig.getDouble(CheckType.KILLAURA, "packetOrder", "minimumTps")) {
            return PASS;
        }
        long elapsed = System.currentTimeMillis() - movementManager.lastUpdate;
        if (elapsed < (long)checksConfig.getInteger(CheckType.KILLAURA, "packetOrder", "minElapsedTime")) {
            int vlBeforeFlag;
            if (!PACKETORDER_FLAGS.containsKey(uuid)) {
                PACKETORDER_FLAGS.put(uuid, 1);
                return PASS;
            }
            int flags = PACKETORDER_FLAGS.get(uuid);
            if (flags >= (vlBeforeFlag = checksConfig.getInteger(CheckType.KILLAURA, "packetOrder", "vlBeforeFlag"))) {
                PACKETORDER_FLAGS.remove(uuid);
                return new CheckResult(CheckResult.Result.FAILED, "PacketOrder", "suspicious packet order (elapsed=" + elapsed + ")");
            }
            PACKETORDER_FLAGS.put(uuid, flags + 1);
        }
        return PASS;
    }

    public static double calculateYawDifference(Location from, Location to) {
        Location clonedFrom = from.clone();
        Vector startVector = clonedFrom.toVector();
        Vector targetVector = to.toVector();
        clonedFrom.setDirection(targetVector.subtract(startVector));
        return clonedFrom.getYaw();
    }
}

