/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.combat;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.util.Distance;
import com.rammelkast.anticheatreloaded.util.MovementManager;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class VelocityCheck {
    public static final Map<UUID, Integer> VIOLATIONS = new HashMap<UUID, Integer>();
    private static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);

    public static CheckResult runCheck(Player player, Distance distance) {
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId());
        MovementManager movementManager = user.getMovementManager();
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        int minimumPercentage = checksConfig.getInteger(CheckType.VELOCITY, "minimumPercentage");
        int vlBeforeFlag = checksConfig.getInteger(CheckType.VELOCITY, "vlBeforeFlag");
        if (movementManager.velocityExpectedMotionY > 0.0 && !movementManager.onGround) {
            double percentage = movementManager.motionY / movementManager.velocityExpectedMotionY * 100.0;
            if (percentage < 0.0) {
                percentage = 0.0;
            }
            movementManager.velocityExpectedMotionY = 0.0;
            if (percentage < (double)minimumPercentage) {
                int vl = VIOLATIONS.getOrDefault(player.getUniqueId(), 0) + 1;
                VIOLATIONS.put(player.getUniqueId(), vl);
                if (vl >= vlBeforeFlag) {
                    return new CheckResult(CheckResult.Result.FAILED, "ignored server velocity (pct=" + Utilities.roundDouble(percentage, 2) + ")");
                }
            } else {
                VIOLATIONS.remove(player.getUniqueId());
            }
        } else if (movementManager.airTicks > 5 && movementManager.velocityExpectedMotionY > 0.0) {
            movementManager.velocityExpectedMotionY = 0.0;
        }
        return PASS;
    }
}

