/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.movement;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.util.Utilities;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class FastLadderCheck {
    public static final Map<UUID, Integer> VIOLATIONS = new HashMap<UUID, Integer>();
    private static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);

    public static CheckResult runCheck(Player player, double y) {
        if (!Utilities.isClimbableBlock(player.getLocation().getBlock()) || !Utilities.isClimbableBlock(player.getEyeLocation().getBlock()) || player.getLocation().getBlock().isLiquid() || VersionUtil.isFlying(player)) {
            return PASS;
        }
        int vlCount = VIOLATIONS.getOrDefault(player.getUniqueId(), 0);
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        int vlBeforeFlag = checksConfig.getInteger(CheckType.FASTLADDER, "vlBeforeFlag");
        if (y > 0.0) {
            double max = checksConfig.getDouble(CheckType.FASTLADDER, "speedUpMax");
            if (y - max > 0.0) {
                if (vlCount++ > vlBeforeFlag) {
                    vlCount = 0;
                    return new CheckResult(CheckResult.Result.FAILED, "tried to climb up too fast (speed=" + y + ", max=" + max + ")");
                }
            } else if (vlCount > 0) {
                --vlCount;
            }
        } else if (y < 0.0) {
            double max = checksConfig.getDouble(CheckType.FASTLADDER, "speedDownMax");
            if (Math.abs(y) > max + 6.0E-9) {
                if (vlCount++ > vlBeforeFlag) {
                    vlCount = 0;
                    return new CheckResult(CheckResult.Result.FAILED, "tried to climb down too fast (speed=" + Math.abs(y) + ", max=" + max + ")");
                }
            } else if (vlCount > 0) {
                --vlCount;
            }
        } else if (vlCount > 0) {
            --vlCount;
        }
        VIOLATIONS.put(player.getUniqueId(), vlCount);
        return PASS;
    }
}

