/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.movement;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.Backend;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.util.Distance;
import com.rammelkast.anticheatreloaded.util.MovementManager;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class FlightCheck {
    public static final Map<UUID, Long> MOVING_EXEMPT = new HashMap<UUID, Long>();
    public static final Map<UUID, Float> GRAVITY_VIOLATIONS = new HashMap<UUID, Float>();
    private static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);
    private static final double GRAVITY_FRICTION = (double)0.98f;

    public static CheckResult runCheck(Player player, Distance distance) {
        if (distance.getYDifference() >= (double)AntiCheatReloaded.getManager().getBackend().getMagic().TELEPORT_MIN() || VersionUtil.isFlying(player) || player.getVehicle() != null || AntiCheatReloaded.getManager().getBackend().isMovingExempt(player)) {
            return PASS;
        }
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId());
        MovementManager movementManager = user.getMovementManager();
        Backend backend = AntiCheatReloaded.getManager().getBackend();
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        if (movementManager.nearLiquidTicks > 0 || movementManager.halfMovement || Utilities.isNearClimbable(player) || movementManager.riptideTicks > 0) {
            return PASS;
        }
        int minAirTicks = 13;
        if (player.hasPotionEffect(PotionEffectType.JUMP)) {
            minAirTicks += VersionUtil.getPotionLevel(player, PotionEffectType.JUMP) * 3;
        }
        if (movementManager.halfMovementHistoryCounter > 25) {
            minAirTicks += 5;
        }
        if (checksConfig.isSubcheckEnabled(CheckType.FLIGHT, "airFlight") && movementManager.airTicks > minAirTicks && !backend.justVelocity(player) && movementManager.elytraEffectTicks <= 25) {
            double maxMotionY;
            int blockPlaceAccountingTime = (int)((double)checksConfig.getInteger(CheckType.FLIGHT, "airFlight", "accountForBlockPlacement") + 0.25 * (double)(user.getPing() > 1000 ? 1000 : user.getPing()));
            if (AntiCheatReloaded.getPlugin().getTPS() < 18.0) {
                blockPlaceAccountingTime += checksConfig.getInteger(CheckType.FLIGHT, "airFlight", "accountForTpsDrops");
            }
            long lastPlacedBlock = AntiCheatReloaded.getManager().getBackend().placedBlock.containsKey(player.getUniqueId()) ? AntiCheatReloaded.getManager().getBackend().placedBlock.get(player.getUniqueId()) : (long)(blockPlaceAccountingTime + 1);
            double d = maxMotionY = System.currentTimeMillis() - lastPlacedBlock > (long)blockPlaceAccountingTime ? 0.0 : 0.42;
            if (movementManager.motionY < 0.004 && Utilities.isNearHalfblock(distance.getFrom().getBlock().getRelative(BlockFace.DOWN).getLocation())) {
                maxMotionY += 0.004;
            }
            if (Utilities.isNearWater(player) || Utilities.isNearWater(distance.getFrom().clone().subtract(0.0, 0.51, 0.0))) {
                maxMotionY += 0.05;
            }
            if (movementManager.motionY > maxMotionY && movementManager.slimeInfluenceTicks <= 0 && !Utilities.isNearClimbable(distance.getTo().clone().subtract(0.0, 1.25, 0.0)) && !Utilities.isNearClimbable(distance.getTo().clone().subtract(0.0, 0.75, 0.0)) && !Utilities.isNearWater(distance.getTo().clone().subtract(0.0, 1.5, 0.0)) && distance.getTo().clone().subtract(0.0, 0.5, 0.0).getBlock().getType() != Material.AIR) {
                return new CheckResult(CheckResult.Result.FAILED, "AirFlight", "tried to fly on the Y-axis (mY=" + movementManager.motionY + ", max=" + maxMotionY + ")");
            }
            double d2 = Math.abs(movementManager.motionY - movementManager.lastMotionY);
            double d3 = movementManager.airTicks >= 115 ? 0.001 : 0.005;
            if (!(!(d2 < d3) || Utilities.couldBeOnBoat(player) || System.currentTimeMillis() - movementManager.lastTeleport < (long)checksConfig.getInteger(CheckType.FLIGHT, "airFlight", "accountForTeleports") || VersionUtil.isSlowFalling(player) || Utilities.isNearWeb(player) || movementManager.elytraEffectTicks > 25 || Utilities.isNearClimbable(distance.getFrom().clone().subtract(0.0, 0.51, 0.0)) || Utilities.isNearWater(player) || Utilities.isNearWater(distance.getFrom().clone().subtract(0.0, 0.51, 0.0)))) {
                return new CheckResult(CheckResult.Result.FAILED, "AirFlight", "had too little Y dropoff (diff=" + Math.abs(movementManager.motionY - movementManager.lastMotionY) + ")");
            }
        }
        if (checksConfig.isSubcheckEnabled(CheckType.FLIGHT, "airClimb") && movementManager.lastMotionY > 0.0 && movementManager.motionY > 0.0 && movementManager.airTicks == 2 && Math.round(movementManager.lastMotionY * 1000.0) != 420L && Math.round(movementManager.motionY * 1000.0) != 248L && (Math.round(movementManager.motionY * 1000.0) != 333L || Math.round(movementManager.lastMotionY * 1000.0) == 333L) && !AntiCheatReloaded.getManager().getBackend().justVelocity(player) && !player.hasPotionEffect(PotionEffectType.JUMP) && System.currentTimeMillis() - movementManager.lastTeleport >= (long)checksConfig.getInteger(CheckType.FLIGHT, "airClimb", "accountForTeleports") && (!Utilities.isNearBed(distance.getTo()) || (Utilities.isNearBed(distance.getTo()) || Utilities.isNearBed(distance.getTo().clone().add(0.0, -0.51, 0.0))) && movementManager.motionY > 0.15) && movementManager.slimeInfluenceTicks == 0 && movementManager.elytraEffectTicks <= 25 && !Utilities.couldBeOnBoat(player, 0.8, false)) {
            return new CheckResult(CheckResult.Result.FAILED, "AirClimb", "tried to climb air (mY=" + movementManager.motionY + ")");
        }
        if (checksConfig.isSubcheckEnabled(CheckType.FLIGHT, "airClimb") && movementManager.motionY > 0.42 && movementManager.airTicks > 2 && !AntiCheatReloaded.getManager().getBackend().justVelocity(player) && !player.hasPotionEffect(PotionEffectType.JUMP) && (Math.round(movementManager.motionY * 1000.0) != 425L || movementManager.airTicks != 11) && System.currentTimeMillis() - movementManager.lastTeleport >= (long)checksConfig.getInteger(CheckType.FLIGHT, "airClimb", "accountForTeleports") && movementManager.slimeInfluenceTicks == 0 && movementManager.elytraEffectTicks <= 25) {
            return new CheckResult(CheckResult.Result.FAILED, "AirClimb", "tried to climb air (mY=" + movementManager.motionY + ", at=" + movementManager.airTicks + ")");
        }
        if (checksConfig.isSubcheckEnabled(CheckType.FLIGHT, "airClimb") && movementManager.airTicks >= minAirTicks && movementManager.lastMotionY < 0.0 && movementManager.motionY > 0.0 && !AntiCheatReloaded.getManager().getBackend().justVelocity(player) && movementManager.elytraEffectTicks <= 25 && System.currentTimeMillis() - movementManager.lastTeleport >= (long)checksConfig.getInteger(CheckType.FLIGHT, "airClimb", "accountForTeleports") && Math.round(movementManager.motionY * 1000.0) != 396L && movementManager.airTicks == 15) {
            return new CheckResult(CheckResult.Result.FAILED, "AirClimb", "tried to climb air (mY=" + movementManager.motionY + ", at=" + movementManager.airTicks + ")");
        }
        if (checksConfig.isSubcheckEnabled(CheckType.FLIGHT, "groundFlight") && movementManager.onGround && Utilities.cantStandAt(distance.getTo().getBlock().getRelative(BlockFace.DOWN)) && Utilities.cantStandAt(distance.getFrom().getBlock().getRelative(BlockFace.DOWN)) && Utilities.cantStandAt(distance.getTo().getBlock())) {
            return new CheckResult(CheckResult.Result.FAILED, "GroundFlight", "faked ground to fly (mY=" + movementManager.motionY + ", gt=" + movementManager.groundTicks + ")");
        }
        if (checksConfig.isSubcheckEnabled(CheckType.FLIGHT, "gravity") && !movementManager.onGround && movementManager.motionY < 0.0 && !backend.justVelocity(player) && System.currentTimeMillis() - movementManager.lastTeleport >= (long)checksConfig.getInteger(CheckType.FLIGHT, "gravity", "accountForTeleports") && !Utilities.isNearWeb(player) && movementManager.elytraEffectTicks <= 25 && !VersionUtil.isSlowFalling(player)) {
            double gravitatedY = (movementManager.lastMotionY - 0.08) * (double)0.98f;
            double offset = Math.abs(gravitatedY - movementManager.motionY);
            double maxOffset = checksConfig.getDouble(CheckType.FLIGHT, "gravity", "maxOffset");
            if (Utilities.isNearClimbable(distance.getFrom().clone().subtract(0.0, 0.51, 0.0)) || Utilities.isNearClimbable(distance.getFrom()) || Utilities.isNearWater(player) || !Utilities.isNearWater(distance.getTo().clone().subtract(0.0, 1.5, 0.0)) && distance.getTo().clone().subtract(0.0, 0.5, 0.0).getBlock().getType() != Material.AIR) {
                maxOffset += 0.15;
            }
            if (offset > maxOffset && movementManager.airTicks > 2) {
                float vl = GRAVITY_VIOLATIONS.getOrDefault(player.getUniqueId(), Float.valueOf(0.0f)).floatValue() + 1.0f;
                GRAVITY_VIOLATIONS.put(player.getUniqueId(), Float.valueOf(vl));
                int vlBeforeFlag = checksConfig.getInteger(CheckType.FLIGHT, "gravity", "vlBeforeFlag");
                if (vl >= (float)vlBeforeFlag) {
                    GRAVITY_VIOLATIONS.put(player.getUniqueId(), Float.valueOf(Math.max(0.0f, vl - 2.0f)));
                    return new CheckResult(CheckResult.Result.FAILED, "Gravity", "ignored gravity (offset=" + offset + ", at=" + movementManager.airTicks + ")");
                }
            } else if (GRAVITY_VIOLATIONS.containsKey(player.getUniqueId())) {
                float vl = GRAVITY_VIOLATIONS.getOrDefault(player.getUniqueId(), Float.valueOf(0.0f)).floatValue();
                GRAVITY_VIOLATIONS.put(player.getUniqueId(), Float.valueOf(Math.max(0.0f, vl - 0.5f)));
            }
        }
        return PASS;
    }
}

