/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.movement;

import com.comphenix.protocol.events.PacketEvent;
import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.event.EventListener;
import com.rammelkast.anticheatreloaded.util.MovementManager;
import com.rammelkast.anticheatreloaded.util.User;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class NoSlowCheck {
    public static final Map<UUID, Long> LAST_RELEASE = new HashMap<UUID, Long>();
    public static final Map<UUID, Integer> VIOLATIONS = new HashMap<UUID, Integer>();

    public static void runCheck(Player player, PacketEvent event) {
        if (!AntiCheatReloaded.getManager().getCheckManager().willCheck(player, CheckType.NOSLOW)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(uuid);
        MovementManager movementManager = user.getMovementManager();
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        long time = System.currentTimeMillis();
        long lastRelease = LAST_RELEASE.getOrDefault(uuid, 0L);
        LAST_RELEASE.put(uuid, time);
        if (lastRelease == 0L) {
            return;
        }
        long difference = time - lastRelease;
        long minimumDifference = checksConfig.getInteger(CheckType.NOSLOW, "minimumDifference");
        if (difference < minimumDifference && movementManager.distanceXZ >= checksConfig.getDouble(CheckType.NOSLOW, "minimumDistXZ")) {
            int violations = VIOLATIONS.getOrDefault(uuid, 1);
            if (violations++ >= checksConfig.getInteger(CheckType.NOSLOW, "vlBeforeFlag")) {
                violations = 0;
                NoSlowCheck.flag(player, event, "toggled use item too fast (diff=" + difference + ", min=" + minimumDifference + ")");
            }
            VIOLATIONS.put(uuid, violations);
        }
    }

    private static void flag(final Player player, PacketEvent event, final String message) {
        event.setCancelled(true);
        AntiCheatReloaded.sendToMainThread(new Runnable(){

            @Override
            public void run() {
                EventListener.log(new CheckResult(CheckResult.Result.FAILED, message).getMessage(), player, CheckType.NOSLOW, null);
                player.teleport(player.getLocation());
            }
        });
    }
}

