/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.movement;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.Backend;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.util.Distance;
import com.rammelkast.anticheatreloaded.util.MovementManager;
import com.rammelkast.anticheatreloaded.util.Utilities;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class SpeedCheck {
    private static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);

    public static boolean isSpeedExempt(Player player, Backend backend) {
        return backend.isMovingExempt(player) || backend.justVelocity(player) || VersionUtil.isFlying(player);
    }

    public static CheckResult checkXZSpeed(Player player, double x, double z, Location movingTowards) {
        double minimumDistXZ;
        double limit;
        boolean boxedIn;
        Backend backend = AntiCheatReloaded.getManager().getBackend();
        if (SpeedCheck.isSpeedExempt(player, backend) || player.getVehicle() != null || Utilities.isInWater(player)) {
            return PASS;
        }
        MovementManager movementManager = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId()).getMovementManager();
        if (movementManager.riptideTicks > 0) {
            return PASS;
        }
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        double distanceXZ = movementManager.distanceXZ;
        boolean bl = boxedIn = movementManager.topSolid && movementManager.bottomSolid;
        if (checksConfig.isSubcheckEnabled(CheckType.SPEED, "airSpeed") && movementManager.airTicks > 1 && movementManager.elytraEffectTicks <= 0 && !Utilities.isNearClimbable(player)) {
            double deltaMotionY;
            double multiplier = 0.985;
            double predict = 0.36 * Math.pow(multiplier, movementManager.airTicks + 1);
            if (movementManager.airTicks >= 115) {
                predict = Math.max(0.08, predict);
            }
            double limit2 = checksConfig.getDouble(CheckType.SPEED, "airSpeed", "baseLimit");
            if (movementManager.iceInfluenceTicks > 0) {
                double iceIncrement = 0.025 * Math.pow(1.038, movementManager.iceInfluenceTicks);
                if (iceIncrement > 0.18) {
                    iceIncrement = 0.18;
                }
                if (boxedIn) {
                    iceIncrement += 0.45;
                }
                if (!Utilities.couldBeOnIce(movingTowards)) {
                    iceIncrement *= 2.5;
                }
                predict += iceIncrement;
            }
            if (boxedIn && movementManager.airTicks < 3) {
                predict *= 1.2;
            }
            if (movementManager.slimeInfluenceTicks > 0) {
                double slimeIncrement = 0.022 * Math.pow(1.0375, movementManager.slimeInfluenceTicks);
                if (slimeIncrement > 0.12) {
                    slimeIncrement = 0.12;
                }
                predict += slimeIncrement;
            }
            if (movementManager.hasSpeedEffect) {
                predict += (double)VersionUtil.getPotionLevel(player, PotionEffectType.SPEED) * 0.05;
            }
            if (movementManager.hadSpeedEffect && !movementManager.hasSpeedEffect) {
                limit2 *= 1.2;
            }
            if (player.hasPotionEffect(PotionEffectType.JUMP)) {
                predict += (double)VersionUtil.getPotionLevel(player, PotionEffectType.JUMP) * 0.05;
            }
            double walkSpeedMultiplier = checksConfig.getDouble(CheckType.SPEED, "airSpeed", "walkSpeedMultiplier");
            predict += walkSpeedMultiplier * (Math.pow(1.1, (double)player.getWalkSpeed() / 0.2 - 1.0) - 1.0);
            if (movementManager.halfMovementHistoryCounter > 0) {
                predict *= 2.125;
            }
            if (Utilities.couldBeOnHalfblock(movingTowards) && movementManager.halfMovementHistoryCounter == 0) {
                predict *= 1.25;
            }
            if (Utilities.couldBeOnBoat(player, 0.5, true)) {
                predict *= 1.25;
            }
            if ((deltaMotionY = movementManager.motionY - movementManager.lastMotionY) < 0.0 && deltaMotionY >= -0.08 || movementManager.airTicks >= 40 && (double)(movingTowards.getBlockY() - player.getWorld().getHighestBlockYAt(movingTowards)) <= 1.5) {
                predict *= movementManager.airTicks > 60 ? 4.0 : (movementManager.airTicks > 30 ? 3.0 : 2.0);
            }
            if (VersionUtil.isSlowFalling(player)) {
                predict *= 1.25;
            }
            if (movementManager.blockingTicks > 3 && movementManager.airTicks > 2) {
                predict *= 0.8;
            }
            if (movementManager.blockingTicks > 10 && movementManager.airTicks > 2) {
                predict *= 0.5;
            }
            if (movementManager.nearLiquidTicks >= 7 && movementManager.airTicks >= 14 && movementManager.motionY < -0.18 && movementManager.motionY > -0.182) {
                predict += Math.abs(movementManager.motionY);
            }
            if (distanceXZ - predict > limit2) {
                return new CheckResult(CheckResult.Result.FAILED, "AirSpeed", "moved too fast in air (speed=" + distanceXZ + ", limit=" + predict + ", block=" + movementManager.blockingTicks + ", box=" + boxedIn + ", at=" + movementManager.airTicks + ")");
            }
        }
        if (checksConfig.isSubcheckEnabled(CheckType.SPEED, "airAcceleration") && movementManager.airTicks > 1 && movementManager.iceInfluenceTicks <= 0 && movementManager.slimeInfluenceTicks <= 0 && movementManager.elytraEffectTicks <= 0) {
            double initialAcceleration = movementManager.acceleration;
            limit = checksConfig.getDouble(CheckType.SPEED, "airAcceleration", "baseLimit");
            if (boxedIn) {
                limit *= 1.08;
            }
            if (player.hasPotionEffect(PotionEffectType.SPEED)) {
                limit += (double)VersionUtil.getPotionLevel(player, PotionEffectType.SPEED) * 0.0225;
            }
            if (movementManager.halfMovementHistoryCounter > 15) {
                limit *= 2.05;
            }
            double walkSpeedMultiplier = checksConfig.getDouble(CheckType.SPEED, "airAcceleration", "walkSpeedMultiplier");
            limit += walkSpeedMultiplier * (Math.pow(1.1, (double)player.getWalkSpeed() / 0.2 - 1.0) - 1.0);
            if (Utilities.couldBeOnBoat(player)) {
                limit *= 1.25;
            }
            if (initialAcceleration > limit) {
                return new CheckResult(CheckResult.Result.FAILED, "AirAcceleration", "exceeded acceleration limits (acceleration=" + initialAcceleration + ", max=" + limit + ")");
            }
        }
        if (checksConfig.isSubcheckEnabled(CheckType.SPEED, "jumpBehaviour") && movementManager.touchedGroundThisTick && !boxedIn && movementManager.slimeInfluenceTicks <= 10 && !Utilities.isNearHalfblock(movingTowards) && !Utilities.isNearHalfblock(movingTowards.clone().subtract(0.0, 0.51, 0.0)) && !Utilities.couldBeOnBoat(player, 0.8, false) && movementManager.airTicksBeforeGrounded == movementManager.groundTicks && (distanceXZ >= (minimumDistXZ = checksConfig.getDouble(CheckType.SPEED, "jumpBehaviour", "minimumDistXZ")) || movementManager.lastDistanceXZ >= minimumDistXZ)) {
            return new CheckResult(CheckResult.Result.FAILED, "JumpBehaviour", "had unexpected jumping behaviour (dXZ=" + Utilities.roundDouble(distanceXZ, 4) + ", lXZ=" + Utilities.roundDouble(movementManager.lastDistanceXZ, 4) + ")");
        }
        if (checksConfig.isSubcheckEnabled(CheckType.SPEED, "groundSpeed") && movementManager.groundTicks > 1) {
            double initialLimit = checksConfig.getDouble(CheckType.SPEED, "groundSpeed", "initialLimit");
            limit = initialLimit - 0.0055 * (double)Math.min(9, movementManager.groundTicks);
            if (movementManager.groundTicks < 5) {
                limit += 0.1;
            }
            if (movementManager.halfMovementHistoryCounter > 8) {
                limit += 0.2;
            }
            if (!movingTowards.getWorld().getNearbyEntities(movingTowards, 0.3, 0.3, 0.3).isEmpty()) {
                limit += 0.2;
            }
            if (boxedIn) {
                limit *= 1.1;
            }
            if (movementManager.hasSpeedEffect) {
                limit += (double)VersionUtil.getPotionLevel(player, PotionEffectType.SPEED) * 0.06;
            }
            if (movementManager.hasSpeedEffect && movementManager.groundTicks > 3) {
                limit *= 1.4;
            }
            if (movementManager.hadSpeedEffect && !movementManager.hasSpeedEffect) {
                limit *= 1.2;
            }
            if (movementManager.iceInfluenceTicks >= 50) {
                limit = !Utilities.couldBeOnIce(movingTowards) ? (limit *= 2.5) : (movementManager.topSolid && movementManager.bottomSolid ? (limit *= 3.0) : (limit *= 1.25));
            }
            if (Utilities.isNearBed(movingTowards) || Utilities.couldBeOnHalfblock(movingTowards) || Utilities.isNearBed(movingTowards.clone().add(0.0, -0.5, 0.0))) {
                limit *= 2.0;
            }
            if (Utilities.couldBeOnBoat(player)) {
                limit += 0.2;
            }
            limit += ((double)player.getWalkSpeed() - 0.2) * 2.0;
            if (player.isBlocking() && movementManager.groundTicks > 2) {
                limit *= 0.45;
            }
            if (Utilities.isInWeb(player)) {
                limit *= 0.65;
            }
            if (movementManager.sneakingTicks > 1) {
                limit *= 0.68;
            }
            if (distanceXZ - limit > 0.0) {
                return new CheckResult(CheckResult.Result.FAILED, "GroundSpeed", "moved too fast on ground (speed=" + distanceXZ + ", limit=" + limit + ", blocking=" + player.isBlocking() + ", gt=" + movementManager.groundTicks + ")");
            }
        }
        return PASS;
    }

    public static CheckResult checkVerticalSpeed(Player player, Distance distance) {
        Backend backend = AntiCheatReloaded.getManager().getBackend();
        if (SpeedCheck.isSpeedExempt(player, backend) || player.getVehicle() != null || player.isSleeping() || Utilities.isNearWater(player)) {
            return PASS;
        }
        MovementManager movementManager = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId()).getMovementManager();
        if (movementManager.riptideTicks > 0) {
            return PASS;
        }
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        if (!checksConfig.isSubcheckEnabled(CheckType.SPEED, "verticalSpeed")) {
            return PASS;
        }
        double maxMotionY = SpeedCheck.getMaxAcceptableMotionY(player, Utilities.isNearBed(distance.getTo()), Utilities.couldBeOnBoat(player), Utilities.isClimbableBlock(distance.getFrom().getBlock()) || Utilities.isClimbableBlock(distance.getFrom().getBlock().getRelative(BlockFace.DOWN)), movementManager.halfMovement, checksConfig);
        if (movementManager.nearLiquidTicks > 6) {
            maxMotionY *= 1.0525;
        }
        if (movementManager.motionY > maxMotionY && movementManager.slimeInfluenceTicks <= 0) {
            return new CheckResult(CheckResult.Result.FAILED, "VerticalSpeed", "exceeded vertical speed limit (mY=" + movementManager.motionY + ", max=" + maxMotionY + ")");
        }
        return PASS;
    }

    private static double getMaxAcceptableMotionY(Player player, boolean nearBed, boolean couldBeOnBoat, boolean fromClimbable, boolean halfMovement, Checks checksConfig) {
        double base;
        double d = couldBeOnBoat ? 0.600000025 : (nearBed ? 0.5625 : (base = halfMovement || VersionUtil.isBountifulUpdate() ? 0.6 : 0.42));
        if (fromClimbable) {
            base += checksConfig.getDouble(CheckType.SPEED, "verticalSpeed", "climbableCompensation");
        }
        if (player.hasPotionEffect(PotionEffectType.JUMP)) {
            base += (double)VersionUtil.getPotionLevel(player, PotionEffectType.JUMP) * 0.2;
        }
        return base;
    }
}

