/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.movement;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.util.MovementManager;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class WaterWalkCheck {
    private static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);

    public static CheckResult runCheck(Player player, double x, double y, double z) {
        UUID uuid = player.getUniqueId();
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(uuid);
        MovementManager movementManager = user.getMovementManager();
        if (movementManager.distanceXZ <= 0.0 || player.getVehicle() != null || Utilities.isOnLilyPad(player) || movementManager.riptideTicks > 0 || VersionUtil.isSwimming(player) || VersionUtil.isFlying(player) || player.getLocation().getBlock().getType().name().endsWith("CARPET")) {
            return PASS;
        }
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        Block blockBeneath = player.getLocation().clone().subtract(0.0, 0.1, 0.0).getBlock();
        if (checksConfig.isSubcheckEnabled(CheckType.WATER_WALK, "walk") && blockBeneath.isLiquid() && Utilities.isSurroundedByWater(player) && (movementManager.motionY == 0.0 && movementManager.lastMotionY == 0.0 || movementManager.motionY == (double)0.42f) && movementManager.distanceXZ > checksConfig.getDouble(CheckType.WATER_WALK, "walk", "minimumDistXZ") && !movementManager.topSolid && !Utilities.couldBeOnBoat(player, 3.0, false)) {
            return new CheckResult(CheckResult.Result.FAILED, "Walk", "tried to walk on water (xz=" + Utilities.roundDouble(movementManager.distanceXZ, 5) + ")");
        }
        if (checksConfig.isSubcheckEnabled(CheckType.WATER_WALK, "hop") && blockBeneath.isLiquid() && Utilities.isSurroundedByWater(player) && movementManager.onGround && Math.abs(movementManager.motionY) < checksConfig.getDouble(CheckType.WATER_WALK, "hop", "maxMotionY") && !Utilities.couldBeOnBoat(player, 0.3, false)) {
            return new CheckResult(CheckResult.Result.FAILED, "Hop", "tried to hop on water (mY=" + Utilities.roundDouble(movementManager.motionY, 5) + ")");
        }
        double minAbsMotionY = 0.12;
        if (player.hasPotionEffect(PotionEffectType.SPEED)) {
            minAbsMotionY += (double)VersionUtil.getPotionLevel(player, PotionEffectType.SPEED) * 0.05;
        }
        if (checksConfig.isSubcheckEnabled(CheckType.WATER_WALK, "lunge") && blockBeneath.isLiquid() && Utilities.isSurroundedByWater(player) && Math.abs(movementManager.lastMotionY - movementManager.motionY) > minAbsMotionY && movementManager.distanceXZ > checksConfig.getDouble(CheckType.WATER_WALK, "lunge", "minimumDistXZ") && movementManager.lastMotionY > -0.25 && !Utilities.couldBeOnBoat(player, 0.3, false)) {
            return new CheckResult(CheckResult.Result.FAILED, "Lunge", "tried to lunge in water (xz=" + Utilities.roundDouble(movementManager.distanceXZ, 5) + ", absMotionY=" + Utilities.roundDouble(Math.abs(movementManager.lastMotionY - movementManager.motionY), 5) + ")");
        }
        return PASS;
    }
}

