/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.packet;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.Backend;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.event.EventListener;
import com.rammelkast.anticheatreloaded.util.MovementManager;
import com.rammelkast.anticheatreloaded.util.User;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BadPacketsCheck {
    public static void runCheck(Player player, PacketEvent event) {
        Backend backend = AntiCheatReloaded.getManager().getBackend();
        if (!AntiCheatReloaded.getManager().getCheckManager().willCheck(player, CheckType.BADPACKETS) || backend.isMovingExempt(player) || player.isDead()) {
            return;
        }
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId());
        PacketContainer packet = event.getPacket();
        float pitch = ((Float)packet.getFloat().read(1)).floatValue();
        if (Math.abs(pitch) > 90.0f) {
            BadPacketsCheck.flag(player, event, "had an illegal pitch");
            return;
        }
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        double tps = AntiCheatReloaded.getPlugin().getTPS();
        MovementManager movementManager = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId()).getMovementManager();
        if (user.isLagging() || tps < checksConfig.getDouble(CheckType.BADPACKETS, "minimumTps") || System.currentTimeMillis() - movementManager.lastTeleport <= (long)checksConfig.getInteger(CheckType.BADPACKETS, "teleportCompensation")) {
            return;
        }
        double x = (Double)packet.getDoubles().read(0);
        double y = (Double)packet.getDoubles().read(1);
        double z = (Double)packet.getDoubles().read(2);
        float yaw = ((Float)packet.getFloat().read(0)).floatValue();
        Location previous = player.getLocation();
        Location current = new Location(previous.getWorld(), x, y, z, yaw, pitch);
        double distance = previous.distanceSquared(current);
        double maxDistance = checksConfig.getDouble(CheckType.BADPACKETS, "maxDistance");
        if (movementManager.airTicks >= 40 && movementManager.motionY < 0.0 && movementManager.lastMotionY < 0.0) {
            maxDistance *= 1.5;
        }
        boolean hasNewLocation = (Boolean)packet.getBooleans().read(0);
        if (distance > maxDistance) {
            BadPacketsCheck.flag(player, event, "moved too far between packets (distance=" + new BigDecimal(distance).setScale(1, RoundingMode.HALF_UP) + ", max=" + maxDistance + ", at=" + movementManager.airTicks + ")");
            return;
        }
        if (distance < 1.0E-10 && !hasNewLocation) {
            return;
        }
    }

    private static void flag(final Player player, PacketEvent event, final String message) {
        event.setCancelled(true);
        AntiCheatReloaded.sendToMainThread(new Runnable(){

            @Override
            public void run() {
                EventListener.log(new CheckResult(CheckResult.Result.FAILED, message).getMessage(), player, CheckType.BADPACKETS, null);
                player.teleport(player.getLocation());
            }
        });
    }
}

