/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.packet;

import com.comphenix.protocol.events.PacketEvent;
import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.event.EventListener;
import com.rammelkast.anticheatreloaded.util.User;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class MorePacketsCheck {
    public static final Map<UUID, Long> LAST_PACKET_TIME = new HashMap<UUID, Long>();
    public static final Map<UUID, Long> EXEMPT_TIMINGS = new HashMap<UUID, Long>();
    public static final Map<UUID, Double> PACKET_BALANCE = new HashMap<UUID, Double>();

    public static void runCheck(Player player, PacketEvent event) {
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        double tps = AntiCheatReloaded.getPlugin().getTPS();
        if (!AntiCheatReloaded.getManager().getCheckManager().willCheck(player, CheckType.MOREPACKETS) || tps < checksConfig.getDouble(CheckType.MOREPACKETS, "minimumTps")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(uuid);
        int maxPing = checksConfig.getInteger(CheckType.MOREPACKETS, "maxPing");
        boolean disableForLagging = checksConfig.getBoolean(CheckType.MOREPACKETS, "disableForLagging");
        if (AntiCheatReloaded.getManager().getBackend().isDoing(player, EXEMPT_TIMINGS, -1.0) || maxPing > 0 && user.getPing() > maxPing || disableForLagging && user.isLagging()) {
            return;
        }
        long packetTimeNow = System.currentTimeMillis();
        long lastPacketTime = LAST_PACKET_TIME.getOrDefault(uuid, packetTimeNow - 50L);
        double packetBalance = PACKET_BALANCE.getOrDefault(uuid, 0.0);
        long rate = packetTimeNow - lastPacketTime;
        packetBalance += 50.0;
        packetBalance -= (double)rate;
        int triggerBalance = checksConfig.getInteger(CheckType.MOREPACKETS, "triggerBalance");
        int minimumClamp = checksConfig.getInteger(CheckType.MOREPACKETS, "minimumClamp");
        if (packetBalance >= (double)triggerBalance) {
            int ticks = (int)Math.round(packetBalance / 50.0);
            packetBalance = -1 * (triggerBalance / 2);
            MorePacketsCheck.flag(player, event, "overshot timer by " + ticks + " tick(s)");
        } else if (packetBalance < (double)(-1 * minimumClamp)) {
            packetBalance = -1 * minimumClamp;
        }
        LAST_PACKET_TIME.put(uuid, packetTimeNow);
        PACKET_BALANCE.put(uuid, packetBalance);
    }

    private static void flag(final Player player, PacketEvent event, final String message) {
        event.setCancelled(true);
        AntiCheatReloaded.sendToMainThread(new Runnable(){

            @Override
            public void run() {
                EventListener.log(new CheckResult(CheckResult.Result.FAILED, message).getMessage(), player, CheckType.MOREPACKETS, null);
                player.teleport(player.getLocation());
            }
        });
    }

    public static void compensate(Player player) {
        UUID uuid = player.getUniqueId();
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        double packetBalance = PACKET_BALANCE.getOrDefault(uuid, 0.0);
        PACKET_BALANCE.put(uuid, packetBalance - (double)checksConfig.getInteger(CheckType.MOREPACKETS, "teleportCompensation"));
    }
}

