/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.check.player;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.check.combat.KillAuraCheck;
import com.rammelkast.anticheatreloaded.config.providers.Checks;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class IllegalInteract {
    private static final CheckResult PASS = new CheckResult(CheckResult.Result.PASSED);

    public static CheckResult performCheck(Player player, Event event) {
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        if (event instanceof BlockPlaceEvent && checksConfig.isSubcheckEnabled(CheckType.ILLEGAL_INTERACT, "place")) {
            return IllegalInteract.checkBlockPlace(player, (BlockPlaceEvent)event);
        }
        if (event instanceof BlockBreakEvent && checksConfig.isSubcheckEnabled(CheckType.ILLEGAL_INTERACT, "break")) {
            return IllegalInteract.checkBlockBreak(player, (BlockBreakEvent)event);
        }
        if (event instanceof PlayerInteractEvent && checksConfig.isSubcheckEnabled(CheckType.ILLEGAL_INTERACT, "interact")) {
            return IllegalInteract.checkInteract(player, (PlayerInteractEvent)event);
        }
        return PASS;
    }

    private static CheckResult checkInteract(Player player, PlayerInteractEvent event) {
        User user = AntiCheatReloaded.getManager().getUserManager().getUser(player.getUniqueId());
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        double distance = player.getEyeLocation().toVector().distance(event.getClickedBlock().getLocation().toVector());
        double maxDistance = player.getGameMode() == GameMode.CREATIVE ? checksConfig.getDouble(CheckType.ILLEGAL_INTERACT, "interact", "creativeRange") : checksConfig.getDouble(CheckType.ILLEGAL_INTERACT, "interact", "survivalRange");
        maxDistance += user.isLagging() ? 0.12 : 0.0;
        maxDistance += (double)(user.getPing() * checksConfig.getInteger(CheckType.ILLEGAL_INTERACT, "interact", "pingCompensation"));
        if (distance > (maxDistance += player.getVelocity().length() * checksConfig.getDouble(CheckType.ILLEGAL_INTERACT, "interact", "velocityMultiplier"))) {
            return new CheckResult(CheckResult.Result.FAILED, "Interact", "tried to interact out of range (dist=" + distance + ", max=" + maxDistance + ")");
        }
        return PASS;
    }

    private static CheckResult checkBlockBreak(Player player, BlockBreakEvent event) {
        if (!IllegalInteract.isValidTarget(player, event.getBlock())) {
            return new CheckResult(CheckResult.Result.FAILED, "Break", "tried to break a block which was out of view");
        }
        return PASS;
    }

    private static CheckResult checkBlockPlace(Player player, BlockPlaceEvent event) {
        if (event.getBlock().getType().isSolid() && !IllegalInteract.isValidTarget(player, event.getBlock())) {
            return new CheckResult(CheckResult.Result.FAILED, "Place", "tried to place a block out of their view");
        }
        return PASS;
    }

    private static boolean isValidTarget(Player player, Block block) {
        double playerYaw;
        Checks checksConfig = AntiCheatReloaded.getManager().getConfiguration().getChecks();
        double distance = player.getGameMode() == GameMode.CREATIVE ? 6.0 : (player.getLocation().getDirection().getY() > 0.9 ? 6.0 : 5.5);
        Block targetBlock = VersionUtil.getTargetBlock(player, (int)Math.ceil(distance));
        if (targetBlock == null) {
            return true;
        }
        if (Utilities.isClimbableBlock(targetBlock) && targetBlock.getLocation().distance(player.getLocation()) <= distance) {
            return true;
        }
        if (targetBlock.equals(block)) {
            return true;
        }
        Location eyeLocation = player.getEyeLocation();
        double yawDifference = KillAuraCheck.calculateYawDifference(eyeLocation, block.getLocation());
        double angleDifference = Math.abs(180.0 - Math.abs(Math.abs(yawDifference - (playerYaw = (double)player.getEyeLocation().getYaw())) - 180.0));
        return Math.round(angleDifference) <= (long)checksConfig.getInteger(CheckType.ILLEGAL_INTERACT, "maxAngleDifference");
    }
}

