/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.command.executors;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.command.CommandBase;
import com.rammelkast.anticheatreloaded.util.Group;
import com.rammelkast.anticheatreloaded.util.Permission;
import com.rammelkast.anticheatreloaded.util.User;
import com.rammelkast.anticheatreloaded.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class CommandReport
extends CommandBase {
    private static final String NAME = "AntiCheatReloaded Reports";
    private static final String COMMAND = "report";
    private static final String USAGE = "anticheat report [group/user]";
    private static final Permission PERMISSION = Permission.SYSTEM_REPORT;
    private static final String[] HELP = new String[]{GRAY + "Use: " + GOLD + "/anticheat report [group]" + GRAY + " to see all users in a given group", GRAY + "Use: " + GOLD + "/anticheat report [user]" + GRAY + " to see a single user's report", GRAY + "Use: " + GOLD + "/anticheat report [user/group] [num]" + GRAY + " to see pages of a report"};

    public CommandReport() {
        super(NAME, COMMAND, USAGE, HELP, PERMISSION);
    }

    @Override
    protected void execute(CommandSender cs, String[] args) {
        if (args.length >= 1) {
            int page = 1;
            if (args.length == 2) {
                if (Utilities.isInt(args[1])) {
                    page = Integer.parseInt(args[1]);
                } else {
                    cs.sendMessage(RED + "Not a valid page number: " + WHITE + args[1]);
                }
            }
            if ("low".equalsIgnoreCase(args[0])) {
                this.groupReport(cs, null, page);
            } else if ("all".equalsIgnoreCase(args[0])) {
                cs.sendMessage(GREEN + "Low: " + WHITE + USER_MANAGER.getUsersInGroup(null).size() + " players");
                for (Group g : CONFIG.getGroups().getGroups()) {
                    int numPlayers = USER_MANAGER.getUsersInGroup(g).size();
                    cs.sendMessage(g.getColor() + g.getName() + WHITE + ": " + numPlayers + " players");
                }
                cs.sendMessage(GRAY + "Use " + GOLD + "/anticheat report [group]" + GRAY + " for a list of players in each group.");
            } else {
                for (Group group : CONFIG.getGroups().getGroups()) {
                    if (!group.getName().equalsIgnoreCase(args[0]) && !"low".equalsIgnoreCase(args[0]) && !"all".equalsIgnoreCase(args[0])) continue;
                    this.groupReport(cs, group, page);
                    return;
                }
                OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)args[0]);
                if (targetPlayer == null) {
                    cs.sendMessage(RED + "Not a valid group or user: " + WHITE + args[0]);
                    return;
                }
                User user = AntiCheatReloaded.getManager().getUserManager().getUser(targetPlayer.getUniqueId());
                if (user != null) {
                    this.playerReport(cs, user, page);
                    return;
                }
                cs.sendMessage(RED + "Not a valid group or user: " + WHITE + args[0]);
            }
        } else {
            this.sendHelp(cs);
        }
    }

    private void groupReport(CommandSender cs, Group group, int page) {
        List<User> users = USER_MANAGER.getUsersInGroup(group);
        ChatColor color = group == null ? GREEN : group.getColor();
        String groupName = group == null ? "Low" : group.getName();
        int pages = (int)Math.ceil((float)users.size() / 7.0f);
        if (page <= pages && page > 0) {
            cs.sendMessage(GOLD + "----------------------[" + GRAY + "Page " + page + "/" + pages + "" + GOLD + "]----------------------");
            cs.sendMessage(GRAY + "Group: " + color + groupName);
            for (int x = 0; x < 7; ++x) {
                int index = (page - 1) * 6 + (x + (page - 1) * 1);
                if (index >= users.size()) continue;
                String player = users.get(index).getName();
                cs.sendMessage(GRAY + player);
            }
            cs.sendMessage(MENU_END);
        } else if (pages == 0) {
            cs.sendMessage(GOLD + "----------------------[" + GRAY + "Page 1/1" + GOLD + "]----------------------");
            cs.sendMessage(GRAY + "Group: " + color + groupName);
            cs.sendMessage(GRAY + "There are no users in this group.");
            cs.sendMessage(MENU_END);
        } else {
            cs.sendMessage(RED + "Page not found. Requested " + WHITE + page + RED + ", Max " + WHITE + pages);
        }
    }

    private void playerReport(CommandSender cs, User user, int page) {
        ArrayList<CheckType> types = new ArrayList<CheckType>();
        for (CheckType type : CheckType.values()) {
            if (type.getUses(user.getUUID()) <= 0) continue;
            types.add(type);
        }
        UUID uuid = user.getUUID();
        String name = user.getName();
        int pages = (int)Math.ceil((float)types.size() / 6.0f);
        Group group = user.getGroup();
        String groupString = GREEN + "Low";
        if (group != null) {
            groupString = group.getColor() + group.getName();
        }
        groupString = groupString + " (" + user.getLevel() + ")";
        if (page <= pages && page > 0) {
            cs.sendMessage(GOLD + "----------------------[" + GRAY + "Page " + page + "/" + pages + "" + GOLD + "]----------------------");
            cs.sendMessage(GRAY + "Player: " + WHITE + name);
            int ping = user.getPing();
            cs.sendMessage(GRAY + "Ping: " + (ping == -1 ? RED + "Offline" : WHITE + "" + ping + "ms " + (user.isLagging() ? ChatColor.RED + "(lagging)" : ChatColor.GREEN + "(not lagging)")));
            cs.sendMessage(GRAY + "Group: " + groupString);
            for (int x = 0; x < 6; ++x) {
                int index = (page - 1) * 5 + (x + (page - 1));
                if (index >= types.size()) continue;
                CheckType type = (CheckType)((Object)types.get(index));
                int use = type.getUses(uuid);
                ChatColor color = WHITE;
                if (use >= 20) {
                    color = YELLOW;
                } else if (use > 50) {
                    color = RED;
                }
                cs.sendMessage(GRAY + type.getName() + ": " + color + use);
            }
            cs.sendMessage(MENU_END);
        } else if (pages == 0 && page == 1) {
            cs.sendMessage(GOLD + "----------------------[" + GRAY + "Page 1/1" + GOLD + "]----------------------");
            cs.sendMessage(GRAY + "Player: " + WHITE + name);
            int ping = user.getPing();
            cs.sendMessage(GRAY + "Ping: " + (ping == -1 ? RED + "Offline" : WHITE + "" + ping + "ms " + (user.isLagging() ? ChatColor.RED + "(lagging)" : ChatColor.GREEN + "(not lagging)")));
            cs.sendMessage(GRAY + "Group: " + groupString);
            cs.sendMessage(GRAY + "This user has not failed any checks.");
            cs.sendMessage(MENU_END);
        } else {
            cs.sendMessage(RED + "Page not found. Requested " + WHITE + page + RED + ", Max " + WHITE + pages + 1);
        }
    }
}

