/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.config;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.util.enterprise.Database;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ConfigurationTable {
    private final String table;
    private final Configuration config;
    private Database database;
    private String prefix;
    private String serverName;

    public ConfigurationTable(Configuration config, String table) {
        this.config = config;
        this.table = table;
        this.load();
    }

    public void load() {
        this.database = this.config.getEnterprise().database;
        this.prefix = this.database.getPrefix();
        this.serverName = this.config.getEnterprise().serverName.getValue();
        this.open();
    }

    public void open() {
    }

    public void reload() {
        Bukkit.getScheduler().runTask((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ConfigurationTable.this.load();
            }
        });
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getFullTable() {
        return this.prefix + this.table;
    }

    public boolean tableExists() {
        try {
            return this.getConnection().getMetaData().getTables(null, null, this.getFullTable(), null).next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isUUIDFormatted(String colName) {
        String sqlSelect = "SELECT " + colName + " FROM " + this.getFullTable() + " LIMIT 1";
        try {
            String user;
            ResultSet res = this.getConnection().prepareStatement(sqlSelect).executeQuery();
            if (res.next() && (user = res.getString(colName)) != null) {
                try {
                    return UUID.fromString(user) != null;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void convertToUUID(String colName) {
        String sqlSelect = "SELECT " + colName + " FROM " + this.getFullTable();
        String sqlUpdate = "UPDATE " + this.getFullTable() + " SET " + colName + " = ? WHERE " + colName + " = ?";
        try {
            ResultSet res = this.getConnection().prepareStatement(sqlSelect).executeQuery();
            while (res.next()) {
                PreparedStatement stmt = this.getConnection().prepareStatement(sqlUpdate);
                stmt.setString(1, Bukkit.getOfflinePlayer((String)res.getString(1)).getUniqueId().toString());
                stmt.setString(2, res.getString(1));
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public Connection getConnection() {
        return this.database.getConnection();
    }
}

