/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.config.holders.mysql;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.config.ConfigurationTable;
import com.rammelkast.anticheatreloaded.config.providers.Levels;
import com.rammelkast.anticheatreloaded.util.User;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MySQLLevelsHolder
extends ConfigurationTable
implements Levels {
    private static final String TABLE = "levels";
    private static final String MANUAL_EDIT_TAG = "MANUAL";
    private String sqlSave;
    private String sqlLoad;
    private String sqlUpdate;

    public MySQLLevelsHolder(Configuration config) {
        super(config, TABLE);
    }

    @Override
    public void open() {
        this.sqlSave = "INSERT INTO " + this.getFullTable() + " (user, level, last_update_server) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE level = IF(last_update = ?, ?, level+?), last_update=CURRENT_TIMESTAMP, last_update_server=?";
        this.sqlLoad = "SELECT level, last_update FROM " + this.getFullTable() + " WHERE user = ?";
        this.sqlUpdate = "SELECT level, last_update FROM " + this.getFullTable() + " WHERE user = ? AND last_update <> ? AND last_update_server = ?";
        String sqlCreate = "CREATE TABLE " + this.getFullTable() + "(  `user` VARCHAR(45) NOT NULL,  `level` INT NOT NULL,  `last_update` TIMESTAMP NOT NULL DEFAULT NOW(),  `last_update_server` VARCHAR(45) NOT NULL,  PRIMARY KEY (`user`));";
        try {
            if (!this.tableExists()) {
                this.getConnection().prepareStatement(sqlCreate).executeUpdate();
                this.getConnection().commit();
            } else if (!this.isUUIDFormatted("user")) {
                this.convertToUUID("user");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveLevelFromUser(final User user) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (!user.isWaitingOnLevelSync()) {
                    AntiCheatReloaded.debugLog("Saving level from " + user.getUUID() + ". Value: " + user.getLevel());
                    try {
                        PreparedStatement statement = MySQLLevelsHolder.this.getConnection().prepareStatement(MySQLLevelsHolder.this.sqlSave);
                        statement.setString(1, user.getUUID().toString());
                        statement.setInt(2, user.getLevel());
                        statement.setString(3, MySQLLevelsHolder.this.getServerName());
                        statement.setTimestamp(4, user.getLevelSyncTimestamp());
                        statement.setInt(5, user.getLevel());
                        statement.setInt(6, user.getLevel());
                        statement.setString(7, MySQLLevelsHolder.this.getServerName());
                        statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                AntiCheatReloaded.getManager().getUserManager().remove(user);
            }
        });
    }

    @Override
    public void loadLevelToUser(final User user) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    PreparedStatement statement = MySQLLevelsHolder.this.getConnection().prepareStatement(MySQLLevelsHolder.this.sqlLoad);
                    statement.setString(1, user.getUUID().toString());
                    ResultSet set = statement.executeQuery();
                    boolean has = false;
                    while (set.next()) {
                        has = true;
                        AntiCheatReloaded.debugLog("Syncing level to " + user.getUUID() + ". Value: " + set.getInt("level"));
                        user.setLevel(set.getInt("level"));
                        user.setLevelSyncTimestamp(set.getTimestamp("last_update"));
                    }
                    if (!has) {
                        user.setLevel(0);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void saveLevelsFromUsers(List<User> users) {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement(this.sqlSave);
            for (User user : users) {
                if (user.isWaitingOnLevelSync()) continue;
                try {
                    statement.setString(1, user.getUUID().toString());
                    statement.setInt(2, user.getLevel());
                    statement.setString(3, this.getServerName());
                    statement.setTimestamp(4, user.getLevelSyncTimestamp());
                    statement.setInt(5, user.getLevel());
                    statement.setInt(6, user.getLevel());
                    statement.setString(7, this.getServerName());
                    statement.addBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            statement.executeBatch();
            this.getConnection().commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateLevelToUser(final User user) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AntiCheatReloaded.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    PreparedStatement statement = MySQLLevelsHolder.this.getConnection().prepareStatement(MySQLLevelsHolder.this.sqlUpdate);
                    statement.setString(1, user.getUUID().toString());
                    statement.setTimestamp(2, user.getLevelSyncTimestamp());
                    statement.setString(3, MySQLLevelsHolder.MANUAL_EDIT_TAG);
                    ResultSet set = statement.executeQuery();
                    while (set.next()) {
                        AntiCheatReloaded.debugLog("Syncing level to " + user.getUUID() + ". Value: " + set.getInt("level"));
                        user.setLevel(set.getInt("level"));
                        user.setLevelSyncTimestamp(set.getTimestamp("last_update"));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

