/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.config.holders.yaml;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.config.ConfigurationFile;
import com.rammelkast.anticheatreloaded.config.providers.Levels;
import com.rammelkast.anticheatreloaded.util.User;
import java.util.List;
import java.util.UUID;

public class YamlLevelsHolder
extends ConfigurationFile
implements Levels {
    public static final String FILENAME = "data/levels.yml";

    public YamlLevelsHolder(AntiCheatReloaded plugin, Configuration config) {
        super(plugin, config, FILENAME, false);
    }

    @Override
    public void loadLevelToUser(User user) {
        user.setLevel(this.getLevel(user.getUUID()));
    }

    @Override
    public void saveLevelFromUser(User user) {
        this.saveLevelFromUser(user, true);
    }

    private void saveLevelFromUser(User user, boolean remove) {
        this.saveLevel(user.getUUID(), user.getLevel());
        if (remove) {
            AntiCheatReloaded.getManager().getUserManager().remove(user);
        }
    }

    @Override
    public void saveLevelsFromUsers(List<User> users) {
        for (User user : users) {
            this.saveLevelFromUser(user, false);
        }
    }

    @Override
    public void updateLevelToUser(User user) {
    }

    private int getLevel(UUID uuid) {
        ConfigurationFile.ConfigValue level = new ConfigurationFile.ConfigValue(uuid.toString(), false);
        if (level.hasValue()) {
            return (Integer)level.getValue();
        }
        return 0;
    }

    private void saveLevel(UUID uuid, int level) {
        new ConfigurationFile.ConfigValue<Integer>(uuid.toString(), false).setValue(level);
    }
}

