/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.config.yaml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class CommentedConfiguration
extends YamlConfiguration {
    private Map<Integer, String> comments = new HashMap<Integer, String>();
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private final Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);

    public void loadFromString(String contents) throws InvalidConfigurationException {
        Map input;
        Validate.notNull((Object)contents, (String)"Contents cannot be null");
        try {
            input = (Map)this.yaml.load(contents);
        }
        catch (YAMLException e) {
            throw new InvalidConfigurationException((Throwable)e);
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("Top level is not a Map.");
        }
        if (input != null) {
            this.convertMapsToSections(input, (ConfigurationSection)this);
        }
        int i = 0;
        int blank = 0;
        String[] lines = contents.split("\n");
        while (i < lines.length) {
            if (lines[i].trim().equalsIgnoreCase("")) {
                ++i;
                ++blank;
                continue;
            }
            if (lines[i].contains("# ")) {
                this.comments.put(i - blank, lines[i]);
            }
            ++i;
        }
    }

    public String saveToString() {
        this.yamlOptions.setIndent(this.options().indent());
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        String dump = this.yaml.dump((Object)this.getValues(false));
        if (dump.equals("{}\n")) {
            dump = "";
        }
        StringBuilder builder = new StringBuilder();
        String[] lines = dump.split("\n");
        ArrayDeque<String> queue = new ArrayDeque<String>();
        for (String string : lines) {
            queue.add(string);
        }
        int i = 0;
        while (queue.size() > 0) {
            if (this.comments.containsKey(i)) {
                builder.append(this.comments.get(i));
                int b = i;
                while (this.comments.containsKey(++b)) {
                    builder.append('\n');
                    builder.append(this.comments.get(b));
                }
                builder.append('\n');
                i = b;
            }
            builder.append((String)queue.getFirst());
            builder.append('\n');
            queue.pop();
            ++i;
        }
        return builder.toString();
    }

    public static CommentedConfiguration loadConfiguration(File file) {
        Validate.notNull((Object)file, (String)"File cannot be null");
        CommentedConfiguration config = new CommentedConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
        }
        catch (InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
        }
        return config;
    }

    public static CommentedConfiguration loadConfiguration(InputStream stream) {
        Validate.notNull((Object)stream, (String)"Stream cannot be null");
        CommentedConfiguration config = new CommentedConfiguration();
        try {
            InputStreamReader reader = new InputStreamReader(stream);
            config.load(reader);
            reader.close();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load configuration from stream", ex);
        }
        catch (InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load configuration from stream", ex);
        }
        return config;
    }
}

