/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.event;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.check.player.IllegalInteract;
import com.rammelkast.anticheatreloaded.event.EventListener;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockListener
extends EventListener {
    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        CheckResult result;
        Player player = event.getPlayer();
        boolean noHack = true;
        if (BlockListener.getCheckManager().willCheck(player, CheckType.FAST_PLACE) && (result = BlockListener.getBackend().checkFastPlace(player)).failed()) {
            event.setCancelled(!BlockListener.silentMode());
            BlockListener.log(result.getMessage(), player, CheckType.FAST_PLACE, result.getSubCheck());
            noHack = false;
        }
        if (BlockListener.getCheckManager().willCheck(player, CheckType.ILLEGAL_INTERACT) && (result = IllegalInteract.performCheck(player, (Event)event)).failed()) {
            event.setCancelled(!BlockListener.silentMode());
            BlockListener.log(result.getMessage(), player, CheckType.ILLEGAL_INTERACT, result.getSubCheck());
            noHack = false;
        }
        if (noHack) {
            BlockListener.decrease(player);
            BlockListener.getBackend().logBlockPlace(player);
        }
        AntiCheatReloaded.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        CheckResult result;
        Player player = event.getPlayer();
        boolean noHack = true;
        if (BlockListener.getCheckManager().willCheck(player, CheckType.ILLEGAL_INTERACT) && (result = IllegalInteract.performCheck(player, (Event)event)).failed()) {
            event.setCancelled(!BlockListener.silentMode());
            BlockListener.log(result.getMessage(), player, CheckType.ILLEGAL_INTERACT, result.getSubCheck());
            noHack = false;
        }
        if (noHack) {
            BlockListener.decrease(player);
        }
        BlockListener.getBackend().logBlockBreak(player);
    }
}

