/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.event;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.CheckResult;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.check.combat.CriticalsCheck;
import com.rammelkast.anticheatreloaded.check.combat.KillAuraCheck;
import com.rammelkast.anticheatreloaded.event.EventListener;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class EntityListener
extends EventListener {
    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (EntityListener.getCheckManager().willCheck(player, CheckType.FAST_BOW)) {
                CheckResult result = EntityListener.getBackend().checkFastBow(player, event.getForce());
                if (result.failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.FAST_BOW, result.getSubCheck());
                } else {
                    EntityListener.decrease(player);
                }
            }
        }
        AntiCheatReloaded.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (event.getEntity() instanceof Player && event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED) {
            Player player = (Player)event.getEntity();
            if (EntityListener.getCheckManager().willCheck(player, CheckType.FAST_HEAL)) {
                CheckResult result = EntityListener.getBackend().checkFastHeal(player);
                if (result.failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.FAST_HEAL, result.getSubCheck());
                } else {
                    EntityListener.decrease(player);
                    EntityListener.getBackend().logHeal(player);
                }
            }
        }
        AntiCheatReloaded.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).getFoodLevel() < event.getFoodLevel() && EntityListener.getCheckManager().willCheck(player, CheckType.FAST_EAT)) {
            CheckResult result = EntityListener.getBackend().checkFastEat(player);
            if (result.failed()) {
                event.setCancelled(!EntityListener.silentMode());
                EntityListener.log(result.getMessage(), player, CheckType.FAST_EAT, result.getSubCheck());
            } else {
                EntityListener.decrease(player);
            }
        }
        AntiCheatReloaded.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        boolean noHack = true;
        if (event instanceof EntityDamageByEntityEvent) {
            Player player;
            EntityDamageByEntityEvent e = (EntityDamageByEntityEvent)event;
            if (e.getDamager() instanceof Player && EntityListener.getCheckManager().willCheck((Player)e.getDamager(), CheckType.CRITICALS)) {
                CriticalsCheck.doDamageEvent(e, (Player)e.getDamager());
            }
            if (event.getEntity() instanceof Player) {
                player = (Player)event.getEntity();
                if (e.getDamager() instanceof Player) {
                    Player p = (Player)e.getDamager();
                    EntityListener.getBackend().logDamage(p, 1);
                    int value = VersionUtil.getItemInHand(player).containsEnchantment(Enchantment.KNOCKBACK) ? 2 : 1;
                    EntityListener.getBackend().logDamage(player, value);
                } else if (e.getDamager() instanceof TNTPrimed || e.getDamager() instanceof Creeper) {
                    EntityListener.getBackend().logDamage(player, 3);
                } else {
                    EntityListener.getBackend().logDamage(player, 1);
                }
            }
            if (e.getDamager() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                CheckResult result;
                player = (Player)e.getDamager();
                if (EntityListener.getCheckManager().willCheck(player, CheckType.KILLAURA) && (result = KillAuraCheck.checkAngle(player, event)).failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.KILLAURA, result.getSubCheck());
                    noHack = false;
                }
                if (EntityListener.getCheckManager().willCheck(player, CheckType.KILLAURA) && (result = KillAuraCheck.checkReach(player, event.getEntity())).failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.KILLAURA, result.getSubCheck());
                    noHack = false;
                }
                if (EntityListener.getCheckManager().willCheck(player, CheckType.KILLAURA) && (result = KillAuraCheck.checkPacketOrder(player, event.getEntity())).failed()) {
                    event.setCancelled(!EntityListener.silentMode());
                    EntityListener.log(result.getMessage(), player, CheckType.KILLAURA, result.getSubCheck());
                    noHack = false;
                }
                if (noHack) {
                    EntityListener.decrease(player);
                }
            }
        }
        AntiCheatReloaded.getManager().addEvent(event.getEventName(), event.getHandlers().getRegisteredListeners());
    }
}

