/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.event;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.Backend;
import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.manage.AntiCheatManager;
import com.rammelkast.anticheatreloaded.manage.CheckManager;
import com.rammelkast.anticheatreloaded.manage.UserManager;
import com.rammelkast.anticheatreloaded.util.User;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class EventListener
implements Listener {
    private static final Map<CheckType, Integer> USAGE_LIST = new EnumMap<CheckType, Integer>(CheckType.class);
    private static final Map<UUID, Integer> DECREASE_LIST = new HashMap<UUID, Integer>();
    private static final CheckManager CHECK_MANAGER = AntiCheatReloaded.getManager().getCheckManager();
    private static final Backend BACKEND = AntiCheatReloaded.getManager().getBackend();
    private static final AntiCheatReloaded PLUGIN = AntiCheatReloaded.getManager().getPlugin();
    private static final UserManager USER_MANAGER = AntiCheatReloaded.getManager().getUserManager();
    private static final Configuration CONFIG = AntiCheatReloaded.getManager().getConfiguration();
    private static final DecimalFormat TPS_FORMAT = new DecimalFormat("##.##");

    public static void log(String message, Player player, CheckType type, String subcheck) {
        User user = EventListener.getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            return;
        }
        boolean debugMode = EventListener.CONFIG.getConfig().debugMode.getValue();
        int vlForType = type.getUses(player.getUniqueId()) + 1;
        int notifyEveryVl = EventListener.CONFIG.getConfig().notifyEveryVl.getValue();
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)CONFIG.getLang().ALERT_PREFIX());
        message = message == null || message.equals("") ? (debugMode ? prefix + player.getName() + " failed " + type.getName() : prefix + player.getName() + " failed " + type.getName() + ChatColor.GOLD + " (x" + vlForType + ")") : (debugMode ? prefix + player.getName() + " failed " + type.getName() + ChatColor.DARK_GRAY + " | " + ChatColor.GRAY + message + ChatColor.DARK_GRAY + " | " + ChatColor.GRAY + "ping: " + user.getPing() + "ms, tps: " + TPS_FORMAT.format(AntiCheatReloaded.getPlugin().getTPS()) : prefix + player.getName() + " failed " + type.getName() + ChatColor.GOLD + " (x" + vlForType + ")" + ChatColor.DARK_GRAY + " | " + ChatColor.GRAY + (subcheck != null ? "type: " + subcheck.toLowerCase() + ", " : "") + "ping: " + user.getPing() + "ms, tps: " + TPS_FORMAT.format(AntiCheatReloaded.getPlugin().getTPS()));
        EventListener.logCheat(type, user);
        if (user.increaseLevel(type) && !debugMode && vlForType % notifyEveryVl == 0) {
            AntiCheatReloaded.getManager().log(message);
        }
        EventListener.removeDecrease(user);
        if (debugMode) {
            player.sendMessage(message);
            return;
        }
        if (vlForType % notifyEveryVl == 0) {
            AntiCheatReloaded.getPlugin().sendToStaff(message);
        }
    }

    private static void logCheat(CheckType type, User user) {
        USAGE_LIST.put(type, EventListener.getCheats(type) + 1);
        if (user != null && user.getUUID() != null) {
            type.logUse(user);
            if (EventListener.CONFIG.getConfig().enterprise.getValue().booleanValue() && EventListener.CONFIG.getEnterprise().loggingEnabled.getValue().booleanValue()) {
                EventListener.CONFIG.getEnterprise().database.logEvent(user, type);
            }
        }
    }

    public void resetCheck(CheckType type) {
        USAGE_LIST.put(type, 0);
    }

    public static int getCheats(CheckType type) {
        int x = 0;
        if (USAGE_LIST.get((Object)type) != null) {
            x = USAGE_LIST.get((Object)type);
        }
        return x;
    }

    private static void removeDecrease(User user) {
        int x = 0;
        if (user.getUUID() != null) {
            if (DECREASE_LIST.get(user.getUUID()) != null) {
                x = DECREASE_LIST.get(user.getUUID());
                if ((x -= 2) < 0) {
                    x = 0;
                }
            }
            DECREASE_LIST.put(user.getUUID(), x);
        }
    }

    public static void decrease(Player player) {
        User user = EventListener.getUserManager().getUser(player.getUniqueId());
        if (user.getUUID() != null) {
            int x = 0;
            if (DECREASE_LIST.get(user.getUUID()) != null) {
                x = DECREASE_LIST.get(user.getUUID());
            }
            DECREASE_LIST.put(user.getUUID(), ++x);
            if (x >= 10) {
                user.decreaseLevel();
                DECREASE_LIST.put(user.getUUID(), 0);
            }
        }
    }

    public static CheckManager getCheckManager() {
        return CHECK_MANAGER;
    }

    public static AntiCheatManager getManager() {
        return AntiCheatReloaded.getManager();
    }

    public static Backend getBackend() {
        return BACKEND;
    }

    public static UserManager getUserManager() {
        return USER_MANAGER;
    }

    public static AntiCheatReloaded getPlugin() {
        return PLUGIN;
    }

    public static Configuration getConfig() {
        return CONFIG;
    }

    public static boolean silentMode() {
        return EventListener.CONFIG.getConfig().silentMode.getValue();
    }

    static {
        TPS_FORMAT.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    }
}

