/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.manage;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.check.Backend;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.manage.CheckManager;
import com.rammelkast.anticheatreloaded.manage.LoggingManager;
import com.rammelkast.anticheatreloaded.manage.UserManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.plugin.RegisteredListener;

public class AntiCheatManager {
    private static AntiCheatReloaded plugin = null;
    private static Configuration configuration;
    private static UserManager userManager;
    private static CheckManager checkManager;
    private static LoggingManager loggingManager;
    private static Backend backend;
    private static Map<String, RegisteredListener[]> eventchains;
    private static Map<String, Long> eventcache;

    public AntiCheatManager(AntiCheatReloaded instance, Logger logger) {
        plugin = instance;
        configuration = new Configuration(plugin, this);
        loggingManager = new LoggingManager(plugin, logger, configuration);
        userManager = new UserManager(this);
        checkManager = new CheckManager(this);
        backend = new Backend(this);
    }

    public void log(String message) {
        loggingManager.log(message);
    }

    public void debugLog(String message) {
        loggingManager.debugLog(message);
    }

    public void playerLog(String message) {
        loggingManager.logToPlayers(message);
    }

    public void addEvent(String e, RegisteredListener[] arr) {
        if (!AntiCheatManager.configuration.getConfig().eventChains.getValue().booleanValue()) {
            return;
        }
        if (!eventcache.containsKey(e) || eventcache.get(e) > 30000L) {
            eventchains.put(e, arr);
            eventcache.put(e, System.currentTimeMillis());
        }
    }

    public String getEventChainReport() {
        String gen = "";
        if (!AntiCheatManager.configuration.getConfig().eventChains.getValue().booleanValue()) {
            return "Event Chains is disabled by the configuration.\n";
        }
        if (eventchains.entrySet().size() == 0) {
            return "No event chains found.\n";
        }
        for (Map.Entry<String, RegisteredListener[]> e : eventchains.entrySet()) {
            RegisteredListener[] reg;
            String toadd = "";
            String ename = e.getKey();
            toadd = toadd + ename + ":" + '\n';
            for (RegisteredListener plug : reg = e.getValue()) {
                String pluginname = plug.getPlugin().getName();
                if (pluginname.equals("AntiCheat")) {
                    pluginname = "self";
                }
                toadd = toadd + "- " + pluginname + '\n';
            }
            gen = gen + toadd + '\n';
        }
        return gen;
    }

    public AntiCheatReloaded getPlugin() {
        return plugin;
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    public UserManager getUserManager() {
        return userManager;
    }

    public CheckManager getCheckManager() {
        return checkManager;
    }

    public Backend getBackend() {
        return backend;
    }

    public LoggingManager getLoggingManager() {
        return loggingManager;
    }

    public static void close() {
        loggingManager.closeHandler();
        if (AntiCheatManager.configuration.getConfig().enterprise.getValue().booleanValue()) {
            AntiCheatManager.configuration.getEnterprise().database.shutdown();
        }
    }

    static {
        userManager = null;
        checkManager = null;
        loggingManager = null;
        backend = null;
        eventchains = new ConcurrentHashMap<String, RegisteredListener[]>();
        eventcache = new ConcurrentHashMap<String, Long>();
    }
}

