/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.manage;

import com.rammelkast.anticheatreloaded.check.CheckType;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.manage.AntiCheatManager;
import com.rammelkast.anticheatreloaded.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class CheckManager {
    private AntiCheatManager manager = null;
    private Configuration config;
    private static List<CheckType> checkIgnoreList = new ArrayList<CheckType>();
    private static Map<UUID, List<CheckType>> exemptList = new HashMap<UUID, List<CheckType>>();

    public CheckManager(AntiCheatManager manager) {
        this.manager = manager;
        this.config = manager.getConfiguration();
        this.loadCheckIgnoreList(this.config);
    }

    public void loadCheckIgnoreList(Configuration configuration) {
        checkIgnoreList.clear();
        for (CheckType type : CheckType.values()) {
            if (configuration.getChecks().isEnabled(type)) continue;
            checkIgnoreList.add(type);
        }
        if (!checkIgnoreList.isEmpty()) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "ACR " + ChatColor.DARK_GRAY + "> " + ChatColor.GRAY + checkIgnoreList.size() + " check(s) have been disabled");
        }
    }

    public void activateCheck(CheckType type, String className) {
        if (!this.isActive(type)) {
            this.manager.getLoggingManager().logFineInfo("The " + type.toString() + " check was activated by " + className + ".");
            checkIgnoreList.remove((Object)type);
        }
    }

    public void deactivateCheck(CheckType type, String className) {
        if (this.isActive(type)) {
            this.manager.getLoggingManager().logFineInfo("The " + type.toString() + " check was deactivated by " + className + ".");
            checkIgnoreList.add(type);
        }
    }

    public boolean isActive(CheckType type) {
        return !checkIgnoreList.contains((Object)type);
    }

    public void exemptPlayer(Player player, CheckType type, String className) {
        if (!this.isExempt(player, type)) {
            if (!exemptList.containsKey(player.getUniqueId())) {
                exemptList.put(player.getUniqueId(), new ArrayList());
            }
            this.manager.getLoggingManager().logFineInfo(player.getName() + " was exempted from the " + type.toString() + " check by " + className + ".");
            exemptList.get(player.getUniqueId()).add(type);
        }
    }

    public void unexemptPlayer(Player player, CheckType type, String className) {
        if (this.isExempt(player, type)) {
            this.manager.getLoggingManager().logFineInfo(player.getName() + " was unexempted from the " + type.toString() + " check by " + className + ".");
            exemptList.get(player.getUniqueId()).remove((Object)type);
        }
    }

    public boolean isExempt(Player player, CheckType type) {
        return exemptList.containsKey(player.getUniqueId()) ? exemptList.get(player.getUniqueId()).contains((Object)type) : false;
    }

    public boolean isOpExempt(Player player) {
        return this.manager.getConfiguration().getConfig().exemptOp.getValue() != false && player.isOp();
    }

    public boolean checkInWorld(Player player) {
        return !this.config.getConfig().disabledWorlds.getValue().contains(player.getWorld().getName());
    }

    public boolean willCheckQuick(Player player, CheckType type) {
        return this.isActive(type) && !this.isExempt(player, type) && !type.checkPermission(player);
    }

    public boolean willCheck(Player player, CheckType type) {
        boolean check;
        boolean bl = check = this.isActive(type) && this.checkInWorld(player) && !this.isExempt(player, type) && !type.checkPermission(player) && !this.isOpExempt(player);
        if ((type == CheckType.FLIGHT || type == CheckType.SPEED) && VersionUtil.isFlying(player)) {
            return false;
        }
        return check;
    }

    public boolean isOnline(Player player) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.getUniqueId().equals(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }
}

