/*
 * Decompiled with CFR 0.152.
 */
package com.rammelkast.anticheatreloaded.manage;

import com.rammelkast.anticheatreloaded.AntiCheatReloaded;
import com.rammelkast.anticheatreloaded.config.Configuration;
import com.rammelkast.anticheatreloaded.util.FileFormatter;
import com.rammelkast.anticheatreloaded.util.Permission;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LoggingManager {
    private final Logger fileLogger = Logger.getLogger("com.rammelkast.anticheatreloaded.AntiCheatReloaded");
    private static Handler fileHandler;
    private static List<String> logs;
    private final Configuration config;

    public LoggingManager(AntiCheatReloaded plugin, Logger logger, Configuration config) {
        this.config = config;
        try {
            File file = new File(plugin.getDataFolder(), "log");
            if (!file.exists()) {
                file.mkdir();
            }
            fileHandler = new FileHandler(plugin.getDataFolder() + "/log/anticheat.log", true);
            fileHandler.setFormatter(new FileFormatter());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.fileLogger.setUseParentHandlers(false);
        this.fileLogger.addHandler(fileHandler);
    }

    public void log(String message) {
        if (this.config.getConfig().logToConsole.getValue().booleanValue()) {
            this.logToConsole(message);
        }
        if (this.config.getConfig().logToFile.getValue().booleanValue()) {
            this.logToFile(message);
        }
        this.logToLogs(message);
    }

    public void debugLog(String message) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "ACR " + ChatColor.GRAY + message);
        this.logToLogs(message);
    }

    public void logToConsole(String message) {
        Bukkit.getConsoleSender().sendMessage(message);
    }

    public void logToFile(String message) {
        this.fileLogger.info(ChatColor.stripColor((String)message));
    }

    public void logFineInfo(String message) {
        this.logToFile(message);
        this.logToLogs(message);
    }

    public void logToPlayers(String message) {
        if (this.config.getConfig().disableBroadcast.getValue().booleanValue()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!Permission.SYSTEM_NOTICE.get((CommandSender)player)) continue;
            player.sendMessage(message);
        }
    }

    private void logToLogs(String message) {
        logs.add(ChatColor.stripColor((String)message));
    }

    public List<String> getLastLogs() {
        CopyOnWriteArrayList<String> log = new CopyOnWriteArrayList<String>();
        if (logs.size() < 30) {
            return logs;
        }
        for (int i = logs.size() - 1; i >= 0; --i) {
            log.add(logs.get(i));
        }
        logs.clear();
        return log;
    }

    public void closeHandler() {
        fileHandler.close();
    }

    static {
        logs = new CopyOnWriteArrayList<String>();
    }
}

